/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Window;
import java.lang.reflect.Field;
import java.util.Arrays;
import javax.swing.FocusManager;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ModeContainer;
import org.netbeans.core.windows.view.ModeView;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.core.windows.view.ui.Tabbed;
import org.netbeans.core.windows.view.ui.TabbedHandler;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public abstract class AbstractModeContainer
implements ModeContainer {
    protected final ModeView modeView;
    protected final TabbedHandler tabbedHandler;
    protected final WindowDnDManager windowDnDManager;
    private final int kind;

    public AbstractModeContainer(ModeView modeView, WindowDnDManager windowDnDManager, int kind) {
        this.modeView = modeView;
        this.windowDnDManager = windowDnDManager;
        this.kind = kind;
        this.tabbedHandler = new TabbedHandler(modeView, kind, this.createTabbed());
    }

    public ModeView getModeView() {
        return this.modeView;
    }

    public Component getComponent() {
        return this.getModeComponent();
    }

    protected abstract Component getModeComponent();

    protected abstract Tabbed createTabbed();

    public void addTopComponent(TopComponent tc) {
        this.tabbedHandler.addTopComponent(tc, this.kind);
    }

    public void removeTopComponent(TopComponent tc) {
        this.tabbedHandler.removeTopComponent(tc);
        TopComponent selected = this.tabbedHandler.getSelectedTopComponent();
        this.updateTitle(selected == null ? "" : WindowManagerImpl.getInstance().getTopComponentDisplayName(selected));
    }

    public void setSelectedTopComponent(TopComponent tc) {
        this.tabbedHandler.setSelectedTopComponent(tc);
        this.updateTitle(WindowManagerImpl.getInstance().getTopComponentDisplayName(tc));
    }

    public void setTopComponents(TopComponent[] tcs, TopComponent selected) {
        if (!Arrays.equals(tcs, this.getTopComponents())) {
            this.tabbedHandler.setTopComponents(tcs, selected);
            this.updateTitle(WindowManagerImpl.getInstance().getTopComponentDisplayName(selected));
        } else {
            this.setSelectedTopComponent(selected);
        }
    }

    protected abstract void updateTitle(String var1);

    protected abstract void updateActive(boolean var1);

    public TopComponent getSelectedTopComponent() {
        return this.tabbedHandler.getSelectedTopComponent();
    }

    public void setActive(boolean active) {
        this.updateActive(active);
        TopComponent selected = this.tabbedHandler.getSelectedTopComponent();
        this.updateTitle(selected == null ? "" : WindowManagerImpl.getInstance().getTopComponentDisplayName(selected));
        this.tabbedHandler.setActive(active);
    }

    public void focusSelectedTopComponent() {
        final TopComponent selectedTopComponent = this.tabbedHandler.getSelectedTopComponent();
        if (selectedTopComponent == null) {
            return;
        }
        Window oldFocusedW = FocusManager.getCurrentManager().getFocusedWindow();
        Window newFocusedW = SwingUtilities.getWindowAncestor((Component)selectedTopComponent);
        if (newFocusedW != null && newFocusedW.equals(oldFocusedW)) {
            if (!Utilities.isMac()) {
                selectedTopComponent.requestFocusInWindow();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            Field fld = KeyboardFocusManager.class.getDeclaredField("focusOwner");
                            fld.setAccessible(true);
                            fld.set(KeyboardFocusManager.getCurrentKeyboardFocusManager(), null);
                        }
                        catch (IllegalArgumentException ex) {
                            ex.printStackTrace();
                        }
                        catch (SecurityException ex) {
                            ex.printStackTrace();
                        }
                        catch (NoSuchFieldException ex) {
                            ex.printStackTrace();
                        }
                        catch (IllegalAccessException ex) {
                            ex.printStackTrace();
                        }
                        selectedTopComponent.requestFocusInWindow();
                    }
                });
            }
        } else {
            selectedTopComponent.requestFocus();
        }
    }

    public TopComponent[] getTopComponents() {
        return this.tabbedHandler.getTopComponents();
    }

    public void updateName(TopComponent tc) {
        TopComponent selected = this.getSelectedTopComponent();
        if (tc == selected) {
            this.updateTitle(tc == null ? "" : WindowManagerImpl.getInstance().getTopComponentDisplayName(tc));
        }
        this.tabbedHandler.topComponentNameChanged(tc, this.kind);
    }

    public void updateToolTip(TopComponent tc) {
        this.tabbedHandler.topComponentToolTipChanged(tc);
    }

    public void updateIcon(TopComponent tc) {
        this.tabbedHandler.topComponentIconChanged(tc);
    }

    protected int getKind() {
        return this.kind;
    }

    protected Shape getIndicationForLocation(Point location) {
        return this.tabbedHandler.getIndicationForLocation(location, this.windowDnDManager.getStartingTransfer(), this.windowDnDManager.getStartingPoint(), this.isAttachingPossible());
    }

    protected Object getConstraintForLocation(Point location) {
        return this.tabbedHandler.getConstraintForLocation(location, this.isAttachingPossible());
    }

    protected abstract boolean isAttachingPossible();

    protected ModeView getDropModeView() {
        return this.modeView;
    }

    protected Component getDropComponent() {
        return this.tabbedHandler.getComponent();
    }

    protected abstract TopComponentDroppable getModeDroppable();

    protected boolean canDrop(TopComponent transfer) {
        if (Constants.SWITCH_MODE_ADD_NO_RESTRICT || WindowManagerImpl.getInstance().isTopComponentAllowedToMoveAnywhere(transfer)) {
            return true;
        }
        ModeImpl mode = (ModeImpl)WindowManagerImpl.getInstance().findMode(transfer);
        int kind = mode != null ? mode.getKind() : 1;
        boolean isNonEditor = kind == 0 || kind == 2;
        boolean thisIsNonEditor = this.kind == 0 || this.kind == 2;
        return isNonEditor == thisIsNonEditor;
    }
}

