/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.text.MessageFormat;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import javax.swing.plaf.basic.BasicHTML;
import org.netbeans.core.windows.view.ModeView;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.core.windows.view.dnd.ZOrderManager;
import org.netbeans.core.windows.view.ui.AbstractModeContainer;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.netbeans.core.windows.view.ui.ModeComponent;
import org.netbeans.core.windows.view.ui.Tabbed;
import org.netbeans.core.windows.view.ui.tabcontrol.TabbedAdapter;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class DefaultSeparateContainer
extends AbstractModeContainer {
    private final ModeFrame modeFrame;
    private final ModeDialog modeDialog;

    public DefaultSeparateContainer(ModeView modeView, WindowDnDManager windowDnDManager, Rectangle bounds, int kind) {
        super(modeView, windowDnDManager, kind);
        if (kind == 1) {
            this.modeFrame = new ModeFrame(this, modeView);
            this.modeFrame.setIconImage(MainWindow.createIDEImage());
            this.modeDialog = null;
        } else {
            this.modeDialog = new ModeDialog(WindowManager.getDefault().getMainWindow(), this, modeView);
            this.modeFrame = null;
        }
        Window w = this.getModeUIWindow();
        ((RootPaneContainer)((Object)w)).getContentPane().add(this.tabbedHandler.getComponent());
        w.setBounds(bounds);
    }

    public void requestAttention(TopComponent tc) {
    }

    public void cancelRequestAttention(TopComponent tc) {
    }

    protected Component getModeComponent() {
        return this.getModeUIWindow();
    }

    protected Tabbed createTabbed() {
        TabbedAdapter tabbed = this.getKind() == 1 ? new TabbedAdapter(1) : new TabbedAdapter(0);
        return tabbed;
    }

    protected void updateTitle(String title) {
        this.getModeUIBase().updateTitle(title);
    }

    protected void updateActive(boolean active) {
        Window w = this.getModeUIWindow();
        if (active && w.isVisible() && !w.isActive()) {
            w.toFront();
        }
    }

    public boolean isActive() {
        return this.getModeUIWindow().isActive();
    }

    protected boolean isAttachingPossible() {
        return false;
    }

    protected TopComponentDroppable getModeDroppable() {
        return this.getModeUIBase();
    }

    private Window getModeUIWindow() {
        return this.modeFrame != null ? this.modeFrame : this.modeDialog;
    }

    private ModeUIBase getModeUIBase() {
        return (ModeUIBase)((Object)this.getModeUIWindow());
    }

    private static class ModeDialog
    extends JDialog
    implements ModeUIBase {
        private SharedModeUIBase modeBase;

        public ModeDialog(Frame owner, AbstractModeContainer abstractModeContainer, ModeView view) {
            super(owner);
            this.enableEvents(16L);
            this.modeBase = new SharedModeUIBaseImpl(abstractModeContainer, view, this);
        }

        public ModeView getModeView() {
            return this.modeBase.getModeView();
        }

        public int getKind() {
            return this.modeBase.getKind();
        }

        public Shape getIndicationForLocation(Point location) {
            return this.modeBase.getIndicationForLocation(location);
        }

        public Object getConstraintForLocation(Point location) {
            return this.modeBase.getConstraintForLocation(location);
        }

        public Component getDropComponent() {
            return this.modeBase.getDropComponent();
        }

        public ViewElement getDropViewElement() {
            return this.modeBase.getDropViewElement();
        }

        public boolean canDrop(TopComponent transfer, Point location) {
            return this.modeBase.canDrop(transfer, location);
        }

        public boolean supportsKind(int kind, TopComponent transfer) {
            return this.modeBase.supportsKind(kind, transfer);
        }

        public void updateTitle(String title) {
        }
    }

    private static class ModeFrame
    extends JFrame
    implements ModeUIBase {
        private SharedModeUIBase modeBase;

        public ModeFrame(AbstractModeContainer abstractModeContainer, ModeView view) {
            this.enableEvents(16L);
            this.modeBase = new SharedModeUIBaseImpl(abstractModeContainer, view, this);
        }

        public ModeView getModeView() {
            return this.modeBase.getModeView();
        }

        public int getKind() {
            return this.modeBase.getKind();
        }

        public Shape getIndicationForLocation(Point location) {
            return this.modeBase.getIndicationForLocation(location);
        }

        public Object getConstraintForLocation(Point location) {
            return this.modeBase.getConstraintForLocation(location);
        }

        public Component getDropComponent() {
            return this.modeBase.getDropComponent();
        }

        public ViewElement getDropViewElement() {
            return this.modeBase.getDropViewElement();
        }

        public boolean canDrop(TopComponent transfer, Point location) {
            return this.modeBase.canDrop(transfer, location);
        }

        public boolean supportsKind(int kind, TopComponent transfer) {
            return this.modeBase.supportsKind(kind, transfer);
        }

        public void updateTitle(String title) {
            if (BasicHTML.isHTMLString(title)) {
                char[] c = title.toCharArray();
                StringBuffer sb = new StringBuffer(title.length());
                boolean inTag = false;
                boolean inEntity = false;
                for (int i = 0; i < c.length; ++i) {
                    if (inTag && c[i] == '>') {
                        inTag = false;
                        continue;
                    }
                    if (!inTag && c[i] == '<') {
                        inTag = true;
                        continue;
                    }
                    if (inTag) continue;
                    sb.append(c[i]);
                }
                title = Utilities.replaceString((String)sb.toString(), (String)"&nbsp;", (String)" ");
            }
            String completeTitle = MessageFormat.format(NbBundle.getMessage(DefaultSeparateContainer.class, (String)"CTL_SeparateEditorTitle"), title);
            this.setTitle(completeTitle);
        }
    }

    public static interface ModeUIBase
    extends ModeComponent,
    TopComponentDroppable {
        public void updateTitle(String var1);
    }

    public static interface SharedModeUIBase
    extends ModeComponent,
    TopComponentDroppable {
    }

    private static class SharedModeUIBaseImpl
    implements SharedModeUIBase {
        private final AbstractModeContainer abstractModeContainer;
        private final ModeView modeView;
        private long frametimestamp = 0L;
        private Window window;

        public SharedModeUIBaseImpl(AbstractModeContainer abstractModeContainer, ModeView view, Window window) {
            this.abstractModeContainer = abstractModeContainer;
            this.modeView = view;
            this.window = window;
            this.initWindow(window);
            this.attachListeners(window);
        }

        private void initWindow(Window w) {
            ((RootPaneContainer)((Object)w)).getRootPane().putClientProperty("SeparateWindow", Boolean.TRUE);
            ZOrderManager.getInstance().attachWindow((RootPaneContainer)((Object)w));
        }

        private void attachListeners(Window w) {
            w.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    SharedModeUIBaseImpl.this.modeView.getController().userClosingMode(SharedModeUIBaseImpl.this.modeView);
                    ZOrderManager.getInstance().detachWindow((RootPaneContainer)((Object)SharedModeUIBaseImpl.this.window));
                }

                public void windowClosed(WindowEvent evt) {
                    ZOrderManager.getInstance().detachWindow((RootPaneContainer)((Object)SharedModeUIBaseImpl.this.window));
                }

                public void windowActivated(WindowEvent event) {
                    if (SharedModeUIBaseImpl.this.frametimestamp != 0L && System.currentTimeMillis() > SharedModeUIBaseImpl.this.frametimestamp + 500L) {
                        SharedModeUIBaseImpl.this.modeView.getController().userActivatedModeWindow(SharedModeUIBaseImpl.this.modeView);
                    }
                    SharedModeUIBaseImpl.this.frametimestamp = System.currentTimeMillis();
                }

                public void windowOpened(WindowEvent event) {
                    SharedModeUIBaseImpl.this.frametimestamp = System.currentTimeMillis();
                }
            });
            w.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent evt) {
                    SharedModeUIBaseImpl.this.modeView.getController().userResizedModeBounds(SharedModeUIBaseImpl.this.modeView, SharedModeUIBaseImpl.this.window.getBounds());
                }

                public void componentMoved(ComponentEvent evt) {
                    SharedModeUIBaseImpl.this.modeView.getController().userResizedModeBounds(SharedModeUIBaseImpl.this.modeView, SharedModeUIBaseImpl.this.window.getBounds());
                }
            });
            this.window.addWindowStateListener(new WindowStateListener(){

                public void windowStateChanged(WindowEvent evt) {
                    Component comp = SharedModeUIBaseImpl.this.modeView.getComponent();
                    if (comp instanceof Frame) {
                        long currentStamp = System.currentTimeMillis();
                        if (currentStamp > SharedModeUIBaseImpl.this.modeView.getUserStamp() + 500L && currentStamp > SharedModeUIBaseImpl.this.modeView.getMainWindowStamp() + 1000L) {
                            SharedModeUIBaseImpl.this.modeView.getController().userChangedFrameStateMode(SharedModeUIBaseImpl.this.modeView, evt.getNewState());
                        } else {
                            SharedModeUIBaseImpl.this.modeView.setUserStamp(0L);
                            SharedModeUIBaseImpl.this.modeView.setMainWindowStamp(0L);
                            SharedModeUIBaseImpl.this.modeView.updateFrameState();
                        }
                        long stamp = System.currentTimeMillis();
                        SharedModeUIBaseImpl.this.modeView.setUserStamp(stamp);
                    }
                }
            });
        }

        public void setVisible(boolean visible) {
            this.frametimestamp = System.currentTimeMillis();
            this.window.setVisible(visible);
        }

        public void toFront() {
            this.frametimestamp = System.currentTimeMillis();
            this.window.toFront();
        }

        public ModeView getModeView() {
            return this.abstractModeContainer.getModeView();
        }

        public int getKind() {
            return this.abstractModeContainer.getKind();
        }

        public Shape getIndicationForLocation(Point location) {
            return this.abstractModeContainer.getIndicationForLocation(location);
        }

        public Object getConstraintForLocation(Point location) {
            return this.abstractModeContainer.getConstraintForLocation(location);
        }

        public Component getDropComponent() {
            return this.abstractModeContainer.getDropComponent();
        }

        public ViewElement getDropViewElement() {
            return this.abstractModeContainer.getDropModeView();
        }

        public boolean canDrop(TopComponent transfer, Point location) {
            return this.abstractModeContainer.canDrop(transfer);
        }

        public boolean supportsKind(int kind, TopComponent transfer) {
            return this.abstractModeContainer.canDrop(transfer);
        }
    }
}

