/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.slides;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.view.ui.slides.SlideOperation;
import org.netbeans.core.windows.view.ui.slides.SlidingFx;

class SlideOperationImpl
implements SlideOperation,
ChangeListener {
    private final int type;
    private final Component component;
    private final SlidingFx effect;
    private final boolean requestsActivation;
    private final String side;
    protected Rectangle startBounds;
    protected Rectangle finishBounds;
    private JLayeredPane pane;
    private Integer layer;

    SlideOperationImpl(int type, Component component, int orientation, SlidingFx effect, boolean requestsActivation) {
        this(type, component, SlideOperationImpl.orientation2Side(orientation), effect, requestsActivation);
    }

    SlideOperationImpl(int type, Component component, String side, SlidingFx effect, boolean requestsActivation) {
        this.type = type;
        this.component = component;
        this.effect = effect;
        this.requestsActivation = requestsActivation;
        this.side = side;
    }

    public void run(JLayeredPane pane, Integer layer) {
        if (this.effect != null && this.effect.shouldOperationWait()) {
            this.pane = pane;
            this.layer = layer;
            this.effect.setFinishListener(this);
            this.effect.showEffect(pane, layer, this);
        } else {
            if (this.effect != null) {
                this.effect.showEffect(pane, layer, this);
            }
            this.performOperation(pane, layer);
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.performOperation(this.pane, this.layer);
        this.pane = null;
        this.layer = null;
    }

    private void performOperation(JLayeredPane pane, Integer layer) {
        switch (this.type) {
            case 0: {
                this.component.setBounds(this.finishBounds);
                pane.add(this.component, layer);
                break;
            }
            case 1: {
                pane.remove(this.component);
                break;
            }
            case 4: {
                this.component.setBounds(this.finishBounds);
                ((JComponent)this.component).revalidate();
            }
        }
    }

    public void setFinishBounds(Rectangle bounds) {
        this.finishBounds = bounds;
    }

    public void setStartBounds(Rectangle bounds) {
        this.startBounds = bounds;
    }

    public String getSide() {
        return this.side;
    }

    public Component getComponent() {
        return this.component;
    }

    public Rectangle getFinishBounds() {
        return this.finishBounds;
    }

    public Rectangle getStartBounds() {
        return this.startBounds;
    }

    public boolean requestsActivation() {
        return this.requestsActivation;
    }

    protected static String orientation2Side(int orientation) {
        String side = "left";
        if (orientation == 2) {
            side = "left";
        } else if (orientation == 1) {
            side = "right";
        } else if (orientation == 3) {
            side = "bottom";
        }
        return side;
    }

    public int getType() {
        return this.type;
    }

    public void prepareEffect() {
        if (this.effect != null) {
            this.effect.prepareEffect(this);
        }
    }

    static int side2Orientation(String side) {
        int orientation = 2;
        if ("left".equals(side)) {
            orientation = 2;
        } else if ("right".equals(side)) {
            orientation = 1;
        } else if ("bottom".equals(side)) {
            orientation = 3;
        }
        return orientation;
    }
}

