/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.toolbars;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConfiguration;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarRow;
import org.openide.awt.Toolbar;
import org.openide.xml.XMLUtil;

public class ToolbarConstraints {
    static final long serialVersionUID = 3065774641403311880L;
    static final int LEFT_ANCHOR = -1;
    static final int NO_ANCHOR = 0;
    public static final String PREFERRED_SIZE = "preferredSize";
    private String name;
    private int position;
    private int anchor;
    private boolean visible;
    private Vector<ToolbarRow> ownRows;
    private Vector<ToolbarConstraints> prevBars;
    private Vector<ToolbarConstraints> nextBars;
    private int prevEnd;
    private int nextBeg;
    private int prevBeg;
    private int nextEnd;
    private Dimension prefSize;
    private Rectangle bounds;
    private ToolbarConfiguration toolbarConfig;
    private int rowCount;
    private int prefLastWidth;
    private int lastRowIndex;
    private int initialIndexInRow;
    private PropertyChangeSupport propSupport;

    ToolbarConstraints(ToolbarConfiguration conf, String nam, Integer pos, Boolean vis) {
        this(conf, nam, pos, vis, -1);
    }

    ToolbarConstraints(ToolbarConfiguration conf, String nam, Integer pos, Boolean vis, int initialIndexInRow) {
        this.toolbarConfig = conf;
        this.name = nam;
        if (pos == null) {
            this.position = 0;
            this.anchor = -1;
            this.initialIndexInRow = initialIndexInRow;
        } else {
            this.position = pos;
            this.anchor = 0;
            this.initialIndexInRow = -1;
        }
        this.visible = vis;
        this.prefSize = new Dimension();
        this.rowCount = 0;
        this.prefLastWidth = 0;
        this.bounds = new Rectangle();
        this.initValues();
    }

    void initValues() {
        this.ownRows = new Vector();
        this.prevBars = new Vector();
        this.nextBars = new Vector();
        this.resetPrev();
        this.resetNext();
    }

    void checkNextPosition(Integer position, Boolean visible) {
        if (position == null) {
            this.position = 0;
            this.anchor = -1;
        } else {
            this.position = this.anchor == 0 ? (this.position + position) / 2 : position;
            this.anchor = 0;
        }
        this.visible = this.visible || visible != false;
    }

    String getName() {
        return this.name;
    }

    int getAnchor() {
        return this.anchor;
    }

    void setAnchor(int anch) {
        this.anchor = anch;
    }

    boolean isVisible() {
        return this.visible;
    }

    void setVisible(boolean v) {
        this.visible = v;
    }

    int getPosition() {
        return this.position;
    }

    void setPosition(int pos) {
        this.position = pos;
    }

    int getWidth() {
        return this.prefSize.width;
    }

    int getRowCount() {
        return this.rowCount;
    }

    int checkInitialIndexInRow() {
        int retValue = this.initialIndexInRow;
        this.initialIndexInRow = -1;
        return retValue;
    }

    Rectangle getBounds() {
        return new Rectangle(this.bounds);
    }

    boolean destroy() {
        this.lastRowIndex = this.rowIndex();
        this.rowCount = this.ownRows.size();
        boolean emptyRow = false;
        for (ToolbarRow row : this.ownRows) {
            row.removeToolbar(this);
            emptyRow = emptyRow || row.isEmpty();
        }
        this.initValues();
        return emptyRow;
    }

    void addOwnRow(ToolbarRow row) {
        this.ownRows.add(row);
    }

    void addPrevBar(ToolbarConstraints prev) {
        if (prev == null) {
            return;
        }
        this.prevBars.add(prev);
    }

    void addNextBar(ToolbarConstraints next) {
        if (next == null) {
            return;
        }
        this.nextBars.add(next);
    }

    void removePrevBar(ToolbarConstraints prev) {
        if (prev == null) {
            return;
        }
        this.prevBars.remove(prev);
    }

    void removeNextBar(ToolbarConstraints next) {
        if (next == null) {
            return;
        }
        this.nextBars.remove(next);
    }

    void setPreferredSize(Dimension size) {
        Dimension oldSize = this.prefSize;
        this.prefSize = size;
        this.rowCount = Toolbar.rowCount((int)this.prefSize.height);
        if (this.ownRows.isEmpty()) {
            return;
        }
        if (this.visible) {
            ToolbarRow row;
            boolean emptyRow = false;
            while (this.rowCount < this.ownRows.size()) {
                row = this.ownRows.lastElement();
                row.removeToolbar(this);
                this.ownRows.remove(row);
                emptyRow = emptyRow || row.isEmpty();
            }
            if (emptyRow) {
                this.toolbarConfig.checkToolbarRows();
            }
            while (this.rowCount > this.ownRows.size()) {
                row = this.ownRows.lastElement();
                ToolbarRow nR = row.getNextRow();
                if (nR == null) {
                    nR = this.toolbarConfig.createLastRow();
                }
                nR.addToolbar(this, this.position);
            }
        }
        this.updatePosition();
        this.propSupport.firePropertyChange(PREFERRED_SIZE, oldSize, this.prefSize);
    }

    int rowIndex() {
        if (!this.visible) {
            return this.toolbarConfig.getRowCount();
        }
        if (this.ownRows.isEmpty()) {
            return this.lastRowIndex;
        }
        return this.toolbarConfig.rowIndex(this.ownRows.firstElement());
    }

    boolean isAlone() {
        for (ToolbarRow row : this.ownRows) {
            if (row.toolbarCount() == 1) continue;
            return false;
        }
        return true;
    }

    void updatePreferredSize(Dimension size) {
        if (!this.prefSize.equals(size)) {
            this.setPreferredSize(size);
        }
    }

    void updateBounds() {
        if (this.ownRows.size() > 0) {
            Iterator<ToolbarRow> iter = this.ownRows.iterator();
            ToolbarRow firstRow = iter.next();
            int toolbarHeight = firstRow.getPreferredHeight();
            while (iter.hasNext()) {
                toolbarHeight += iter.next().getPreferredHeight() + 1;
            }
            this.bounds = new Rectangle(this.position, this.toolbarConfig.getRowVertLocation(firstRow), this.nextBeg - this.position - 1, toolbarHeight);
        } else {
            this.bounds = new Rectangle(this.position, 0, 0, 0);
        }
    }

    void updatePosition() {
        this.updatePrev();
        if (this.anchor == 0) {
            if (this.position < this.prevEnd + 1) {
                this.position = this.prevEnd + 1;
                this.anchor = -1;
            }
        } else {
            this.position = this.prevEnd + 1;
        }
        this.updatePrevBars();
        this.updateNextBars();
        this.updateBounds();
        this.updatePrefWidth();
    }

    void updatePrevPosition() {
        for (ToolbarConstraints tc : this.prevBars) {
            tc.updatePosition();
        }
    }

    void updatePrevBars() {
        for (ToolbarConstraints tc : this.prevBars) {
            tc.updateNext();
        }
    }

    void updateNextBars() {
        Iterator<ToolbarConstraints> it = this.nextBars.iterator();
        if (!it.hasNext()) {
            this.resetNext();
            this.updatePrefWidth();
        }
        while (it.hasNext()) {
            ToolbarConstraints tc = it.next();
            if (tc == this) continue;
            tc.updatePosition();
        }
    }

    void updatePrefWidth() {
        if (this.nextBars.size() == 0) {
            this.prefLastWidth = this.getPosition() + this.getWidth() + 1;
            this.toolbarConfig.updatePrefWidth();
        }
    }

    int getPrefWidth() {
        return this.prefLastWidth;
    }

    int getPrefHeight() {
        return this.prefSize.height;
    }

    void updateNext() {
        this.resetNext();
        for (ToolbarConstraints tc : this.nextBars) {
            int nextPos = tc.getPosition();
            this.nextBeg = Math.min(this.nextBeg, nextPos);
            this.nextEnd = Math.min(this.nextEnd, nextPos + tc.getWidth());
        }
        this.updateBounds();
    }

    void updatePrev() {
        this.resetPrev();
        for (ToolbarConstraints tc : this.prevBars) {
            int prevPos = tc.getPosition();
            this.prevBeg = Math.max(this.prevBeg, prevPos);
            this.prevEnd = Math.max(this.prevEnd, prevPos + tc.getWidth());
        }
    }

    void resetPrev() {
        this.prevBeg = 0;
        this.prevEnd = 0;
    }

    void resetNext() {
        this.nextBeg = Integer.MAX_VALUE;
        this.nextEnd = Integer.MAX_VALUE;
    }

    void moveLeft(int dx) {
        int wantX;
        this.position = wantX = this.position - dx;
        this.anchor = 0;
        if (wantX > this.prevEnd) {
            this.setAnchorTo(0, this.nextBars);
        } else if (ToolbarConstraints.canSwitchLeft(this.getPosition(), this.getWidth(), this.prevBeg, this.prevEnd - this.prevBeg)) {
            this.switchToolbarLeft();
        }
    }

    void moveRight(int dx) {
        int wantX = this.position + dx;
        int wantXpWidth = wantX + this.getWidth();
        if (wantXpWidth < this.nextBeg) {
            this.anchor = 0;
            this.position = wantX;
        } else if (ToolbarConstraints.canSwitchRight(wantX, this.getWidth(), this.nextBeg, this.nextEnd - this.nextBeg)) {
            this.position = wantX;
            this.anchor = 0;
            this.switchToolbarRight();
        } else {
            this.position = this.nextBeg - this.getWidth() - 1;
            this.anchor = 0;
        }
        this.updatePrevPosition();
    }

    void moveLeft2End(int dx) {
        int wantX = this.position - dx;
        this.anchor = 0;
        if (wantX < this.prevEnd + 1) {
            wantX = this.prevEnd + 1;
        }
        this.move2End(wantX - this.position);
    }

    void moveRight2End(int dx) {
        this.move2End(dx);
    }

    void move2End(int dx) {
        this.position += dx;
        for (ToolbarConstraints tc : this.nextBars) {
            tc.move2End(dx);
        }
    }

    void setAnchorTo(int anch, Vector bars) {
        for (ToolbarConstraints tc : bars) {
            tc.setAnchor(anch);
        }
    }

    void switchToolbarLeft() {
        for (ToolbarRow row : this.ownRows) {
            row.trySwitchLeft(this);
        }
    }

    void switchToolbarRight() {
        for (ToolbarRow row : this.ownRows) {
            row.trySwitchRight(this);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propSupport == null) {
            this.propSupport = new PropertyChangeSupport(this);
        }
        this.propSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propSupport != null) {
            this.propSupport.removePropertyChangeListener(l);
        }
    }

    static boolean canSwitchLeft(int p1, int w1, int p2, int w2) {
        return p1 < p2;
    }

    static boolean canSwitchRight(int p1, int w1, int p2, int w2) {
        return p1 > p2;
    }

    static class WritableToolbar {
        String name;
        int position;
        int anchor;
        boolean visible;

        public WritableToolbar(ToolbarConstraints tc) {
            this.name = tc.getName();
            this.position = tc.getPosition();
            this.anchor = tc.getAnchor();
            this.visible = tc.isVisible();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            String quotedName = this.name;
            try {
                quotedName = XMLUtil.toAttributeValue((String)this.name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            sb.append("    <").append("Toolbar");
            sb.append(" ").append("name").append("=\"").append(quotedName).append("\"");
            if (this.anchor == 0 || !this.visible) {
                sb.append(" ").append("position").append("=\"").append(this.position).append("\"");
            }
            if (!this.visible) {
                sb.append(" ").append("visible").append("=\"").append(this.visible).append("\"");
            }
            sb.append(" />\n");
            return sb.toString();
        }
    }
}

