/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.awt.TabbedPaneFactory;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class VersioningOutputTopComponent
extends TopComponent
implements Externalizable,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static VersioningOutputTopComponent instance;
    private Set<JComponent> components = new HashSet<JComponent>(1);
    private JTabbedPane tabbedPane = TabbedPaneFactory.createCloseButtonTabbedPane();

    public VersioningOutputTopComponent() {
        this.setIcon(Utilities.loadImage((String)"org/netbeans/modules/versioning/util/resources/window-versioning.png"));
        this.setLayout(new BorderLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VersioningOutputTopComponent.class, (String)"CTL_VersioningOutput_Title"));
        this.updateName();
        this.tabbedPane.addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("close".equals(evt.getPropertyName())) {
            JComponent c = (JComponent)evt.getNewValue();
            this.removeComponent(c);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    public static synchronized VersioningOutputTopComponent getInstance() {
        if (instance == null && (instance = (VersioningOutputTopComponent)WindowManager.getDefault().findTopComponent("versioning_output")) == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Can not find Versioning Output component"));
            instance = new VersioningOutputTopComponent();
        }
        return instance;
    }

    protected String preferredID() {
        return "versioning_output";
    }

    public int getPersistenceType() {
        return 0;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.components = new HashSet<JComponent>(1);
        this.tabbedPane = TabbedPaneFactory.createCloseButtonTabbedPane();
        this.tabbedPane.addPropertyChangeListener(this);
        this.updateName();
    }

    public Object readResolve() {
        return VersioningOutputTopComponent.getInstance();
    }

    private void updateName() {
        if (this.components.size() == 0) {
            this.setName(NbBundle.getMessage(VersioningOutputTopComponent.class, (String)"CTL_VersioningOutput_Title"));
        } else if (this.components.size() == 1) {
            JComponent c = this.components.iterator().next();
            this.setName(NbBundle.getMessage(VersioningOutputTopComponent.class, (String)"CTL_VersioningOutput_TitleOne", (Object)c.getName()));
        } else {
            this.setName(NbBundle.getMessage(VersioningOutputTopComponent.class, (String)"CTL_VersioningOutput_Title"));
        }
    }

    private void removeComponent(JComponent c) {
        assert (SwingUtilities.isEventDispatchThread());
        assert (this.components.remove(c));
        if (this.components.size() == 0) {
            this.removeAll();
        } else if (this.components.size() == 1) {
            this.tabbedPane.removeAll();
            this.removeAll();
            this.add(this.components.iterator().next());
        } else {
            this.tabbedPane.remove(c);
        }
        this.updateName();
        this.revalidate();
    }

    void addComponent(String key, JComponent c) {
        assert (SwingUtilities.isEventDispatchThread());
        for (JComponent existing : this.components) {
            if (!existing.getClientProperty(VersioningOutputTopComponent.class).equals(key)) continue;
            this.removeComponent(existing);
            break;
        }
        if (!this.components.add(c)) {
            return;
        }
        c.putClientProperty(VersioningOutputTopComponent.class, key);
        if (this.components.size() == 1) {
            assert (this.getComponentCount() == 0);
            this.add(c);
        } else if (this.components.size() == 2) {
            assert (this.getComponentCount() == 1);
            this.removeAll();
            Iterator<JComponent> it = this.components.iterator();
            this.tabbedPane.add(it.next());
            this.tabbedPane.add(it.next());
            this.tabbedPane.setSelectedComponent(c);
            this.add(this.tabbedPane);
        } else {
            assert (this.getComponentCount() == 1);
            this.tabbedPane.add(c);
            this.tabbedPane.setSelectedComponent(c);
        }
        this.updateName();
        this.revalidate();
    }
}

