/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.tasklist.filter.FilterRepository;
import org.netbeans.modules.tasklist.filter.KeywordsFilter;
import org.netbeans.modules.tasklist.filter.KeywordsPanel;
import org.netbeans.modules.tasklist.filter.TaskFilter;
import org.netbeans.modules.tasklist.filter.TypesFilter;
import org.netbeans.modules.tasklist.filter.TypesPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class FilterEditor
extends JPanel
implements PropertyChangeListener {
    private HashMap<KeywordsFilter, KeywordsPanel> filter2keywords = new HashMap(10);
    private HashMap<TypesFilter, TypesPanel> filter2types = new HashMap(10);
    private FilterRepository filterRepository;
    private FilterModel filterModel;
    private JButton btnOk;
    private JButton btnCancel;
    private JButton btnNewFilter;
    private JButton btnRemoveFilter;
    private JLabel lblFilterName;
    private JLabel lblFilters;
    private JList lstFilters;
    private JPanel panelKeywords;
    private JPanel panelTypes;
    private JScrollPane scrollFilters;
    private JTabbedPane tabs;
    private JTextField txtFilterName;

    public FilterEditor(FilterRepository filters) {
        this.initComponents();
        this.filterRepository = filters;
        if (this.filterRepository.size() == 0) {
            this.filterRepository.add(this.filterRepository.createNewFilter());
        }
        this.filterModel = new FilterModel(this.filterRepository);
        this.init();
    }

    public boolean showWindow() {
        DialogDescriptor dd = new DialogDescriptor((Object)this, NbBundle.getMessage(FilterEditor.class, (String)"LBL_FilterEditor"), true, new Object[]{this.btnOk, this.btnCancel}, (Object)this.btnOk, 0, HelpCtx.DEFAULT_HELP, null);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
        dlg.setVisible(true);
        if (this.btnOk.equals(dd.getValue())) {
            this.updateFilters();
            return true;
        }
        return false;
    }

    private void init() {
        this.initComponents();
        this.lstFilters.setModel(this.filterModel);
        this.lstFilters.setSelectionModel(this.filterModel.selection);
        this.lstFilters.setSelectionMode(0);
        TaskFilter selected = this.filterRepository.getActive();
        if (null != selected) {
            int selIndex = this.filterModel.getIndexOf(selected);
            this.lstFilters.setSelectedIndex(selIndex);
        }
        if (this.filterModel.getSelectedIndex() == -1 && this.filterModel.getSize() > 0) {
            this.lstFilters.setSelectedIndex(0);
        }
        this.txtFilterName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this.update(e);
            }

            public void insertUpdate(DocumentEvent e) {
                this.update(e);
            }

            public void removeUpdate(DocumentEvent e) {
                this.update(e);
            }

            private void update(DocumentEvent e) {
                try {
                    FilterEditor.this.filterModel.setCurrentFilterName(e.getDocument().getText(0, e.getDocument().getLength()));
                    FilterEditor.this.propertyChange(null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        this.lstFilters.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    FilterEditor.this.showFilter(FilterEditor.this.filterModel.getSelectedFilter());
                    FilterEditor.this.btnRemoveFilter.setEnabled(FilterEditor.this.filterModel.getSelectedIndex() != -1);
                    FilterEditor.this.txtFilterName.setEnabled(FilterEditor.this.filterModel.getSelectedIndex() != -1);
                }
            }
        });
        this.showFilter(this.filterModel.getSelectedFilter());
        this.btnRemoveFilter.setEnabled(this.filterModel.getSelectedIndex() != -1);
        this.btnOk = new JButton("Ok");
        this.btnCancel = new JButton("Cancel");
    }

    private void showFilter(TaskFilter filter) {
        if (null == filter) {
            this.txtFilterName.setText(null);
            this.panelKeywords.removeAll();
            this.panelTypes.removeAll();
            this.panelKeywords.add((Component)new KeywordsPanel(null), "Center");
            this.panelTypes.add((Component)new TypesPanel(null), "Center");
        } else {
            KeywordsPanel kPanel = this.filter2keywords.get(filter.getKeywordsFilter());
            if (kPanel == null) {
                kPanel = new KeywordsPanel(filter.getKeywordsFilter() == null ? new KeywordsFilter() : filter.getKeywordsFilter());
                this.filter2keywords.put(filter.getKeywordsFilter(), kPanel);
                kPanel.addPropertyChangeListener("value-valid", this);
            }
            this.panelKeywords.removeAll();
            this.panelKeywords.add((Component)kPanel, "Center");
            kPanel.setVisible(true);
            TypesPanel tPanel = this.filter2types.get(filter.getTypesFilter());
            if (tPanel == null) {
                tPanel = new TypesPanel(filter.getTypesFilter() == null ? new TypesFilter() : filter.getTypesFilter());
                this.filter2types.put(filter.getTypesFilter(), tPanel);
                tPanel.addPropertyChangeListener("value-valid", this);
            }
            this.panelTypes.removeAll();
            this.panelTypes.add((Component)tPanel, "Center");
            tPanel.setVisible(true);
            this.tabs.requestFocus();
            if (this.filterModel.getSelectedFilter() != filter) {
                this.lstFilters.setSelectedIndex(this.filterModel.getIndexOf(filter));
            }
            this.txtFilterName.setText(filter.getName());
        }
        this.panelKeywords.validate();
        this.panelKeywords.repaint();
        this.panelTypes.validate();
        this.panelTypes.repaint();
    }

    public boolean isValueValid() {
        for (KeywordsPanel fp : this.filter2keywords.values()) {
            if (fp.isValueValid()) continue;
            return false;
        }
        for (TypesPanel tp : this.filter2types.values()) {
            if (tp.isValueValid()) continue;
            return false;
        }
        return this.txtFilterName.getText().length() != 0;
    }

    public void propertyChange(PropertyChangeEvent arg0) {
        if (null != this.btnOk) {
            this.btnOk.setEnabled(this.isValueValid());
        }
    }

    void updateFilters() {
        this.filterRepository.clear();
        Iterator filterIt = this.filterModel.iterator();
        while (filterIt.hasNext()) {
            TaskFilter f = (TaskFilter)filterIt.next();
            if (this.filter2keywords.get(f.getKeywordsFilter()) != null) {
                f.setKeywordsFilter(this.filter2keywords.get(f.getKeywordsFilter()).getFilter());
            }
            if (this.filter2types.get(f.getTypesFilter()) != null) {
                f.setTypesFilter(this.filter2types.get(f.getTypesFilter()).getFilter());
            }
            this.filterRepository.add(f);
        }
        if (this.filterModel.getSelectedFilter() != null) {
            this.filterRepository.setActive(this.filterModel.getSelectedFilter());
        }
    }

    private void initComponents() {
        this.lblFilters = new JLabel();
        this.scrollFilters = new JScrollPane();
        this.lstFilters = new JList();
        this.btnNewFilter = new JButton();
        this.btnRemoveFilter = new JButton();
        this.tabs = new JTabbedPane();
        this.panelTypes = new JPanel();
        this.panelKeywords = new JPanel();
        this.lblFilterName = new JLabel();
        this.txtFilterName = new JTextField();
        this.lblFilters.setLabelFor(this.lstFilters);
        Mnemonics.setLocalizedText((JLabel)this.lblFilters, (String)NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.lblFilters.text"));
        this.lstFilters.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lstFilters.setToolTipText(NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.lstFilters.toolTipText"));
        this.scrollFilters.setViewportView(this.lstFilters);
        Mnemonics.setLocalizedText((AbstractButton)this.btnNewFilter, (String)NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.btnNewFilter.text"));
        this.btnNewFilter.setToolTipText(NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.btnNewFilter.toolTipText"));
        this.btnNewFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FilterEditor.this.onNewFilter(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemoveFilter, (String)NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.btnRemoveFilter.text"));
        this.btnRemoveFilter.setToolTipText(NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.btnRemoveFilter.toolTipText"));
        this.btnRemoveFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FilterEditor.this.onRemoveFilter(evt);
            }
        });
        this.panelTypes.setOpaque(false);
        this.panelTypes.setLayout(new BorderLayout());
        this.tabs.addTab(NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.panelTypes.TabConstraints.tabTitle"), this.panelTypes);
        this.panelKeywords.setOpaque(false);
        this.panelKeywords.setLayout(new BorderLayout());
        this.tabs.addTab(NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.panelKeywords.TabConstraints.tabTitle"), this.panelKeywords);
        this.lblFilterName.setLabelFor(this.txtFilterName);
        Mnemonics.setLocalizedText((JLabel)this.lblFilterName, (String)NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.lblFilterName.text"));
        this.txtFilterName.setToolTipText(NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.txtFilterName.toolTipText"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.lblFilters).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.btnNewFilter).addPreferredGap(0).add((Component)this.btnRemoveFilter)).add((Component)this.scrollFilters)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lblFilterName).addPreferredGap(0).add((Component)this.txtFilterName, -1, 459, Short.MAX_VALUE)).add((Component)this.tabs, -1, 494, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.lblFilters).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.scrollFilters, -1, 229, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.btnNewFilter).add((Component)this.btnRemoveFilter))).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblFilterName).add((Component)this.txtFilterName, -2, -1, -2)).addPreferredGap(0).add((Component)this.tabs, -1, 233, Short.MAX_VALUE))).addContainerGap()));
    }

    private void onRemoveFilter(ActionEvent evt) {
        int i = this.filterModel.getSelectedIndex();
        if (i != -1) {
            TaskFilter f = this.filterModel.get(i);
            this.filterModel.remove(i);
            this.filter2keywords.remove(f.getKeywordsFilter());
            this.filter2types.remove(f.getTypesFilter());
        }
    }

    private void onNewFilter(ActionEvent evt) {
        TaskFilter f = this.filterRepository.createNewFilter();
        this.filterModel.add(f);
        this.showFilter(f);
    }

    private static class FilterModel
    extends AbstractListModel {
        public DefaultListSelectionModel selection = new DefaultListSelectionModel();
        public ArrayList<TaskFilter> filters;

        public FilterModel(FilterRepository rep) {
            this.filters = new ArrayList(rep.size() * 2);
            int selectedi = 0;
            for (TaskFilter f : rep.getFilters()) {
                if (f == rep.getActive()) {
                    this.selection.setSelectionInterval(selectedi, selectedi);
                }
                this.filters.add((TaskFilter)f.clone());
                ++selectedi;
            }
        }

        public Iterator iterator() {
            return this.filters.iterator();
        }

        public Object getElementAt(int index) {
            return this.filters.get(index).getName();
        }

        public int getSize() {
            return this.filters.size();
        }

        public TaskFilter getSelectedFilter() {
            if (this.getSelectedIndex() > -1) {
                return this.filters.get(this.getSelectedIndex());
            }
            return null;
        }

        public int getSelectedIndex() {
            int i2;
            int i1 = this.selection.getMinSelectionIndex();
            if (i1 == (i2 = this.selection.getMaxSelectionIndex()) && i1 >= 0 && i1 < this.filters.size()) {
                return i1;
            }
            return -1;
        }

        public void remove(int i) {
            int s = this.getSelectedIndex();
            if (s != -1) {
                this.filters.remove(i);
                this.fireIntervalRemoved(this, i, i);
                if (i < s) {
                    this.selection.setSelectionInterval(s - 1, s - 1);
                }
                if (i == s) {
                    this.selection.setSelectionInterval(100, 0);
                }
            }
        }

        public TaskFilter get(int i) {
            return this.filters.get(i);
        }

        public boolean add(TaskFilter f) {
            if (this.filters.add(f)) {
                this.fireIntervalAdded(this, this.filters.size() - 1, this.filters.size() - 1);
                return true;
            }
            return false;
        }

        public int getIndexOf(TaskFilter f) {
            return this.filters.indexOf(f);
        }

        public void setCurrentFilterName(String name) {
            int selIndex = this.getSelectedIndex();
            if (selIndex >= 0) {
                this.get(selIndex).setName(name);
                this.fireContentsChanged(this, selIndex, selIndex);
            }
        }
    }
}

