/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.tasklist.filter.AppliedFilterCondition;
import org.netbeans.modules.tasklist.filter.ConditionPanel;
import org.netbeans.modules.tasklist.filter.FilterSubpanel;
import org.netbeans.modules.tasklist.filter.KeywordsFilter;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class KeywordsPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private KeywordsFilter filter;
    private FilterSubpanel subpanel;
    final JPanel conditionsPanel = new JPanel();
    final JScrollPane conditionsScrollPane = new JScrollPane();
    final JButton fewerButton = new JButton();
    final JRadioButton matchAllRadio = new JRadioButton();
    final JRadioButton matchAnyRadio = new JRadioButton();
    final ButtonGroup matchGroup = new ButtonGroup();
    final JButton moreButton = new JButton();
    final ButtonGroup subtaskGroup = new ButtonGroup();

    public KeywordsPanel(KeywordsFilter filter) {
        this.filter = filter;
        this.initComponents();
        this.initA11y();
        this.setOpaque(false);
        JPanel topAlign = new JPanel();
        topAlign.setLayout(new BorderLayout());
        topAlign.add((Component)this.conditionsPanel, "North");
        this.conditionsScrollPane.setViewportView(topAlign);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int width = fm.charWidth('n') * 80;
        int height = fm.getHeight() * 10;
        this.conditionsScrollPane.setPreferredSize(new Dimension(width, height));
        Color background = (Color)UIManager.get("Table.background");
        this.conditionsPanel.setBackground(background);
        topAlign.setBackground(background);
        this.moreButton.addActionListener(this);
        this.fewerButton.addActionListener(this);
        this.matchAllRadio.addActionListener(this);
        this.matchAnyRadio.addActionListener(this);
        this.showFilter(filter);
        this.updateSensitivity();
    }

    public void initSubpanel(FilterSubpanel next) {
        assert (this.subpanel == null);
        this.subpanel = next;
    }

    private void showFilter(KeywordsFilter filter) {
        if (filter != null) {
            if (filter.matchAll()) {
                this.matchAllRadio.setSelected(true);
            } else {
                this.matchAnyRadio.setSelected(true);
            }
            this.conditionsPanel.removeAll();
            List conditions = filter.getConditions();
            if (conditions.size() > 0) {
                for (AppliedFilterCondition cond : conditions) {
                    this.addCondition(false, cond);
                }
            } else {
                this.addCondition(false, null);
            }
        } else {
            this.setEnabled(false);
            this.matchAnyRadio.setEnabled(false);
            this.matchAllRadio.setEnabled(false);
            this.conditionsPanel.setEnabled(false);
            this.moreButton.setEnabled(false);
            this.fewerButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.matchGroup.add(this.matchAllRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.matchAllRadio, (String)NbBundle.getMessage(KeywordsPanel.class, (String)"MatchAll"));
        this.matchAllRadio.setToolTipText(NbBundle.getMessage(KeywordsPanel.class, (String)"HINT_MatchAll"));
        this.matchAllRadio.setOpaque(false);
        this.matchGroup.add(this.matchAnyRadio);
        this.matchAnyRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.matchAnyRadio, (String)NbBundle.getMessage(KeywordsPanel.class, (String)"MatchAny"));
        this.matchAnyRadio.setToolTipText(NbBundle.getMessage(KeywordsPanel.class, (String)"HINT_MatchAny"));
        this.matchAnyRadio.setOpaque(false);
        this.conditionsScrollPane.setVerticalScrollBarPolicy(22);
        this.conditionsScrollPane.setAlignmentX(0.0f);
        this.conditionsScrollPane.setAlignmentY(0.0f);
        this.conditionsScrollPane.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.conditionsPanel.setLayout(new GridBagLayout());
        this.conditionsScrollPane.setViewportView(this.conditionsPanel);
        Mnemonics.setLocalizedText((AbstractButton)this.fewerButton, (String)NbBundle.getMessage(KeywordsPanel.class, (String)"Fewer"));
        this.fewerButton.setToolTipText(NbBundle.getMessage(KeywordsPanel.class, (String)"HINT_Fewer"));
        Mnemonics.setLocalizedText((AbstractButton)this.moreButton, (String)NbBundle.getMessage(KeywordsPanel.class, (String)"More"));
        this.moreButton.setToolTipText(NbBundle.getMessage(KeywordsPanel.class, (String)"HINT_More"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.moreButton).addPreferredGap(0).add((Component)this.fewerButton)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.matchAllRadio, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.matchAnyRadio, -1, -1, Short.MAX_VALUE).add(278, 278, 278)).add(2, (Component)this.conditionsScrollPane, -1, 584, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.matchAllRadio).add((Component)this.matchAnyRadio)).addPreferredGap(0).add((Component)this.conditionsScrollPane, -1, 321, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.fewerButton).add((Component)this.moreButton)).addContainerGap()));
        this.conditionsScrollPane.getAccessibleContext().setAccessibleName(null);
        this.conditionsScrollPane.getAccessibleContext().setAccessibleDescription(null);
    }

    private void initA11y() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KeywordsPanel.class, (String)"ACSD_Filter"));
        this.conditionsPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(KeywordsPanel.class, (String)"ACSN_Conditions"));
        this.conditionsPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KeywordsPanel.class, (String)"ACSD_Conditions"));
    }

    private ConditionPanel addCondition(boolean revalidate, AppliedFilterCondition condition) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        ConditionPanel panel = new ConditionPanel(this.filter, condition);
        panel.addPropertyChangeListener("value-valid", this);
        panel.setBackground((Color)UIManager.get("Table.background"));
        this.conditionsPanel.add((Component)panel, gridBagConstraints);
        if (revalidate) {
            this.invalidate();
            this.getParent().validate();
            this.repaint();
        }
        this.putClientProperty("value-valid", this.isValueValid());
        return panel;
    }

    public final boolean isValueValid() {
        Component[] cps = this.conditionsPanel.getComponents();
        for (int i = 0; i < cps.length; ++i) {
            ConditionPanel condition = (ConditionPanel)cps[i];
            if (condition == null || condition.isValueValid()) continue;
            return false;
        }
        return true;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.putClientProperty("value-valid", this.isValueValid());
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.moreButton) {
            ConditionPanel comp = this.addCondition(true, null);
            JScrollBar vsb = this.conditionsScrollPane.getVerticalScrollBar();
            vsb.setValue(vsb.getMaximum());
            comp.focusPropertyCombo();
        } else if (source == this.fewerButton) {
            this.conditionsPanel.remove(this.conditionsPanel.getComponentCount() - 1);
            this.invalidate();
            this.getParent().validate();
            this.repaint();
        }
        this.updateSensitivity();
        this.putClientProperty("value-valid", this.isValueValid());
    }

    private void updateSensitivity() {
        int n = this.conditionsPanel.getComponentCount();
        this.fewerButton.setEnabled(n > 0);
    }

    public KeywordsFilter getFilter() {
        if (this.filter != null) {
            Component[] cps = this.conditionsPanel.getComponents();
            ArrayList<AppliedFilterCondition> conditions = new ArrayList<AppliedFilterCondition>(cps.length);
            for (int i = 0; i < cps.length; ++i) {
                AppliedFilterCondition condition = ((ConditionPanel)cps[i]).getCondition();
                if (condition == null) continue;
                conditions.add(condition);
            }
            this.filter.setConditions(conditions);
            this.filter.setMatchAll(this.matchAllRadio.isSelected());
            if (this.subpanel != null) {
                this.subpanel.updateFilter(this.filter);
            }
        }
        return this.filter;
    }
}

