/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.tasklist.filter.OneOfFilterCondition;
import org.netbeans.modules.tasklist.filter.Util;

class StringFilterCondition
extends OneOfFilterCondition {
    public static final int EQUALS = 0;
    public static final int NOTEQUALS = 1;
    public static final int CONTAINS = 2;
    public static final int DOESNOTCONTAIN = 3;
    public static final int BEGINSWITH = 4;
    public static final int ENDSWITH = 5;
    public static final int CEQUALS = 6;
    public static final int CCONTAINS = 7;
    public static final int CDOESNOTCONTAIN = 8;
    public static final int CBEGINSWITH = 9;
    public static final int CENDSWITH = 10;
    private static String[] NAME_KEYS = new String[]{"Equals", "NotEquals", "Contains", "DoesNotContain", "BeginsWith", "EndsWith", "CEquals", "CContains", "CDoesNotContain", "CBeginsWith", "CEndsWith"};
    private String constant = "";

    public static StringFilterCondition[] createConditions() {
        return new StringFilterCondition[]{new StringFilterCondition(2), new StringFilterCondition(3), new StringFilterCondition(4), new StringFilterCondition(5), new StringFilterCondition(0), new StringFilterCondition(1), new StringFilterCondition(7), new StringFilterCondition(8), new StringFilterCondition(9), new StringFilterCondition(10), new StringFilterCondition(6)};
    }

    public StringFilterCondition(int id) {
        super(NAME_KEYS, id);
    }

    public StringFilterCondition(int id, String value) {
        this(id);
        this.constant = value;
    }

    public StringFilterCondition(StringFilterCondition rhs) {
        super(rhs);
        this.constant = rhs.constant;
    }

    public Object clone() {
        return new StringFilterCondition(this);
    }

    StringFilterCondition() {
        super(NAME_KEYS);
        this.constant = null;
    }

    public String getConstant() {
        return this.constant;
    }

    public JComponent createConstantComponent() {
        final JTextField tf = new JTextField();
        tf.setText(this.constant);
        tf.setToolTipText(Util.getString("string_desc"));
        tf.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                Boolean valid = !"".equals(tf.getText());
                tf.putClientProperty("value-valid", valid);
            }

            public void insertUpdate(DocumentEvent e) {
                Boolean valid = !"".equals(tf.getText());
                tf.putClientProperty("value-valid", valid);
            }

            public void removeUpdate(DocumentEvent e) {
                Boolean valid = !"".equals(tf.getText());
                tf.putClientProperty("value-valid", valid);
            }
        });
        return tf;
    }

    public void getConstantFrom(JComponent cmp) {
        JTextField tf = (JTextField)cmp;
        this.constant = tf.getText();
    }

    public boolean isTrue(Object obj) {
        String s = obj == null ? "" : obj.toString();
        switch (this.getId()) {
            case 0: {
                return s.equalsIgnoreCase(this.constant);
            }
            case 1: {
                return !s.equalsIgnoreCase(this.constant);
            }
            case 2: {
                return s.toLowerCase().indexOf(this.constant.toLowerCase()) >= 0;
            }
            case 3: {
                return s.toLowerCase().indexOf(this.constant.toLowerCase()) < 0;
            }
            case 4: {
                return s.toLowerCase().startsWith(this.constant.toLowerCase());
            }
            case 5: {
                return s.toLowerCase().endsWith(this.constant.toLowerCase());
            }
            case 6: {
                return s.equals(this.constant);
            }
            case 7: {
                return s.indexOf(this.constant) >= 0;
            }
            case 8: {
                return s.indexOf(this.constant) < 0;
            }
            case 9: {
                return s.startsWith(this.constant);
            }
            case 10: {
                return s.endsWith(this.constant);
            }
        }
        throw new InternalError("wrong id");
    }

    void load(Preferences prefs, String prefix) throws BackingStoreException {
        super.load(prefs, prefix);
        this.constant = prefs.get(prefix + "_constant", "");
    }

    void save(Preferences prefs, String prefix) throws BackingStoreException {
        super.save(prefs, prefix);
        prefs.put(prefix + "_constant", this.constant);
    }
}

