/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.tasklist.filter.KeywordsFilter;
import org.netbeans.modules.tasklist.filter.TypesFilter;
import org.netbeans.modules.tasklist.filter.Util;
import org.netbeans.modules.tasklist.impl.ScannerDescriptor;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.netbeans.spi.tasklist.Task;

public final class TaskFilter {
    public static final TaskFilter EMPTY = new TaskFilter(Util.getString("no-filter"));
    private String name;
    private KeywordsFilter keywords;
    private TypesFilter types;

    TaskFilter(String name) {
        this.name = name;
    }

    TaskFilter() {
    }

    private TaskFilter(TaskFilter src) {
        this.name = src.name;
        this.keywords = null == src.keywords ? null : (KeywordsFilter)src.keywords.clone();
        this.types = null == src.types ? null : src.types.clone();
    }

    public boolean accept(Task task) {
        return null == this.keywords ? true : this.keywords.accept(task);
    }

    public boolean isEnabled(FileTaskScanner scanner) {
        return null == this.types ? true : this.types.isEnabled(ScannerDescriptor.getType(scanner));
    }

    public boolean isEnabled(PushTaskScanner scanner) {
        return null == this.types ? true : this.types.isEnabled(ScannerDescriptor.getType(scanner));
    }

    public boolean isTaskCountLimitReached(int currentTaskCount) {
        return null == this.types ? false : this.types.isTaskCountLimitReached(currentTaskCount);
    }

    public String getName() {
        return this.name;
    }

    void setName(String newName) {
        this.name = newName;
    }

    KeywordsFilter getKeywordsFilter() {
        return this.keywords;
    }

    void setKeywordsFilter(KeywordsFilter f) {
        this.keywords = f;
    }

    TypesFilter getTypesFilter() {
        return this.types;
    }

    void setTypesFilter(TypesFilter f) {
        this.types = f;
    }

    public Object clone() {
        return new TaskFilter(this);
    }

    public String toString() {
        return this.name;
    }

    void load(Preferences prefs, String prefix) throws BackingStoreException {
        this.name = prefs.get(prefix + "_name", "Filter");
        if (prefs.getBoolean(prefix + "_types", false)) {
            this.types = new TypesFilter();
            this.types.load(prefs, prefix + "_types");
        } else {
            this.types = null;
        }
        if (prefs.getBoolean(prefix + "_keywords", false)) {
            this.keywords = new KeywordsFilter();
            this.keywords.load(prefs, prefix + "_keywords");
        } else {
            this.keywords = null;
        }
    }

    void save(Preferences prefs, String prefix) throws BackingStoreException {
        prefs.put(prefix + "_name", this.name);
        if (null != this.types) {
            prefs.putBoolean(prefix + "_types", true);
            this.types.save(prefs, prefix + "_types");
        } else {
            prefs.putBoolean(prefix + "_types", false);
        }
        if (null != this.keywords) {
            prefs.putBoolean(prefix + "_keywords", true);
            this.keywords.save(prefs, prefix + "_keywords");
        } else {
            prefs.putBoolean(prefix + "_keywords", false);
        }
    }
}

