/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrentEditorScanningScope
extends TaskScanningScope
implements PropertyChangeListener {
    private FileObject lastActiveFile = null;
    private TaskScanningScope.Callback callback;
    private InstanceContent lookupContent = new InstanceContent();
    private Lookup lookup;

    public CurrentEditorScanningScope(String displayName, String description, Image icon) {
        super(displayName, description, icon);
    }

    public static CurrentEditorScanningScope create() {
        return new CurrentEditorScanningScope(NbBundle.getBundle(CurrentEditorScanningScope.class).getString("LBL_CurrentEditorScope"), NbBundle.getBundle(CurrentEditorScanningScope.class).getString("HINT_CurrentEditorScope"), Utilities.loadImage((String)"org/netbeans/modules/tasklist/ui/resources/cur_editor_scope.png"));
    }

    public Iterator<FileObject> iterator() {
        ArrayList<FileObject> list = new ArrayList<FileObject>(1);
        FileObject currentFile = this.getCurrentFile();
        if (null != currentFile) {
            list.add(currentFile);
        }
        return list.iterator();
    }

    public boolean isInScope(FileObject resource) {
        if (null == resource) {
            return false;
        }
        FileObject activeFile = this.getCurrentFile();
        return null != activeFile && activeFile.equals(resource);
    }

    public Lookup getLookup() {
        if (null == this.lookup) {
            this.lookup = new AbstractLookup((AbstractLookup.Content)this.lookupContent);
        }
        return this.lookup;
    }

    public void attach(TaskScanningScope.Callback newCallback) {
        if (null != newCallback && null == this.callback) {
            WindowManager.getDefault().getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        } else if (null == newCallback && null != this.callback) {
            WindowManager.getDefault().getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
            if (null != this.lastActiveFile) {
                this.lookupContent.remove((Object)this.lastActiveFile);
            }
            this.lastActiveFile = null;
        }
        this.callback = newCallback;
        if (null != this.callback) {
            this.lastActiveFile = this.getCurrentFile();
            if (null != this.lastActiveFile) {
                this.lookupContent.add((Object)this.lastActiveFile);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("activatedNodes".equals(e.getPropertyName()) || "opened".equals(e.getPropertyName()) || "activated".equals(e.getPropertyName())) {
            FileObject newActiveFile = this.getCurrentFile();
            if (null == this.lastActiveFile && null != newActiveFile || null != this.lastActiveFile && null == newActiveFile || null != this.lastActiveFile && null != newActiveFile && !this.lastActiveFile.equals(newActiveFile)) {
                if (null != this.lastActiveFile) {
                    this.lookupContent.remove((Object)this.lastActiveFile);
                }
                if (null != newActiveFile) {
                    this.lookupContent.add((Object)newActiveFile);
                }
                if (null != this.callback) {
                    this.callback.refresh();
                }
            }
            this.lastActiveFile = newActiveFile;
        }
    }

    private FileObject getCurrentFile() {
        TopComponent.Registry registry = TopComponent.getRegistry();
        TopComponent activeTc = registry.getActivated();
        FileObject currentFile = this.getFileFromTopComponent(activeTc);
        ArrayList<FileObject> availableFiles = new ArrayList<FileObject>(3);
        if (null == currentFile) {
            ArrayList openedTcs = new ArrayList(registry.getOpened());
            for (TopComponent tc : openedTcs) {
                FileObject file = this.getFileFromTopComponent(tc);
                if (null == file) continue;
                availableFiles.add(file);
            }
            if (null != this.lastActiveFile && availableFiles.contains(this.lastActiveFile)) {
                currentFile = this.lastActiveFile;
            } else if (availableFiles.size() > 0) {
                currentFile = (FileObject)availableFiles.get(0);
            }
        }
        return currentFile;
    }

    private FileObject getFileFromTopComponent(TopComponent tc) {
        DataObject dob;
        if (null == tc || !tc.isShowing()) {
            return null;
        }
        if (WindowManager.getDefault().isEditorTopComponent(tc) && null != (dob = (DataObject)tc.getLookup().lookup(DataObject.class))) {
            return dob.getPrimaryFile();
        }
        return null;
    }
}

