/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.spi.tasklist.Task;
import org.openide.cookies.EditCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class OpenTaskAction
extends AbstractAction {
    private Task task;
    private static final int OPEN_EDITOR_WAIT_PERIOD_MS = 100;
    private static final int OPEN_EDITOR_TOTAL_TIMEOUT_MS = 1000;

    public OpenTaskAction(Task task) {
        super(NbBundle.getMessage(OpenTaskAction.class, (String)"LBL_ShowSource"));
        assert (null != task);
        this.task = task;
        this.setEnabled(this.canOpenTask());
    }

    public void actionPerformed(ActionEvent e) {
        DataObject dataObject;
        if (!this.canOpenTask()) {
            return;
        }
        ActionListener al = Accessor.getActionListener(this.task);
        if (null != al) {
            al.actionPerformed(e);
            return;
        }
        FileObject fileObject = Accessor.getResource(this.task);
        int line = Accessor.getLine(this.task) - 1;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException donfE) {
            return;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (null != lineCookie) {
            this.openAt(lineCookie, line);
            return;
        }
        EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
        if (null != editCookie) {
            editCookie.edit();
            return;
        }
        OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
        if (null != openCookie) {
            openCookie.open();
            return;
        }
        ViewCookie viewCookie = (ViewCookie)dataObject.getCookie(ViewCookie.class);
        if (null != viewCookie) {
            viewCookie.view();
            return;
        }
    }

    private void openAt(LineCookie lineCookie, int lineNo) {
        Line.Set lines = lineCookie.getLineSet();
        Line line = lines.getCurrent(lineNo);
        if (null == line) {
            line = lines.getCurrent(0);
        }
        if (null != line) {
            line.show(3);
        }
    }

    private boolean canOpenTask() {
        if (null != Accessor.getActionListener(this.task)) {
            return true;
        }
        FileObject fo = Accessor.getResource(this.task);
        if (null == fo) {
            return false;
        }
        DataObject dob = null;
        try {
            dob = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException donfE) {
            return false;
        }
        if (Accessor.getLine(this.task) > 0) {
            return null != dob.getCookie(LineCookie.class);
        }
        return null != dob.getCookie(OpenCookie.class) || null != dob.getCookie(EditCookie.class) || null != dob.getCookie(ViewCookie.class);
    }
}

