/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ScanResult {
    private Map<FileTaskScanner, Result> scanTimes = new HashMap<FileTaskScanner, Result>(8);

    public boolean isUpToDate(FileObject resource, FileTaskScanner scanner) {
        boolean res = false;
        Result type = this.scanTimes.get(scanner);
        if (null != type && null != resource) {
            res = resource.lastModified().before(type.scanTime);
        }
        return res;
    }

    public void put(FileTaskScanner scanner, List<? extends Task> tasks) {
        Result res = this.scanTimes.get(scanner);
        if (null == res) {
            res = new Result();
            this.scanTimes.put(scanner, res);
        }
        res.scanTime = new Date();
        if (tasks.isEmpty()) {
            res.tasks = null;
        } else {
            res.tasks = new ArrayList<Task>(tasks);
        }
    }

    public void get(FileTaskScanner scanner, List<Task> tasks) {
        Result res = this.scanTimes.get(scanner);
        if (null != res && null != res.tasks) {
            tasks.addAll(res.tasks);
        }
    }

    public void remove(FileTaskScanner scanner) {
        this.scanTimes.remove(scanner);
    }

    public boolean isEmpty() {
        return this.scanTimes.isEmpty();
    }

    private static class Result {
        private Date scanTime;
        private List<Task> tasks;

        private Result() {
        }
    }
}

