/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.tasklist.impl.ScanResult;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TaskCache {
    private WeakHashMap<FileObject, ScanResult> cache = new WeakHashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    TaskCache() {
    }

    public boolean isUpToDate(FileObject resource, FileTaskScanner scanner) {
        boolean retValue = false;
        this.lock.readLock().lock();
        ScanResult scanRes = this.cache.get(resource);
        if (null != scanRes) {
            retValue = scanRes.isUpToDate(resource, scanner);
        }
        this.lock.readLock().unlock();
        return retValue;
    }

    public void scanned(FileObject resource, FileTaskScanner scanner, List<? extends Task> tasks) {
        this.lock.writeLock().lock();
        ScanResult scanRes = this.cache.get(resource);
        if (null == scanRes) {
            scanRes = new ScanResult();
            this.cache.put(resource, scanRes);
        }
        scanRes.put(scanner, tasks);
        this.lock.writeLock().unlock();
    }

    public void getTasks(FileObject resource, FileTaskScanner scanner, List<Task> tasks) {
        this.lock.readLock().lock();
        ScanResult scanRes = this.cache.get(resource);
        if (null != scanRes) {
            scanRes.get(scanner, tasks);
        }
        this.lock.readLock().unlock();
    }

    public void clear(FileTaskScanner scanner) {
        this.lock.writeLock().lock();
        ArrayList<FileObject> toRemove = null;
        for (FileObject rc : this.cache.keySet()) {
            ScanResult scanRes = this.cache.get(rc);
            scanRes.remove(scanner);
            if (!scanRes.isEmpty()) continue;
            if (null == toRemove) {
                toRemove = new ArrayList<FileObject>();
            }
            toRemove.add(rc);
        }
        if (null != toRemove) {
            for (FileObject rc : toRemove) {
                this.cache.remove(rc);
            }
        }
        this.lock.writeLock().unlock();
    }

    public void clear(FileTaskScanner scanner, FileObject[] resources) {
        this.lock.writeLock().lock();
        for (FileObject rc : resources) {
            ScanResult scanRes = this.cache.get(rc);
            if (null == scanRes) continue;
            scanRes.remove(scanner);
            if (!scanRes.isEmpty()) continue;
            this.cache.remove(rc);
        }
        this.lock.writeLock().unlock();
    }

    public void clear(FileObject resource) {
        this.lock.writeLock().lock();
        ScanResult scanRes = this.cache.get(resource);
        if (null != scanRes) {
            this.cache.remove(resource);
        }
        this.lock.writeLock().unlock();
    }
}

