/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.util.List;
import javax.swing.JLabel;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.modules.tasklist.trampoline.TaskGroup;
import org.netbeans.spi.tasklist.Task;

class StatusBar
extends JLabel {
    private TaskList tasks;
    private TaskList.Listener listener;

    public StatusBar(TaskList tasks) {
        this.tasks = tasks;
        this.listener = new TaskList.Listener(){

            @Override
            public void tasksAdded(List<? extends Task> tasks) {
                StatusBar.this.updateText();
            }

            @Override
            public void tasksRemoved(List<? extends Task> tasks) {
                StatusBar.this.updateText();
            }

            @Override
            public void cleared() {
                StatusBar.this.updateText();
            }
        };
        this.updateText();
    }

    private void updateText() {
        StringBuffer buffer = new StringBuffer();
        for (TaskGroup tg : TaskGroup.getGroups()) {
            int count = this.tasks.countTasks(tg);
            if (count <= 0) continue;
            if (buffer.length() > 0) {
                buffer.append("  ");
            } else {
                buffer.append(' ');
            }
            buffer.append(tg.getDisplayName());
            buffer.append(": ");
            buffer.append(count);
        }
        buffer.append(' ');
        this.setText(buffer.toString());
    }

    public void removeNotify() {
        super.removeNotify();
        this.tasks.removeListener(this.listener);
    }

    public void addNotify() {
        super.addNotify();
        this.tasks.addListener(this.listener);
    }
}

