/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.tasklist.filter.FilterRepository;
import org.netbeans.modules.tasklist.impl.ScanningScopeList;
import org.netbeans.modules.tasklist.impl.TaskManagerImpl;
import org.netbeans.modules.tasklist.ui.FiltersMenuButton;
import org.netbeans.modules.tasklist.ui.FoldingTaskListModel;
import org.netbeans.modules.tasklist.ui.ScopeButton;
import org.netbeans.modules.tasklist.ui.Settings;
import org.netbeans.modules.tasklist.ui.StatusBar;
import org.netbeans.modules.tasklist.ui.TaskListModel;
import org.netbeans.modules.tasklist.ui.TaskListTable;
import org.netbeans.modules.tasklist.ui.Util;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class TaskListTopComponent
extends TopComponent {
    private static TaskListTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/tasklist/ui/resources/taskList.png";
    private static final String PREFERRED_ID = "TaskListTopComponent";
    private TaskManagerImpl taskManager = TaskManagerImpl.getInstance();
    private PropertyChangeListener scopeListListener;
    private TaskListModel model;
    private FilterRepository filters;
    private TaskListTable table;
    private PropertyChangeListener changeListener;
    private JPanel statusBarPanel;
    private JSeparator statusSeparator;
    private JPanel tableHolderPanel;
    private JScrollPane tableScroll;
    private JToolBar toolbar;
    private JSeparator toolbarSeparator;
    private ProgressHandle progress;

    private TaskListTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(TaskListTopComponent.class, (String)"CTL_TaskListTopComponent"));
        this.setToolTipText(NbBundle.getMessage(TaskListTopComponent.class, (String)"HINT_TaskListTopComponent"));
        this.setIcon(Utilities.loadImage((String)ICON_PATH, (boolean)true));
        this.tableScroll.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                TaskListTopComponent.this.maybePopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                TaskListTopComponent.this.maybePopup(e);
            }
        });
    }

    private void initComponents() {
        this.toolbar = new JToolBar();
        this.tableHolderPanel = new JPanel();
        this.tableScroll = new JScrollPane();
        this.toolbarSeparator = new JSeparator();
        this.statusSeparator = new JSeparator();
        this.statusBarPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.toolbar.setFloatable(false);
        this.toolbar.setOrientation(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.add(this.toolbar, gridBagConstraints);
        this.tableHolderPanel.setOpaque(false);
        this.tableScroll.setBorder(null);
        GroupLayout tableHolderPanelLayout = new GroupLayout((Container)this.tableHolderPanel);
        this.tableHolderPanel.setLayout((LayoutManager)tableHolderPanelLayout);
        tableHolderPanelLayout.setHorizontalGroup((GroupLayout.Group)tableHolderPanelLayout.createParallelGroup(1).add(2, (Component)this.tableScroll, -1, 397, Short.MAX_VALUE));
        tableHolderPanelLayout.setVerticalGroup((GroupLayout.Group)tableHolderPanelLayout.createParallelGroup(1).add((Component)this.tableScroll, -1, 299, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.tableHolderPanel, gridBagConstraints);
        this.toolbarSeparator.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.add(this.toolbarSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.add(this.statusSeparator, gridBagConstraints);
        this.statusBarPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        this.add(this.statusBarPanel, gridBagConstraints);
    }

    public static synchronized TaskListTopComponent getDefault() {
        if (instance == null) {
            instance = new TaskListTopComponent();
        }
        return instance;
    }

    public static synchronized TaskListTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            TaskListTopComponent.getLogger().log(Level.INFO, "Cannot find TaskList component. It will not be located properly in the window system.");
            return TaskListTopComponent.getDefault();
        }
        if (win instanceof TaskListTopComponent) {
            return (TaskListTopComponent)win;
        }
        TaskListTopComponent.getLogger().log(Level.INFO, "There seem to be multiple components with the 'TaskListTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return TaskListTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        TaskScanningScope activeScope = Settings.getDefault().getActiveScanningScope();
        if (null == activeScope) {
            activeScope = ScanningScopeList.getDefault().getDefaultScope();
        }
        if (null == this.filters) {
            try {
                this.filters = FilterRepository.getDefault();
                this.filters.load();
            }
            catch (IOException ioE) {
                TaskListTopComponent.getLogger().log(Level.INFO, ioE.getMessage(), ioE);
            }
        }
        this.taskManager.addPropertyChangeListener("workingStatus", this.getChangeListener());
        if (null == this.model) {
            this.table = new TaskListTable();
            this.model = new TaskListModel(this.taskManager.getTasks());
            this.table.setModel(this.model);
            this.tableScroll.setViewportView(this.table);
            this.tableScroll.setBorder(BorderFactory.createEmptyBorder());
            this.statusBarPanel.add((Component)new StatusBar(this.taskManager.getTasks()), "Center");
        }
        ScanningScopeList.getDefault().addPropertyChangeListener(this.getScopeListListener());
        this.rebuildToolbar();
        final TaskScanningScope scopeToObserve = activeScope;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TaskListTopComponent.this.taskManager.observe(scopeToObserve, TaskListTopComponent.this.filters.getActive());
            }
        });
    }

    public void componentClosed() {
        ScanningScopeList.getDefault().removePropertyChangeListener(this.getScopeListListener());
        this.taskManager.observe(null, null);
        this.taskManager.removePropertyChangeListener("workingStatus", this.getChangeListener());
        try {
            FilterRepository.getDefault().save();
        }
        catch (IOException ioE) {
            TaskListTopComponent.getLogger().log(Level.INFO, null, ioE);
        }
    }

    public void requestActive() {
        super.requestActive();
        this.table.requestFocusInWindow();
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private void maybePopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            e.consume();
            JPopupMenu popup = Util.createPopup(this.table);
            popup.show((Component)((Object)this), e.getX(), e.getY());
        }
    }

    private PropertyChangeListener getScopeListListener() {
        if (null == this.scopeListListener) {
            this.scopeListListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent arg0) {
                    ScanningScopeList scopeList = ScanningScopeList.getDefault();
                    TaskScanningScope currentScope = TaskListTopComponent.this.taskManager.getScope();
                    List<TaskScanningScope> newScopes = scopeList.getTaskScanningScopes();
                    if (newScopes.isEmpty()) {
                        TaskListTopComponent.getLogger().log(Level.INFO, "No task scanning scope found");
                    }
                    TaskListTopComponent.this.rebuildToolbar();
                }
            };
        }
        return this.scopeListListener;
    }

    private void rebuildToolbar() {
        this.toolbar.removeAll();
        this.toolbar.setFocusable(false);
        List<TaskScanningScope> scopes = ScanningScopeList.getDefault().getTaskScanningScopes();
        for (TaskScanningScope scope : scopes) {
            this.toolbar.add(new ScopeButton(this.taskManager, scope));
        }
        this.toolbar.add(new JToolBar.Separator());
        FiltersMenuButton toggleFilter = new FiltersMenuButton(this.filters.getActive());
        this.toolbar.add(toggleFilter);
        this.toolbar.addSeparator();
        final JToggleButton toggleGroups = new JToggleButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/tasklist/ui/resources/groups.png")));
        toggleGroups.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                TaskListTopComponent.this.switchTableModel(e.getStateChange() == 1);
                Settings.getDefault().setGroupTasksByCategory(toggleGroups.isSelected());
                toggleGroups.setToolTipText(toggleGroups.isSelected() ? NbBundle.getMessage(TaskListTopComponent.class, (String)"HINT_TasksAsList") : NbBundle.getMessage(TaskListTopComponent.class, (String)"HINT_GrouppedTasks"));
            }
        });
        toggleGroups.setSelected(Settings.getDefault().getGroupTasksByCategory());
        toggleGroups.setToolTipText(toggleGroups.isSelected() ? NbBundle.getMessage(TaskListTopComponent.class, (String)"HINT_TasksAsList") : NbBundle.getMessage(TaskListTopComponent.class, (String)"HINT_GrouppedTasks"));
        toggleGroups.setFocusable(false);
        this.toolbar.add(toggleGroups);
    }

    private void switchTableModel(boolean useFoldingModel) {
        if (useFoldingModel) {
            this.model = new FoldingTaskListModel(this.taskManager.getTasks());
            this.table.setModel(this.model);
            this.statusBarPanel.removeAll();
        } else {
            this.model = new TaskListModel(this.taskManager.getTasks());
            this.table.setModel(this.model);
            this.statusBarPanel.add((Component)new StatusBar(this.taskManager.getTasks()), "Center");
        }
        this.statusBarPanel.setVisible(!useFoldingModel);
        this.statusSeparator.setVisible(!useFoldingModel);
    }

    private static Logger getLogger() {
        return Logger.getLogger(TaskListTopComponent.class.getName());
    }

    private PropertyChangeListener getChangeListener() {
        if (null == this.changeListener) {
            this.changeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (((Boolean)e.getNewValue()).booleanValue()) {
                        if (null == TaskListTopComponent.this.progress) {
                            TaskListTopComponent.this.progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(TaskListTopComponent.class, (String)"LBL_ScanProgress"), (Cancellable)new Cancellable(){

                                public boolean cancel() {
                                    TaskListTopComponent.this.taskManager.abort();
                                    return true;
                                }
                            });
                        }
                        TaskListTopComponent.this.progress.start();
                        TaskListTopComponent.this.progress.switchToIndeterminate();
                    } else {
                        if (null != TaskListTopComponent.this.progress) {
                            TaskListTopComponent.this.progress.finish();
                        }
                        TaskListTopComponent.this.progress = null;
                    }
                }
            };
        }
        return this.changeListener;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return TaskListTopComponent.getDefault();
        }
    }
}

