/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.autoupdate;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.services.OperationContainerImpl;
import org.netbeans.modules.autoupdate.services.UpdateManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperationContainer<Support> {
    OperationContainerImpl<Support> impl;
    private Support support;
    private boolean init = false;

    public static OperationContainer<InstallSupport> createForInstall() {
        OperationContainer<InstallSupport> retval = new OperationContainer<InstallSupport>(OperationContainerImpl.createForInstall(), new InstallSupport());
        retval.getSupport().setContainer(retval);
        return retval;
    }

    public static OperationContainer<OperationSupport> createForDirectInstall() {
        OperationContainer<OperationSupport> retval = new OperationContainer<OperationSupport>(OperationContainerImpl.createForDirectInstall(), new OperationSupport());
        retval.getSupport().setContainer(retval);
        return retval;
    }

    public static OperationContainer<InstallSupport> createForUpdate() {
        OperationContainer<InstallSupport> retval = new OperationContainer<InstallSupport>(OperationContainerImpl.createForUpdate(), new InstallSupport());
        retval.getSupport().setContainer(retval);
        return retval;
    }

    public static OperationContainer<OperationSupport> createForDirectUpdate() {
        OperationContainer<OperationSupport> retval = new OperationContainer<OperationSupport>(OperationContainerImpl.createForDirectUpdate(), new OperationSupport());
        retval.getSupport().setContainer(retval);
        return retval;
    }

    public static OperationContainer<OperationSupport> createForUninstall() {
        OperationContainer<OperationSupport> retval = new OperationContainer<OperationSupport>(OperationContainerImpl.createForUninstall(), new OperationSupport());
        retval.getSupport().setContainer(retval);
        return retval;
    }

    public static OperationContainer<OperationSupport> createForEnable() {
        OperationContainer<OperationSupport> retval = new OperationContainer<OperationSupport>(OperationContainerImpl.createForEnable(), new OperationSupport());
        retval.getSupport().setContainer(retval);
        return retval;
    }

    public static OperationContainer<OperationSupport> createForDisable() {
        OperationContainer<OperationSupport> retval = new OperationContainer<OperationSupport>(OperationContainerImpl.createForDisable(), new OperationSupport());
        retval.getSupport().setContainer(retval);
        return retval;
    }

    public Support getSupport() {
        if (!this.init) {
            this.init = true;
            return this.support;
        }
        return this.listAll().size() > 0 && this.listInvalid().size() == 0 ? (Support)this.support : null;
    }

    public boolean canBeAdded(UpdateUnit updateUnit, UpdateElement updateElement) {
        return this.impl.isValid(updateUnit, updateElement);
    }

    public void add(Collection<UpdateElement> elems) {
        if (elems == null) {
            throw new IllegalArgumentException("Cannot add null value.");
        }
        for (UpdateElement el : elems) {
            this.add(el);
        }
    }

    public void add(Map<UpdateUnit, UpdateElement> elems) {
        if (elems == null) {
            throw new IllegalArgumentException("Cannot add null value.");
        }
        for (Map.Entry<UpdateUnit, UpdateElement> entry : elems.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public OperationInfo<Support> add(UpdateUnit updateUnit, UpdateElement updateElement) {
        return this.impl.add(updateUnit, updateElement);
    }

    public OperationInfo<Support> add(UpdateElement updateElement) {
        UpdateUnit updateUnit = UpdateManagerImpl.getInstance().getUpdateUnit(updateElement.getCodeName());
        return this.impl.add(updateUnit, updateElement);
    }

    public void remove(Collection<UpdateElement> elems) {
        if (elems == null) {
            throw new IllegalArgumentException("Cannot add null value.");
        }
        for (UpdateElement el : elems) {
            this.remove(el);
        }
    }

    public boolean remove(UpdateElement updateElement) {
        return this.impl.remove(updateElement);
    }

    public boolean contains(UpdateElement updateElement) {
        return this.impl.contains(updateElement);
    }

    public List<OperationInfo<Support>> listAll() {
        return this.impl.listAll();
    }

    public List<OperationInfo<Support>> listInvalid() {
        return this.impl.listInvalid();
    }

    public void remove(OperationInfo<Support> op) {
        this.impl.remove(op);
    }

    public void removeAll() {
        this.impl.removeAll();
    }

    private OperationContainer(OperationContainerImpl<Support> impl, Support t) {
        this.impl = impl;
        this.support = t;
        impl.setOperationContainer(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperationInfo<Support> {
        OperationContainerImpl.OperationInfoImpl<Support> impl;

        OperationInfo(OperationContainerImpl.OperationInfoImpl<Support> impl) {
            this.impl = impl;
        }

        public UpdateElement getUpdateElement() {
            return this.impl.getUpdateElement();
        }

        public UpdateUnit getUpdateUnit() {
            return this.impl.getUpdateUnit();
        }

        public Set<UpdateElement> getRequiredElements() {
            return new LinkedHashSet<UpdateElement>(this.impl.getRequiredElements());
        }

        public Set<String> getBrokenDependencies() {
            return this.impl.getBrokenDependencies();
        }
    }
}

