/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DependencyChecker {
    private static final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.services");

    DependencyChecker() {
    }

    public static Set<Dependency> findBrokenDependencies(Set<Dependency> deps, Collection<ModuleInfo> modules) {
        HashSet<Dependency> res = new HashSet<Dependency>();
        for (Dependency dep : deps) {
            err.log(Level.FINE, "Dependency[" + dep.getType() + "]: " + dep);
            switch (dep.getType()) {
                case 5: {
                    if (DependencyChecker.findModuleMatchesDependencyRequires(dep, modules) != null) break;
                    res.add(dep);
                    break;
                }
                case 1: {
                    if (DependencyChecker.matchDependencyModule(dep, modules)) break;
                    res.add(dep);
                    break;
                }
                case 4: {
                    if (DependencyChecker.matchDependencyIde(dep, modules)) break;
                    res.add(dep);
                    break;
                }
                case 3: {
                    err.log(Level.FINE, "Check dependency on Java platform. Dependency: " + dep);
                    break;
                }
                default: {
                    err.log(Level.FINE, "Uncovered Dependency " + dep);
                }
            }
        }
        return res;
    }

    static ModuleInfo findModuleMatchesDependencyRequires(Dependency dep, Collection<ModuleInfo> modules) {
        for (ModuleInfo info : modules) {
            if (!Arrays.asList(info.getProvides()).contains(dep.getName())) continue;
            return info;
        }
        return null;
    }

    private static boolean matchDependencyModule(Dependency dep, Collection<ModuleInfo> modules) {
        for (ModuleInfo module : modules) {
            if (!DependencyChecker.checkDependencyModule(dep, module)) continue;
            return true;
        }
        return false;
    }

    static boolean checkDependencyModule(Dependency dep, ModuleInfo module) {
        boolean ok = false;
        if (dep.getName().equals(module.getCodeName())) {
            ok = dep.getComparison() == 3 ? true : (dep.getComparison() == 1 ? (module.getSpecificationVersion() == null ? false : new SpecificationVersion(dep.getVersion()).compareTo((Object)module.getSpecificationVersion()) <= 0) : (module.getImplementationVersion() == null ? false : module.getImplementationVersion().equals(dep.getVersion())));
        } else {
            int dash = dep.getName().indexOf(45);
            if (dash != -1) {
                int slash = dep.getName().indexOf(47);
                String cnb = dep.getName().substring(0, slash);
                int relMin = Integer.parseInt(dep.getName().substring(slash + 1, dash));
                int relMax = Integer.parseInt(dep.getName().substring(dash + 1));
                if (cnb.equals(module.getCodeNameBase()) && relMin <= module.getCodeNameRelease() && relMax >= module.getCodeNameRelease()) {
                    ok = dep.getComparison() == 3 ? true : (module.getCodeNameRelease() > relMin ? true : (module.getSpecificationVersion() == null ? false : new SpecificationVersion(dep.getVersion()).compareTo((Object)module.getSpecificationVersion()) <= 0));
                }
            }
        }
        return ok;
    }

    private static boolean matchDependencyIde(Dependency dep, Collection<ModuleInfo> modules) {
        for (ModuleInfo module : modules) {
            if (!DependencyChecker.checkDependencyIde(dep, module)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkDependencyIde(Dependency dep, ModuleInfo ide) {
        if (!ide.getCodeName().equals(dep.getName())) {
            return false;
        }
        if (dep.getComparison() == 1) {
            return new SpecificationVersion(dep.getVersion()).compareTo((Object)ide.getSpecificationVersion()) <= 0;
        }
        if (dep.getComparison() == 2) {
            return dep.getVersion().equals(ide.getImplementationVersion());
        }
        assert (false) : "Cannot have COMPARE_ANY on IDE dependency";
        return false;
    }
}

