/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DummyModuleInfo
extends ModuleInfo {
    private final Attributes attr;
    private final Set<Dependency> deps;
    private final String[] provides;

    public DummyModuleInfo(Attributes attr) throws IllegalArgumentException {
        this.attr = attr;
        if (this.getCodeName() == null) {
            throw new IllegalArgumentException();
        }
        String cnb = this.getCodeNameBase();
        try {
            this.getSpecificationVersion();
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(nfe.toString() + " from " + cnb);
        }
        this.deps = DummyModuleInfo.parseDeps(attr, cnb);
        String providesS = attr.getValue("OpenIDE-Module-Provides");
        if (providesS == null) {
            this.provides = new String[0];
        } else {
            StringTokenizer tok = new StringTokenizer(providesS, ", ");
            this.provides = new String[tok.countTokens()];
            for (int i = 0; i < this.provides.length; ++i) {
                this.provides[i] = tok.nextToken();
            }
        }
    }

    public boolean isEnabled() {
        return false;
    }

    public SpecificationVersion getSpecificationVersion() {
        String sv = this.attr.getValue("OpenIDE-Module-Specification-Version");
        return sv == null ? null : new SpecificationVersion(sv);
    }

    public String getCodeName() {
        return this.attr.getValue("OpenIDE-Module");
    }

    public int getCodeNameRelease() {
        String s = this.getCodeName();
        int idx = s.lastIndexOf(47);
        if (idx == -1) {
            return -1;
        }
        return Integer.parseInt(s.substring(idx + 1));
    }

    public String getCodeNameBase() {
        String s = this.getCodeName();
        int idx = s.lastIndexOf(47);
        if (idx == -1) {
            return s;
        }
        return s.substring(0, idx);
    }

    public Object getLocalizedAttribute(String a) {
        return this.attr.getValue(a);
    }

    public Object getAttribute(String a) {
        return this.attr.getValue(a);
    }

    public Set<Dependency> getDependencies() {
        return this.deps;
    }

    private static final Set<Dependency> parseDeps(Attributes attr, String cnb) throws IllegalArgumentException {
        HashSet<Dependency> s = new HashSet<Dependency>();
        s.addAll(Dependency.create((int)1, (String)attr.getValue("OpenIDE-Module-Module-Dependencies")));
        s.addAll(Dependency.create((int)2, (String)attr.getValue("OpenIDE-Module-Package-Dependencies")));
        s.addAll(Dependency.create((int)4, (String)attr.getValue("OpenIDE-Module-IDE-Dependencies")));
        s.addAll(Dependency.create((int)3, (String)attr.getValue("OpenIDE-Module-Java-Dependencies")));
        s.addAll(Dependency.create((int)5, (String)attr.getValue("OpenIDE-Module-Requires")));
        Iterator it = s.iterator();
        SpecificationVersion api = null;
        String impl = null;
        String major = null;
        while (it.hasNext()) {
            Dependency dep = (Dependency)it.next();
            if (dep.getType() != 4) continue;
            if (dep.getComparison() == 1) {
                if (api != null) {
                    throw new IllegalArgumentException("Duplicate OpenIDE-Module-IDE-Dependencies found!");
                }
                api = new SpecificationVersion(dep.getVersion());
            } else {
                if (impl != null) {
                    throw new IllegalArgumentException("Duplicate OpenIDE-Module-IDE-Dependencies found!");
                }
                impl = dep.getVersion();
            }
            String name = dep.getName();
            int index = name.lastIndexOf(47);
            String newmajor = index == -1 ? "" : name.substring(index);
            if (major != null && !major.equals(newmajor)) {
                throw new IllegalArgumentException("Clashing OpenIDE-Module-IDE-Dependencies found!");
            }
            major = newmajor;
            it.remove();
        }
        if (api != null) {
            s.addAll(Dependency.create((int)1, (String)("org.openide" + major + " > " + api)));
        }
        if (impl != null) {
            s.addAll(Dependency.create((int)1, (String)("org.openide" + major + " = " + impl)));
        }
        if (api != null || impl == null) {
            // empty if block
        }
        return s;
    }

    public boolean owns(Class clazz) {
        return false;
    }

    public String[] getProvides() {
        return this.provides;
    }
}

