/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.openide.modules.InstalledFileLocator;

public class InstallManager {
    static final String NBM_LIB = "lib";
    static final String NBM_CORE = "core";
    private static final Logger ERR = Logger.getLogger("org.netbeans.modules.autoupdate.services.InstallManager");

    static File findTargetDirectory(UpdateElement installed, UpdateElementImpl update) {
        File res = null;
        if (update.getInstallInfo().isGlobal() != null && update.getInstallInfo().isGlobal().booleanValue()) {
            if (installed != null) {
                res = InstallManager.getInstallDir(installed);
            } else {
                String targetCluster = update.getInstallInfo().getTargetCluster();
                File firstPossible = null;
                for (File cluster : Utilities.clusters(false)) {
                    if (firstPossible == null && cluster.isDirectory() && cluster.canWrite()) {
                        firstPossible = cluster;
                    }
                    if (targetCluster == null || !targetCluster.equals(cluster.getName()) || !cluster.canWrite()) continue;
                    res = cluster;
                    break;
                }
                if (res == null) {
                    assert (firstPossible != null) : "No writeable cluster found.";
                    res = firstPossible != null ? firstPossible : InstallManager.getUserDir();
                }
            }
        } else {
            res = InstallManager.getUserDir();
        }
        return res;
    }

    private static File getInstallDir(UpdateElement installed) {
        File res = null;
        UpdateElementImpl i = Trampoline.API.impl(installed);
        if (i.isModule()) {
            String configFile = "config/Modules/" + installed.getCodeName().replace('.', '-') + ".xml";
            res = InstalledFileLocator.getDefault().locate(configFile, installed.getCodeName(), false);
        } else assert (false) : "Unkown for Features now.";
        return res;
    }

    private static File getUserDir() {
        File userDir = new File(System.getProperty("netbeans.user"));
        userDir = new File(userDir.toURI().normalize()).getAbsoluteFile();
        return userDir;
    }

    static boolean needsRestart(boolean isUpdate, UpdateElementImpl update, File dest) {
        boolean needsRestart;
        assert (update.getInstallInfo() != null) : "Each UpdateElement must know own InstallInfo but " + update;
        boolean isForcedGlobal = update.getInstallInfo().needsRestart() != null && update.getInstallInfo().needsRestart() != false;
        boolean bl = needsRestart = isForcedGlobal || isUpdate;
        if (!needsRestart) {
            needsRestart = InstallManager.willInstallInSystem(dest);
        }
        return needsRestart;
    }

    private static boolean willInstallInSystem(File nbmFile) {
        boolean res = false;
        try {
            JarFile jf = new JarFile(nbmFile);
            for (JarEntry entry : Collections.list(jf.entries())) {
                String entryName = entry.getName();
                if (!entryName.startsWith("core/") && !entryName.startsWith("lib/")) continue;
                res = true;
                break;
            }
        }
        catch (IOException ioe) {
            ERR.log(Level.INFO, ioe.getMessage(), ioe);
        }
        return res;
    }
}

