/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Module;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.autoupdate.services.InstallManager;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.modules.autoupdate.services.Utils;
import org.netbeans.updater.UpdaterFrame;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallSupportImpl {
    private InstallSupport support;
    private boolean progressRunning = false;
    private static Logger err = Logger.getLogger(InstallSupportImpl.class.getName());
    public static final String UPDATE_DIR = "update";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String DOWNLOAD_DIR = "update" + FILE_SEPARATOR + "download";
    public static final String NBM_EXTENTSION = ".nbm";
    private Map<UpdateElementImpl, File> element2Clusters;
    private STEP currentStep = STEP.NOTSTARTED;
    private Collection<UpdateElement> trusted = new ArrayList<UpdateElement>();
    private Collection<UpdateElement> signed = new ArrayList<UpdateElement>();
    private Map<UpdateElement, Collection<Certificate>> certs = new HashMap<UpdateElement, Collection<Certificate>>();
    private ExecutorService es = Executors.newSingleThreadExecutor();
    private static final PropertyChangeListener refreshModulesListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent arg0) {
            FileObject modulesRoot = Repository.getDefault().getDefaultFileSystem().findResource("Modules");
            err.log(Level.FINE, "It's a hack: Call refresh on " + modulesRoot + " file object.");
            if (modulesRoot != null) {
                modulesRoot.getParent().refresh();
                modulesRoot.refresh();
            }
        }
    };

    public InstallSupportImpl(InstallSupport installSupport) {
        this.support = installSupport;
    }

    public boolean doDownload(final ProgressHandle progress) throws OperationException {
        Callable<Boolean> downloadCallable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Boolean call() throws Exception {
                assert (InstallSupportImpl.this.support.getContainer().listInvalid().isEmpty());
                1 var1_1 = this;
                synchronized (var1_1) {
                    InstallSupportImpl.this.currentStep = STEP.DOWNLOAD;
                }
                InstallSupportImpl.this.element2Clusters = new HashMap();
                List<OperationContainer.OperationInfo<InstallSupport>> infos = InstallSupportImpl.this.support.getContainer().listAll();
                int size = 0;
                for (OperationContainer.OperationInfo<InstallSupport> info : infos) {
                    size += info.getUpdateElement().getDownloadSize();
                }
                if (progress != null) {
                    progress.start();
                    progress.progress(NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_Download_Estabilish"));
                    InstallSupportImpl.this.progressRunning = false;
                }
                int aggregateDownload = 0;
                try {
                    for (OperationContainer.OperationInfo<InstallSupport> info : infos) {
                        1 var6_8 = this;
                        synchronized (var6_8) {
                            if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                                Boolean bl = false;
                                return bl;
                            }
                        }
                        int increment = InstallSupportImpl.this.doDownload(info, progress, aggregateDownload, size);
                        if (increment == -1) {
                            Boolean bl = false;
                            return bl;
                        }
                        aggregateDownload += increment;
                    }
                }
                finally {
                    if (progress != null) {
                        progress.progress("");
                        progress.finish();
                    }
                }
                if ($assertionsDisabled) return true;
                if (size == aggregateDownload) return true;
                throw new AssertionError((Object)("Was downloaded " + aggregateDownload + ", planned was " + size));
            }
        };
        boolean retval = false;
        try {
            retval = this.es.submit(downloadCallable).get();
        }
        catch (InterruptedException iex) {
            Exceptions.printStackTrace((Throwable)iex);
        }
        catch (ExecutionException iex) {
            if (!(iex.getCause() instanceof OperationException)) {
                Exceptions.printStackTrace((Throwable)iex);
            }
            throw (OperationException)iex.getCause();
        }
        return retval;
    }

    public boolean doValidate(InstallSupport.Validator validator, final ProgressHandle progress) throws OperationException {
        assert (validator != null);
        Callable<Boolean> validationCallable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public Boolean call() throws Exception {
                2 var1_1 = this;
                // MONITORENTER : var1_1
                assert (InstallSupportImpl.this.currentStep != STEP.FINISHED);
                if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                    // MONITOREXIT : var1_1
                    return false;
                }
                InstallSupportImpl.this.currentStep = STEP.VALIDATION;
                // MONITOREXIT : var1_1
                assert (InstallSupportImpl.this.support.getContainer().listInvalid().isEmpty());
                List<OperationContainer.OperationInfo<InstallSupport>> infos = InstallSupportImpl.this.support.getContainer().listAll();
                if (progress != null) {
                    progress.start();
                }
                int aggregateDownload = 0;
                try {
                    Iterator<OperationContainer.OperationInfo<InstallSupport>> i$ = infos.iterator();
                    while (i$.hasNext()) {
                        boolean hasCustom;
                        OperationContainer.OperationInfo<InstallSupport> info = i$.next();
                        2 var5_5 = this;
                        // MONITORENTER : var5_5
                        if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                            Boolean bl = false;
                            // MONITOREXIT : var5_5
                            return bl;
                        }
                        // MONITOREXIT : var5_5
                        UpdateElementImpl toUpdateImpl = Trampoline.API.impl(info.getUpdateElement());
                        boolean bl = hasCustom = toUpdateImpl.getInstallInfo().getCustomInstaller() != null;
                        if (hasCustom) continue;
                        InstallSupportImpl.this.doValidate(info, progress, aggregateDownload);
                    }
                    return true;
                }
                finally {
                    if (progress != null) {
                        progress.progress("");
                        progress.finish();
                    }
                }
            }
        };
        boolean retval = false;
        try {
            retval = this.es.submit(validationCallable).get();
        }
        catch (InterruptedException iex) {
            Exceptions.printStackTrace((Throwable)iex);
        }
        catch (ExecutionException iex) {
            Exceptions.printStackTrace((Throwable)iex);
        }
        return retval;
    }

    public Boolean doInstall(InstallSupport.Installer installer, final ProgressHandle progress) throws OperationException {
        assert (installer != null);
        Callable<Boolean> installCallable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                Object toUpdateImpl;
                3 var1_1 = this;
                synchronized (var1_1) {
                    assert (InstallSupportImpl.this.currentStep != STEP.FINISHED);
                    if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                        return false;
                    }
                    InstallSupportImpl.this.currentStep = STEP.INSTALLATION;
                }
                assert (InstallSupportImpl.this.support.getContainer().listInvalid().isEmpty());
                List<OperationContainer.OperationInfo<InstallSupport>> infos = InstallSupportImpl.this.support.getContainer().listAll();
                if (progress != null) {
                    progress.start();
                }
                boolean needsRestart = false;
                ArrayList<OperationContainer.OperationInfo<InstallSupport>> customs = new ArrayList<OperationContainer.OperationInfo<InstallSupport>>();
                ArrayList<File> files4custom = new ArrayList<File>();
                for (OperationContainer.OperationInfo<InstallSupport> info : infos) {
                    3 var7_8 = this;
                    synchronized (var7_8) {
                        if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                            return false;
                        }
                    }
                    toUpdateImpl = Trampoline.API.impl(info.getUpdateElement());
                    OperationContainer<InstallSupport> c = InstallSupportImpl.this.support.getContainer();
                    UpdateElement installed = info.getUpdateUnit().getInstalled();
                    File targetCluster = InstallSupportImpl.this.getTargetCluster(installed, (UpdateElementImpl)toUpdateImpl);
                    URL source = ((UpdateElementImpl)toUpdateImpl).getInstallInfo().getDistribution();
                    err.log(Level.FINE, "Source URL for " + ((UpdateElementImpl)toUpdateImpl).getCodeName() + " is " + source);
                    boolean isNbmFile = source.getFile().toLowerCase(Locale.US).endsWith(InstallSupportImpl.NBM_EXTENTSION.toLowerCase(Locale.US));
                    File dest = InstallSupportImpl.getDestination(targetCluster, ((UpdateElementImpl)toUpdateImpl).getCodeName(), isNbmFile);
                    needsRestart |= InstallSupportImpl.this.needsRestart(installed != null, (UpdateElementImpl)toUpdateImpl, dest);
                    if (((UpdateElementImpl)toUpdateImpl).getInstallInfo().getCustomInstaller() == null) continue;
                    customs.add(info);
                    files4custom.add(dest);
                }
                for (OperationContainer.OperationInfo<InstallSupport> info : customs) {
                    toUpdateImpl = this;
                    synchronized (toUpdateImpl) {
                        if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                            return false;
                        }
                    }
                    toUpdateImpl = Trampoline.API.impl(info.getUpdateElement());
                    assert (((UpdateElementImpl)toUpdateImpl).getInstallInfo().getCustomInstaller() != null);
                    err.log(Level.FINE, "Call CustomInstaller[" + ((UpdateElementImpl)toUpdateImpl).getInstallInfo().getCustomInstaller() + "] of UpdateElement " + info.getUpdateElement().getCodeName());
                    boolean res = ((UpdateElementImpl)toUpdateImpl).getInstallInfo().getCustomInstaller().install(((UpdateElementImpl)toUpdateImpl).getUpdateItemImpl().getUpdateItem(), (File)files4custom.get(customs.indexOf(info)));
                    if (res) continue;
                    throw new OperationException(OperationException.ERROR_TYPE.INSTALL, "Installation of " + info + " failed.");
                }
                if (!needsRestart) {
                    Iterator<OperationContainer.OperationInfo<InstallSupport>> i$ = this;
                    synchronized (i$) {
                        if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                            return false;
                        }
                    }
                    List filesInstallNow = InstallSupportImpl.this.getFileForInstall(customs, infos);
                    if (!filesInstallNow.isEmpty()) {
                        Thread th = UpdaterFrame.startFromIDE(filesInstallNow.toArray(new File[0]), refreshModulesListener, NbBundle.getBranding());
                        try {
                            th.join();
                            int rerunWaitCount = 0;
                            for (OperationContainer.OperationInfo<InstallSupport> info : infos) {
                                Module module = Utils.toModule(info.getUpdateElement().getCodeName(), null);
                                while (!(rerunWaitCount >= 100 || module != null && module.isEnabled())) {
                                    Thread.currentThread();
                                    Thread.sleep(100L);
                                    module = Utils.toModule(info.getUpdateElement().getCodeName(), null);
                                    ++rerunWaitCount;
                                }
                            }
                        }
                        catch (InterruptedException ie) {
                            th.interrupt();
                        }
                    }
                } else {
                    for (OperationContainer.OperationInfo<InstallSupport> info : infos) {
                        Trampoline.API.impl(InstallSupportImpl.this.support.getContainer()).addScheduledForReboot(info.getUpdateElement());
                    }
                }
                try {
                    for (OperationContainer.OperationInfo<InstallSupport> info : infos) {
                        UpdateUnit u = info.getUpdateUnit();
                        UpdateElement el = info.getUpdateElement();
                        Trampoline.API.impl(u).updateInstalled(el);
                    }
                }
                finally {
                    if (progress != null) {
                        progress.progress("");
                        progress.finish();
                    }
                }
                return needsRestart ? Boolean.TRUE : Boolean.FALSE;
            }
        };
        boolean retval = false;
        try {
            retval = this.es.submit(installCallable).get();
        }
        catch (InterruptedException iex) {
            Exceptions.printStackTrace((Throwable)iex);
        }
        catch (ExecutionException iex) {
            Exceptions.printStackTrace((Throwable)iex);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRestart(InstallSupport.Restarter validator, ProgressHandle progress) throws OperationException {
        InstallSupportImpl installSupportImpl = this;
        synchronized (installSupportImpl) {
            assert (this.currentStep != STEP.FINISHED);
            if (this.currentStep == STEP.CANCEL) {
                return;
            }
            this.currentStep = STEP.RESTART;
        }
        Utilities.deleteInstall_Later();
        LifecycleManager.getDefault().exit();
    }

    public void doRestartLater(InstallSupport.Restarter restarter) {
        List<OperationContainer.OperationInfo<InstallSupport>> ois = this.support.getContainer().listAll();
        ArrayList<UpdateElement> elems = new ArrayList<UpdateElement>();
        for (OperationContainer.OperationInfo<InstallSupport> operationInfo : ois) {
            elems.add(operationInfo.getUpdateElement());
        }
        Utilities.writeInstall_Later(new HashMap<UpdateElementImpl, File>(this.element2Clusters));
    }

    public String getCertificate(InstallSupport.Installer validator, UpdateElement uElement) {
        Collection<Certificate> certificates = this.certs.get(uElement);
        if (certificates != null) {
            String res = "";
            for (Certificate c : certificates) {
                res = res + c;
            }
            return res;
        }
        return null;
    }

    public boolean isTrusted(InstallSupport.Installer validator, UpdateElement uElement) {
        return this.trusted.contains(uElement);
    }

    public boolean isSigned(InstallSupport.Installer validator, UpdateElement uElement) {
        return this.signed.contains(uElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCancel() throws OperationException {
        InstallSupportImpl installSupportImpl = this;
        synchronized (installSupportImpl) {
            this.currentStep = STEP.CANCEL;
        }
        List empty = Collections.emptyList();
        for (File f : this.getFileForInstall(empty, this.support.getContainer().listAll())) {
            if (f == null || !f.exists()) continue;
            f.delete();
        }
    }

    private int doDownload(OperationContainer.OperationInfo info, ProgressHandle progress, int aggregateDownload, int totalSize) throws OperationException {
        UpdateElement installed = info.getUpdateUnit().getInstalled();
        UpdateElementImpl toUpdateImpl = Trampoline.API.impl(info.getUpdateElement());
        File targetCluster = this.getTargetCluster(installed, toUpdateImpl);
        URL source = toUpdateImpl.getInstallInfo().getDistribution();
        err.log(Level.FINE, "Source URL for " + toUpdateImpl.getCodeName() + " is " + source);
        boolean isNbmFile = source.getFile().toLowerCase(Locale.US).endsWith(NBM_EXTENTSION.toLowerCase(Locale.US));
        File dest = InstallSupportImpl.getDestination(targetCluster, toUpdateImpl.getCodeName(), isNbmFile);
        dest.delete();
        int c = 0;
        try {
            String label = toUpdateImpl.getDisplayName();
            c = this.copy(source, dest, progress, toUpdateImpl.getDownloadSize(), aggregateDownload, totalSize, label);
        }
        catch (IOException x) {
            err.log(Level.INFO, x.getMessage(), x);
            throw new OperationException(OperationException.ERROR_TYPE.PROXY, source.toString());
        }
        return c;
    }

    private String doValidate(OperationContainer.OperationInfo info, ProgressHandle progress, int verified) throws OperationException {
        UpdateElement installed = info.getUpdateUnit().getInstalled();
        UpdateElementImpl toUpdateImpl = Trampoline.API.impl(info.getUpdateElement());
        String status = null;
        File targetCluster = this.getTargetCluster(installed, toUpdateImpl);
        File dest = InstallSupportImpl.getDestination(targetCluster, toUpdateImpl.getCodeName());
        assert (dest.exists()) : dest.getAbsolutePath();
        boolean c = false;
        try {
            String label = toUpdateImpl.getDisplayName();
            this.verifyNbm(info.getUpdateElement(), dest, progress, verified, label);
        }
        catch (Exception x) {
            err.log(Level.INFO, x.getMessage(), x);
        }
        return status;
    }

    static File getDestination(File targetCluster, String codeName, boolean isNbmFile) {
        err.log(Level.FINE, "Target cluster for " + codeName + " is " + targetCluster);
        File destDir = new File(targetCluster, DOWNLOAD_DIR);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        String fileName = codeName.replace('.', '-');
        File destFile = new File(destDir, fileName + (isNbmFile ? NBM_EXTENTSION : ""));
        err.log(Level.FINE, "Destination file for " + codeName + " is " + destFile);
        return destFile;
    }

    private static File getDestination(File targetCluster, String codeName) {
        return InstallSupportImpl.getDestination(targetCluster, codeName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copy(URL source, File dest, ProgressHandle progress, int estimatedSize, int aggregateDownload, int totalSize, String label) throws MalformedURLException, IOException {
        int increment = 0;
        BufferedInputStream bsrc = new BufferedInputStream(source.openStream());
        BufferedOutputStream bdest = new BufferedOutputStream(new FileOutputStream(dest));
        err.log(Level.FINEST, "Copy " + source + " to " + dest + "[" + estimatedSize + "]");
        try {
            int size;
            byte[] bytes = new byte[1024];
            int c = 0;
            while ((size = bsrc.read(bytes)) != -1) {
                bdest.write(bytes, 0, size);
                increment += size;
                c += size;
                if (!this.progressRunning && progress != null) {
                    progress.switchToDeterminate(totalSize);
                    this.progressRunning = true;
                }
                if (c <= 1024) continue;
                if (progress != null) {
                    assert (this.progressRunning);
                    progress.switchToDeterminate(totalSize);
                    int i = aggregateDownload + (increment < estimatedSize ? increment : estimatedSize);
                    progress.progress(label, i < totalSize ? i : totalSize);
                }
                c = 0;
            }
            if (estimatedSize != increment) {
                err.log(Level.FINEST, "Increment (" + increment + ") of is not equal to estimatedSize (" + estimatedSize + ").");
            }
        }
        catch (IOException ioe) {
            err.log(Level.INFO, "Writing content of URL " + source + " failed.", ioe);
        }
        finally {
            try {
                if (bsrc != null) {
                    bsrc.close();
                }
                if (bdest != null) {
                    bdest.flush();
                }
                if (bdest != null) {
                    bdest.close();
                }
            }
            catch (IOException ioe) {
                err.log(Level.INFO, ioe.getMessage(), ioe);
            }
        }
        err.log(Level.FINE, "Destination " + dest + " is successfully wrote. Size " + dest.length());
        return estimatedSize;
    }

    private void verifyNbm(UpdateElement el, File nbmFile, ProgressHandle progress, int verified, String label) {
        String res = null;
        try {
            Collection<Certificate> nbmCerts = InstallSupportImpl.getNbmCertificates(nbmFile, progress, verified, label);
            assert (nbmCerts != null);
            if (nbmCerts.size() > 0) {
                this.certs.put(el, nbmCerts);
            }
            if (nbmCerts.isEmpty()) {
                res = "UNSIGNED";
            } else {
                ArrayList<Certificate> trustedCerts = new ArrayList<Certificate>();
                for (KeyStore ks : Utilities.getKeyStore()) {
                    trustedCerts.addAll(InstallSupportImpl.getCertificates(ks));
                }
                if (trustedCerts.containsAll(nbmCerts)) {
                    res = "TRUSTED";
                    this.trusted.add(el);
                    this.signed.add(el);
                } else {
                    res = "UNTRUSTED";
                    this.signed.add(el);
                }
            }
        }
        catch (IOException ioe) {
            err.log(Level.INFO, ioe.getMessage(), ioe);
            res = "BAD_DOWNLOAD";
        }
        catch (KeyStoreException kse) {
            err.log(Level.INFO, kse.getMessage(), kse);
            res = "CORRUPTED";
        }
        err.log(Level.FINE, "NBM " + nbmFile + " was verified as " + res);
    }

    private static Collection<Certificate> getCertificates(KeyStore keyStore) throws KeyStoreException {
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        for (String alias : Collections.list(keyStore.aliases())) {
            certs.add(keyStore.getCertificate(alias));
        }
        return certs;
    }

    private static Collection<Certificate> getNbmCertificates(File nbmFile, ProgressHandle progress, int verified, String label) throws IOException {
        JarFile jf = new JarFile(nbmFile);
        HashSet<Certificate> certs = new HashSet<Certificate>();
        for (JarEntry entry : Collections.list(jf.entries())) {
            InstallSupportImpl.verifyEntry(jf, entry, progress, verified, label);
            if (entry.getCertificates() == null) continue;
            certs.addAll(Arrays.asList(entry.getCertificates()));
        }
        return certs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int verifyEntry(JarFile jf, JarEntry je, ProgressHandle progress, int verified, String label) throws IOException {
        InputStream is = null;
        try {
            int n;
            is = jf.getInputStream(je);
            byte[] buffer = new byte[8192];
            int c = 0;
            while ((n = is.read(buffer, 0, buffer.length)) != -1) {
                if ((c += n) <= 1024) continue;
                verified += c;
                if (progress == null) continue;
                progress.progress(label);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return verified;
    }

    private boolean needsRestart(boolean isUpdate, UpdateElementImpl toUpdateImpl, File dest) {
        return InstallManager.needsRestart(isUpdate, toUpdateImpl, dest);
    }

    private List<File> getFileForInstall(List<? extends OperationContainer.OperationInfo> customs, List<? extends OperationContainer.OperationInfo> infos) {
        assert (customs != null);
        ArrayList<File> res = new ArrayList<File>();
        for (OperationContainer.OperationInfo operationInfo : infos) {
            if (customs.contains(operationInfo)) {
                err.log(Level.FINE, "UpdateElement " + operationInfo.getUpdateElement().getCodeName() + " won't be installed by AU. It has own installer.");
                break;
            }
            UpdateElementImpl toUpdateImpl = Trampoline.API.impl(operationInfo.getUpdateElement());
            OperationContainer<InstallSupport> c = this.support.getContainer();
            UpdateElement installed = operationInfo.getUpdateUnit().getInstalled();
            File targetCluster = this.getTargetCluster(installed, toUpdateImpl);
            URL source = toUpdateImpl.getInstallInfo().getDistribution();
            err.log(Level.FINE, "Source URL for " + toUpdateImpl.getCodeName() + " is " + source);
            File dest = InstallSupportImpl.getDestination(targetCluster, toUpdateImpl.getCodeName());
            res.add(dest);
        }
        return res;
    }

    private File getTargetCluster(UpdateElement installed, UpdateElementImpl update) {
        File cluster = this.element2Clusters.get(update);
        if (cluster == null && (cluster = InstallManager.findTargetDirectory(installed, update)) != null) {
            this.element2Clusters.put(update, cluster);
        }
        return cluster;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum STEP {
        NOTSTARTED,
        DOWNLOAD,
        VALIDATION,
        INSTALLATION,
        RESTART,
        FINISHED,
        CANCEL;

    }
}

