/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.services.OperationValidator;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Utils;
import org.openide.modules.ModuleInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperationContainerImpl<Support> {
    private OperationContainer<Support> container;
    private List<OperationContainer.OperationInfo<Support>> operations = new ArrayList<OperationContainer.OperationInfo<Support>>();
    private List<UpdateElement> scheduledForReboot = new ArrayList<UpdateElement>();
    private OperationType type;

    private OperationContainerImpl() {
    }

    public static OperationContainerImpl<InstallSupport> createForInstall() {
        return new OperationContainerImpl<InstallSupport>(OperationType.INSTALL);
    }

    public static OperationContainerImpl<InstallSupport> createForUpdate() {
        return new OperationContainerImpl<InstallSupport>(OperationType.UPDATE);
    }

    public static OperationContainerImpl<OperationSupport> createForDirectInstall() {
        return new OperationContainerImpl<OperationSupport>(OperationType.INSTALL);
    }

    public static OperationContainerImpl<OperationSupport> createForDirectUpdate() {
        return new OperationContainerImpl<OperationSupport>(OperationType.UPDATE);
    }

    public static OperationContainerImpl<OperationSupport> createForUninstall() {
        return new OperationContainerImpl<OperationSupport>(OperationType.UNINSTALL);
    }

    public static OperationContainerImpl<OperationSupport> createForEnable() {
        return new OperationContainerImpl<OperationSupport>(OperationType.ENABLE);
    }

    public static OperationContainerImpl<OperationSupport> createForDisable() {
        return new OperationContainerImpl<OperationSupport>(OperationType.DISABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationContainer.OperationInfo<Support> add(UpdateUnit updateUnit, UpdateElement updateElement) throws IllegalArgumentException {
        OperationContainer.OperationInfo retval = null;
        boolean isValid = this.isValid(updateUnit, updateElement);
        if (!isValid) {
            throw new IllegalArgumentException(updateElement.getCodeName());
        }
        if ((this.type == OperationType.INSTALL || this.type == OperationType.UPDATE) && this.scheduledForReboot.contains(updateElement)) {
            return null;
        }
        if (isValid) {
            if (this.type == OperationType.UNINSTALL || this.type == OperationType.ENABLE || this.type == OperationType.DISABLE) {
                boolean bl = isValid = updateUnit.getInstalled() == updateElement;
                if (!isValid) {
                    throw new IllegalArgumentException(updateElement.getCodeName());
                }
            } else {
                boolean bl = isValid = updateUnit.getInstalled() != updateElement;
                if (!isValid) {
                    throw new IllegalArgumentException(updateElement.getCodeName());
                }
            }
        }
        OperationContainerImpl operationContainerImpl = this;
        synchronized (operationContainerImpl) {
            if (!this.contains(updateUnit, updateElement)) {
                retval = Trampoline.API.createOperationInfo(new OperationInfoImpl(updateUnit, updateElement));
                this.operations.add(retval);
            }
        }
        return retval;
    }

    public boolean remove(UpdateElement updateElement) {
        OperationContainer.OperationInfo<Support> toRemove = this.find(updateElement);
        if (toRemove != null) {
            this.remove(toRemove);
        }
        return toRemove != null;
    }

    public void addScheduledForReboot(UpdateElement el) {
        this.scheduledForReboot.add(el);
    }

    public boolean contains(UpdateElement updateElement) {
        return this.find(updateElement) != null;
    }

    public void setOperationContainer(OperationContainer<Support> container) {
        this.container = container;
    }

    private OperationContainer.OperationInfo<Support> find(UpdateElement updateElement) {
        OperationContainer.OperationInfo<Support> toRemove = null;
        for (OperationContainer.OperationInfo<Support> info : this.listAll()) {
            if (!info.getUpdateElement().equals(updateElement)) continue;
            toRemove = info;
            break;
        }
        return toRemove;
    }

    private boolean contains(UpdateUnit unit, UpdateElement element) {
        List<OperationContainer.OperationInfo<Support>> infos = this.listAll();
        for (OperationContainer.OperationInfo<Support> info : infos) {
            if (!info.getUpdateElement().equals(element) && !info.getUpdateUnit().equals(unit)) continue;
            return true;
        }
        return false;
    }

    public List<OperationContainer.OperationInfo<Support>> listAll() {
        return new ArrayList<OperationContainer.OperationInfo<Support>>(this.operations);
    }

    public List<OperationContainer.OperationInfo<Support>> listInvalid() {
        ArrayList<OperationContainer.OperationInfo<Support>> retval = new ArrayList<OperationContainer.OperationInfo<Support>>();
        List<OperationContainer.OperationInfo<Support>> infos = this.listAll();
        for (OperationContainer.OperationInfo<Support> oii : infos) {
            if (this.isValid(oii.getUpdateUnit(), oii.getUpdateElement())) continue;
            retval.add(oii);
        }
        return retval;
    }

    public boolean isValid(UpdateUnit updateUnit, UpdateElement updateElement) {
        if (updateElement == null) {
            throw new IllegalArgumentException("UpdateElement cannot be null.");
        }
        if (updateUnit == null) {
            throw new IllegalArgumentException("UpdateUnit cannot be null.");
        }
        boolean isValid = false;
        switch (this.type) {
            case INSTALL: {
                isValid = OperationValidator.isValidOperation(this.type, updateUnit, updateElement);
                if (isValid || this.operations.size() <= 0) break;
                isValid = OperationValidator.isValidOperation(OperationType.UPDATE, updateUnit, updateElement);
                break;
            }
            case UPDATE: {
                isValid = OperationValidator.isValidOperation(this.type, updateUnit, updateElement);
                if (isValid || this.operations.size() <= 0) break;
                isValid = OperationValidator.isValidOperation(OperationType.INSTALL, updateUnit, updateElement);
                break;
            }
            default: {
                isValid = OperationValidator.isValidOperation(this.type, updateUnit, updateElement);
            }
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(OperationContainer.OperationInfo op) {
        OperationContainerImpl operationContainerImpl = this;
        synchronized (operationContainerImpl) {
            this.operations.remove(op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeAll() {
        OperationContainerImpl operationContainerImpl = this;
        synchronized (operationContainerImpl) {
            this.operations.clear();
        }
    }

    private OperationContainerImpl(OperationType type) {
        this.type = type;
    }

    public OperationType getType() {
        return this.type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OperationInfoImpl<Support> {
        private final UpdateElement updateElement;
        private final UpdateUnit uUnit;

        private OperationInfoImpl(UpdateUnit uUnit, UpdateElement updateElement) {
            this.updateElement = updateElement;
            this.uUnit = uUnit;
        }

        public UpdateElement getUpdateElement() {
            return this.updateElement;
        }

        public UpdateUnit getUpdateUnit() {
            return this.uUnit;
        }

        public List<UpdateElement> getRequiredElements() {
            ArrayList<ModuleInfo> moduleInfos = new ArrayList<ModuleInfo>();
            for (OperationContainer.OperationInfo oii : OperationContainerImpl.this.listAll()) {
                UpdateElementImpl impl = Trampoline.API.impl(oii.getUpdateElement());
                ModuleInfo info = impl.getModuleInfo();
                assert (info != null) : "ModuleInfo for UpdateElement " + oii.getUpdateElement() + " found.";
                moduleInfos.add(info);
            }
            return OperationValidator.getRequiredElements(OperationContainerImpl.this.type, this.getUpdateElement(), moduleInfos);
        }

        public Set<String> getBrokenDependencies() {
            ArrayList<ModuleInfo> moduleInfos = new ArrayList<ModuleInfo>();
            for (OperationContainer.OperationInfo oii : OperationContainerImpl.this.listAll()) {
                UpdateElementImpl impl = Trampoline.API.impl(oii.getUpdateElement());
                ModuleInfo info = impl.getModuleInfo();
                assert (info != null) : "ModuleInfo for UpdateElement " + oii.getUpdateElement() + " found.";
                moduleInfos.add(info);
            }
            return Utils.getBrokenDependencies(this.getUpdateElement(), moduleInfos);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperationType {
        INSTALL,
        UNINSTALL,
        UPDATE,
        REVERT,
        ENABLE,
        DISABLE;

    }
}

