/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import org.netbeans.modules.autoupdate.services.FeatureItem;
import org.netbeans.modules.autoupdate.services.InstallInfo;
import org.netbeans.modules.autoupdate.services.LocalizationItem;
import org.netbeans.modules.autoupdate.services.ModuleItem;
import org.netbeans.modules.autoupdate.services.NativeComponentItem;
import org.netbeans.modules.autoupdate.services.UpdateItemImpl;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.Union2;

public class UpdateElementImpl {
    private String codeName;
    private String displayName;
    private SpecificationVersion specVersion;
    private String description;
    private String source;
    private String author;
    private String homepage;
    private int downloadSize;
    private String category;
    private InstallInfo installInfo;
    private final Union2<? extends UpdateItemImpl, ModuleInfo> itemOrInfo;
    private Boolean isModule;
    private String providerName;

    public UpdateElementImpl(ModuleInfo info) {
        this.providerName = NbBundle.getMessage(UpdateElementImpl.class, (String)"UpdateElementImpl_ProviderName_ForModuleInfo");
        this.codeName = info.getCodeNameBase();
        this.displayName = info.getDisplayName();
        this.specVersion = info.getSpecificationVersion();
        this.description = (String)info.getLocalizedAttribute("OpenIDE-Module-Long-Description");
        this.source = "NetBeans 6.0";
        this.category = (String)info.getLocalizedAttribute("OpenIDE-Module-Display-Category");
        this.isModule = true;
        this.itemOrInfo = Union2.createSecond((Object)info);
    }

    public UpdateElementImpl(ModuleItem impl, String providerName) {
        this.providerName = providerName;
        this.codeName = impl.getCodeName();
        this.specVersion = new SpecificationVersion(impl.getSpecificationVersion());
        this.source = providerName;
        this.installInfo = new InstallInfo(impl);
        this.displayName = impl.getManifest().getMainAttributes().getValue("OpenIDE-Module-Name");
        this.description = impl.getManifest().getMainAttributes().getValue("OpenIDE-Module-Long-Description");
        this.category = impl.getManifest().getMainAttributes().getValue("OpenIDE-Module-Display-Category");
        this.author = impl.getAuthor();
        this.downloadSize = impl.getDownloadSize();
        this.homepage = impl.getHomepage();
        this.isModule = true;
        this.itemOrInfo = Union2.createFirst((Object)impl);
    }

    public UpdateElementImpl(LocalizationItem impl, String providerName) {
        this.providerName = providerName;
        this.codeName = impl.getCodeName();
        this.specVersion = new SpecificationVersion(impl.getSpecificationVersion());
        this.source = "NetBeans 6.0";
        this.installInfo = new InstallInfo(impl);
        this.displayName = impl.getLocalizedModuleName();
        this.description = impl.getLocalizedModuleDescription();
        this.itemOrInfo = Union2.createFirst((Object)impl);
    }

    public UpdateElementImpl(FeatureItem impl, String providerName) {
        this.providerName = providerName;
        this.codeName = impl.getCodeName();
        this.specVersion = new SpecificationVersion(impl.getSpecificationVersion());
        this.source = "NetBeans 6.0";
        this.installInfo = new InstallInfo(impl);
        this.displayName = impl.getDisplayName();
        this.description = impl.getDescription();
        this.isModule = false;
        this.itemOrInfo = Union2.createFirst((Object)impl);
    }

    public UpdateElementImpl(NativeComponentItem impl, String providerName) {
        this.providerName = providerName;
        this.codeName = impl.getCodeName();
        this.specVersion = new SpecificationVersion(impl.getSpecificationVersion());
        this.source = "NetBeans 6.0";
        this.installInfo = new InstallInfo(impl);
        this.displayName = impl.getDisplayName();
        this.description = impl.getDescription();
        this.isModule = false;
        this.itemOrInfo = Union2.createFirst((Object)impl);
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public SpecificationVersion getSpecificationVersion() {
        return this.specVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public int getDownloadSize() {
        return this.downloadSize;
    }

    public String getSource() {
        return this.source;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getCategory() {
        return this.category;
    }

    public InstallInfo getInstallInfo() {
        return this.installInfo;
    }

    public UpdateItemImpl getUpdateItemImpl() {
        return this.itemOrInfo.hasFirst() ? (UpdateItemImpl)this.itemOrInfo.first() : null;
    }

    public ModuleInfo getModuleInfo() {
        if (this.itemOrInfo.hasFirst()) {
            UpdateItemImpl uImpl = (UpdateItemImpl)this.itemOrInfo.first();
            if (uImpl instanceof ModuleItem) {
                return ((ModuleItem)uImpl).getModuleInfo();
            }
        } else if (this.itemOrInfo.hasSecond()) {
            return (ModuleInfo)this.itemOrInfo.second();
        }
        return null;
    }

    public boolean isModule() {
        assert (this.isModule != null);
        return this.isModule;
    }

    public boolean isEnabled() {
        ModuleInfo mInfo = this.getModuleInfo();
        return mInfo != null ? mInfo.isEnabled() : false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateElementImpl other = (UpdateElementImpl)obj;
        if (!(this.specVersion == other.specVersion || this.specVersion != null && this.specVersion.equals((Object)other.specVersion))) {
            return false;
        }
        return this.codeName == other.codeName || this.codeName != null && this.codeName.equals(other.codeName);
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + (this.codeName != null ? this.codeName.hashCode() : 0);
        hash = 61 * hash + (this.specVersion != null ? this.specVersion.hashCode() : 0);
        return hash;
    }
}

