/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.modules.autoupdate.services.FeatureItem;
import org.netbeans.modules.autoupdate.services.LocalizationItem;
import org.netbeans.modules.autoupdate.services.ModuleItem;
import org.netbeans.modules.autoupdate.services.ModuleProvider;
import org.netbeans.modules.autoupdate.services.NativeComponentItem;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateItemImpl;
import org.netbeans.modules.autoupdate.services.UpdateUnitImpl;
import org.netbeans.modules.autoupdate.services.UpdateUnitProviderImpl;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.netbeans.spi.autoupdate.UpdateProvider;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateUnitFactory {
    private static final UpdateUnitFactory INSTANCE = new UpdateUnitFactory();
    private final Logger log = Logger.getLogger(this.getClass().getName());

    private UpdateUnitFactory() {
    }

    public static UpdateUnitFactory getDefault() {
        return INSTANCE;
    }

    public Map<String, UpdateUnit> getUpdateUnits() {
        List<UpdateUnitProvider> updates = UpdateUnitProviderImpl.getUpdateUnitProviders(true);
        Map<String, UpdateUnit> mappedImpl = this.appendInstalldeModules(new HashMap<String, UpdateUnit>());
        for (UpdateUnitProvider up : updates) {
            UpdateUnitProviderImpl impl = Trampoline.API.impl(up);
            mappedImpl = this.appendUpdateItems(mappedImpl, impl.getUpdateProvider());
        }
        return mappedImpl;
    }

    public Map<String, UpdateUnit> getUpdateUnits(UpdateProvider provider) {
        Collection<UpdateItem> items = null;
        try {
            items = provider.getUpdateItems().values();
        }
        catch (IOException iex) {
            Exceptions.printStackTrace((Throwable)iex);
            return new HashMap<String, UpdateUnit>();
        }
        Map<String, UpdateUnit> temp = this.appendUpdateItems(this.appendInstalldeModules(new HashMap<String, UpdateUnit>()), provider);
        HashMap<String, UpdateUnit> retval = new HashMap<String, UpdateUnit>();
        assert (items != null);
        for (UpdateItem updateItem : items) {
            UpdateUnit unit;
            String codename = null;
            UpdateItemImpl itemImpl = Trampoline.SPI.impl(updateItem);
            if (itemImpl instanceof ModuleItem) {
                codename = ((ModuleItem)itemImpl).getCodeName();
            } else if (itemImpl instanceof LocalizationItem) {
                codename = ((LocalizationItem)itemImpl).getCodeName();
            } else if (itemImpl instanceof FeatureItem) {
                codename = ((FeatureItem)itemImpl).getCodeName();
            } else if (itemImpl instanceof NativeComponentItem) {
                codename = ((NativeComponentItem)itemImpl).getCodeName();
            } else assert (false);
            if ((unit = temp.get(codename)) == null) continue;
            retval.put(codename, unit);
        }
        return retval;
    }

    Map<String, UpdateUnit> appendInstalldeModules(Map<String, UpdateUnit> originalUnits) {
        assert (originalUnits != null) : "Map of original UnitImpl cannot be null";
        Map<String, ModuleInfo> installed = ModuleProvider.getInstalledModules();
        assert (installed != null);
        for (String moduleId : installed.keySet()) {
            UpdateElement moduleEl = Trampoline.API.createUpdateElement(new UpdateElementImpl(installed.get(moduleId)));
            this.addElement(originalUnits, moduleEl, Type.INSTALLED);
        }
        return originalUnits;
    }

    Map<String, UpdateUnit> appendUpdateItems(Map<String, UpdateUnit> originalUnits, UpdateProvider provider) {
        Map<String, UpdateItem> items;
        assert (originalUnits != null) : "Map of original UnitImpl cannot be null";
        try {
            items = provider.getUpdateItems();
        }
        catch (IOException ioe) {
            this.log.log(Level.INFO, "Cannot read UpdateItem from UpdateProvider " + provider);
            return originalUnits;
        }
        assert (items != null) : "UpdatesProvider[" + provider.getName() + "] should return non-null items.";
        for (String simpleItemId : items.keySet()) {
            UpdateItemImpl itemImpl = Trampoline.SPI.impl(items.get(simpleItemId));
            UpdateElement updateEl = null;
            if (itemImpl instanceof ModuleItem) {
                updateEl = Trampoline.API.createUpdateElement(new UpdateElementImpl((ModuleItem)itemImpl, provider.getDisplayName()));
            } else if (itemImpl instanceof LocalizationItem) {
                updateEl = Trampoline.API.createUpdateElement(new UpdateElementImpl((LocalizationItem)itemImpl, provider.getDisplayName()));
            } else if (itemImpl instanceof FeatureItem) {
                updateEl = Trampoline.API.createUpdateElement(new UpdateElementImpl((FeatureItem)itemImpl, provider.getDisplayName()));
            } else if (itemImpl instanceof NativeComponentItem) {
                updateEl = Trampoline.API.createUpdateElement(new UpdateElementImpl((NativeComponentItem)itemImpl, provider.getDisplayName()));
            } else assert (false);
            this.addElement(originalUnits, updateEl, Type.UPDATE);
        }
        return originalUnits;
    }

    private void addElement(Map<String, UpdateUnit> impls, UpdateElement element, Type type) {
        UpdateUnitImpl impl;
        UpdateUnit unit = impls.get(element.getCodeName());
        UpdateElementImpl elImpl = Trampoline.API.impl(element);
        UpdateItemImpl itemImpl = elImpl.getUpdateItemImpl();
        if (itemImpl != null && itemImpl instanceof ModuleItem) {
            ModuleItem moduleItem = (ModuleItem)itemImpl;
            for (Dependency d : moduleItem.getModuleInfo().getDependencies()) {
                if (5 != d.getType() || !d.getName().startsWith("org.openide.modules.os")) continue;
                for (ModuleInfo info : ModuleProvider.getInstalledModules().values()) {
                    if (!Arrays.asList(info.getProvides()).contains(d.getName())) continue;
                    this.log.log(Level.FINEST, element + " which requires OS " + d + " succeed.");
                    break;
                }
                this.log.log(Level.FINE, element + " which requires OS " + d + " fails.");
                return;
            }
        }
        if (unit == null) {
            impl = new UpdateUnitImpl(element.getCodeName());
            unit = Trampoline.API.createUpdateUnit(impl);
            impls.put(unit.getCodeName(), unit);
        } else {
            impl = Trampoline.API.impl(unit);
        }
        switch (type) {
            case INSTALLED: {
                impl.setInstalled(element);
                break;
            }
            case UPDATE: {
                impl.addUpdate(element);
                break;
            }
            case BACKUP: {
                impl.setBackup(element);
                break;
            }
            default: {
                assert (false) : "Unkown type of UpdateElement: " + (Object)((Object)type);
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INSTALLED,
        BACKUP,
        UPDATE;

    }
}

