/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.UpdateElement;
import org.openide.modules.SpecificationVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateUnitImpl {
    private String codeName;
    private UpdateElement installed;
    private List<UpdateElement> updates;
    private UpdateElement installedLocalization;
    private List<UpdateElement> localizationUpdates;
    private UpdateElement backup;
    private Logger err = Logger.getLogger(this.getClass().getName());

    public UpdateUnitImpl(String codename) {
        this.codeName = codename;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public UpdateElement getInstalled() {
        return this.installed;
    }

    public List<UpdateElement> getAvailableUpdates() {
        return this.identifyUpdates(this.installed, this.updates);
    }

    public UpdateElement getInstalledLocalization() {
        return this.installedLocalization;
    }

    public List<UpdateElement> getAvailableLocalizations() {
        return this.identifyLocalizationUpdates(this.installedLocalization, this.localizationUpdates);
    }

    public UpdateElement getBackup() {
        return this.backup;
    }

    public void addUpdate(UpdateElement update) {
        int idx;
        if (this.updates == null) {
            this.updates = new ArrayList<UpdateElement>();
        }
        if ((idx = this.updates.indexOf(update)) != -1) {
            this.updates.remove(update);
        }
        this.updates.add(update);
    }

    public void setInstalled(UpdateElement installed) {
        assert (this.installed == null);
        assert (installed != null);
        this.installed = installed;
    }

    public void setAsUninstalled() {
        assert (this.installed != null);
        this.installed = null;
    }

    public void updateInstalled(UpdateElement installed) {
        this.installed = null;
        this.setInstalled(installed);
    }

    public void addLocalizationUpdate(UpdateElement update) {
        if (this.localizationUpdates == null) {
            this.localizationUpdates = new ArrayList<UpdateElement>();
        }
        assert (!this.localizationUpdates.contains(update));
        this.localizationUpdates.add(update);
    }

    public void setInstalledLocalization(UpdateElement installed) {
        assert (this.installedLocalization == null);
        this.installedLocalization = installed;
    }

    public void setBackup(UpdateElement backup) {
        assert (this.backup == null);
        this.backup = backup;
    }

    private List<UpdateElement> identifyUpdates(UpdateElement installed, List<UpdateElement> updates) {
        List<UpdateElement> res = null;
        if (updates != null && !updates.isEmpty()) {
            if (installed == null) {
                if (updates != null) {
                    res = updates;
                }
            } else {
                String moduleId = installed.getCodeName();
                ArrayList<UpdateElement> realUpdates = new ArrayList<UpdateElement>();
                for (UpdateElement update : updates) {
                    if (new SpecificationVersion(update.getSpecificationVersion()).compareTo((Object)new SpecificationVersion(installed.getSpecificationVersion())) <= 0) continue;
                    this.err.log(Level.FINE, "Module " + moduleId + "[" + installed.getSpecificationVersion() + "] has update " + moduleId + "[" + update.getSpecificationVersion() + "]");
                    realUpdates.add(update);
                }
                if (!realUpdates.isEmpty()) {
                    res = realUpdates;
                }
            }
        }
        if (res == null) {
            res = Collections.emptyList();
        }
        Collections.sort(res, new Comparator<UpdateElement>(){

            @Override
            public int compare(UpdateElement o1, UpdateElement o2) {
                return new SpecificationVersion(o2.getSpecificationVersion()).compareTo((Object)new SpecificationVersion(o1.getSpecificationVersion()));
            }
        });
        return res;
    }

    private List<UpdateElement> identifyLocalizationUpdates(UpdateElement installed, List<UpdateElement> updates) {
        ArrayList<UpdateElement> res = null;
        if (updates != null && !updates.isEmpty()) {
            if (installed == null) {
                return updates;
            }
            String moduleId = installed.getCodeName();
            ArrayList<UpdateElement> realUpdates = new ArrayList<UpdateElement>();
            for (UpdateElement update : updates) {
                if (update.getSpecificationVersion().compareTo(installed.getSpecificationVersion()) <= 0) continue;
                this.err.log(Level.FINE, "Module " + moduleId + "[" + installed.getSpecificationVersion() + "] has update " + moduleId + "[" + update.getSpecificationVersion() + "]");
                realUpdates.add(update);
            }
            if (!realUpdates.isEmpty()) {
                res = realUpdates;
            }
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateUnitImpl other = (UpdateUnitImpl)obj;
        if (!(this.codeName == other.codeName || this.codeName != null && this.codeName.equals(other.codeName))) {
            return false;
        }
        if (!(this.installed == other.installed || this.installed != null && this.installed.equals(other.installed))) {
            return false;
        }
        if (!(this.updates == other.updates || this.updates != null && ((Object)this.updates).equals(other.updates))) {
            return false;
        }
        if (!(this.installedLocalization == other.installedLocalization || this.installedLocalization != null && this.installedLocalization.equals(other.installedLocalization))) {
            return false;
        }
        if (!(this.localizationUpdates == other.localizationUpdates || this.localizationUpdates != null && ((Object)this.localizationUpdates).equals(other.localizationUpdates))) {
            return false;
        }
        return this.backup == other.backup || this.backup != null && this.backup.equals(other.backup);
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + (this.codeName != null ? this.codeName.hashCode() : 0);
        hash = 53 * hash + (this.installed != null ? this.installed.hashCode() : 0);
        hash = 53 * hash + (this.updates != null ? ((Object)this.updates).hashCode() : 0);
        hash = 53 * hash + (this.installedLocalization != null ? this.installedLocalization.hashCode() : 0);
        hash = 53 * hash + (this.localizationUpdates != null ? ((Object)this.localizationUpdates).hashCode() : 0);
        hash = 53 * hash + (this.backup != null ? this.backup.hashCode() : 0);
        return hash;
    }
}

