/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.modules.autoupdate.services.InstallSupportImpl;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.spi.autoupdate.KeyStoreProvider;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    private static Lookup.Result<KeyStoreProvider> result;
    private static final String ELEMENT_MODULES = "module_updates";
    private static final String ELEMENT_MODULE = "module";
    private static final String ATTR_CODENAMEBASE = "codenamebase";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SPEC_VERSION = "specification_version";
    private static final String ATTR_SIZE = "size";
    private static final String ATTR_NBM_NAME = "nbm_name";
    private static final String FILE_SEPARATOR;
    private static final String UPDATE_DIR = "update";
    private static final String DOWNLOAD_DIR;
    public static final String LATER_FILE_NAME = "install_later.xml";

    public static Collection<KeyStore> getKeyStore() {
        Collection c;
        if (result == null) {
            result = Lookup.getDefault().lookup(new Lookup.Template(KeyStoreProvider.class));
            result.addLookupListener((LookupListener)new KeyStoreProviderListener());
        }
        if ((c = result.allInstances()) == null || c.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<KeyStore> kss = new ArrayList<KeyStore>();
        for (KeyStoreProvider provider : c) {
            KeyStore ks = provider.getKeyStore();
            if (ks == null) continue;
            kss.add(ks);
        }
        return kss;
    }

    public static File getPlatformDir() {
        return new File(System.getProperty("netbeans.home"));
    }

    public static List<File> clusters(boolean includeUserDir) {
        String dirs;
        ArrayList<File> files = new ArrayList<File>();
        if (includeUserDir) {
            File ud = new File(System.getProperty("netbeans.user"));
            files.add(ud);
        }
        if ((dirs = System.getProperty("netbeans.dirs")) != null) {
            StringTokenizer en = new StringTokenizer(dirs, File.pathSeparator);
            while (en.hasMoreElements()) {
                File f = new File((String)en.nextElement());
                files.add(f);
            }
        }
        File id = Utilities.getPlatformDir();
        files.add(id);
        return Collections.unmodifiableList(files);
    }

    private static File getInstall_Later(File root) {
        File file = new File(root.getPath() + FILE_SEPARATOR + DOWNLOAD_DIR + FILE_SEPARATOR + LATER_FILE_NAME);
        return file;
    }

    public static void deleteInstall_Later() {
        List<File> clusters = Utilities.clusters(true);
        assert (clusters != null) : "Clusters cannot be empty.";
        Iterator<File> iter = clusters.iterator();
        while (iter.hasNext()) {
            File installLaterFile = Utilities.getInstall_Later(iter.next());
            if (installLaterFile == null || !installLaterFile.exists()) continue;
            installLaterFile.delete();
        }
    }

    public static void writeInstall_Later(Map<UpdateElementImpl, File> updates) {
        List<File> clusters = Utilities.clusters(true);
        assert (clusters != null) : "Clusters cannot be empty.";
        Iterator<File> iter = clusters.iterator();
        while (iter.hasNext()) {
            Utilities.writeToCluster(iter.next(), updates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToCluster(File cluster, Map<UpdateElementImpl, File> updates) {
        Document document = XMLUtil.createDocument((String)ELEMENT_MODULES, null, null, null);
        Element root = document.getDocumentElement();
        Element module = null;
        Iterator<UpdateElementImpl> it = updates.keySet().iterator();
        boolean empty = true;
        while (it.hasNext()) {
            UpdateElementImpl elementImpl = it.next();
            File c = updates.get(elementImpl);
            if (!cluster.equals(c)) continue;
            module = document.createElement(ELEMENT_MODULE);
            module.setAttribute(ATTR_CODENAMEBASE, elementImpl.getCodeName());
            module.setAttribute(ATTR_NAME, elementImpl.getDisplayName());
            module.setAttribute(ATTR_SPEC_VERSION, elementImpl.getSpecificationVersion().toString());
            module.setAttribute(ATTR_SIZE, Long.toString(elementImpl.getDownloadSize()));
            module.setAttribute(ATTR_NBM_NAME, InstallSupportImpl.getDestination(cluster, elementImpl.getCodeName(), true).getName());
            root.appendChild(module);
            empty = false;
        }
        if (empty) {
            return;
        }
        document.getDocumentElement().normalize();
        File installLaterFile = Utilities.getInstall_Later(cluster);
        installLaterFile.getParentFile().mkdirs();
        InputStream is = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStream fos = null;
        try {
            try {
                XMLUtil.write((Document)document, (OutputStream)bos, (String)"UTF-8");
                if (bos != null) {
                    bos.close();
                }
                fos = new FileOutputStream(installLaterFile);
                is = new ByteArrayInputStream(bos.toByteArray());
                FileUtil.copy((InputStream)is, (OutputStream)fos);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (fos != null) {
                    fos.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            Exceptions.printStackTrace((Throwable)fnfe);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception x) {
                    Exceptions.printStackTrace((Throwable)x);
                }
            }
        }
    }

    static {
        FILE_SEPARATOR = System.getProperty("file.separator");
        DOWNLOAD_DIR = UPDATE_DIR + FILE_SEPARATOR + "download";
    }

    private static class KeyStoreProviderListener
    implements LookupListener {
        private KeyStoreProviderListener() {
        }

        public void resultChanged(LookupEvent ev) {
            result = null;
        }
    }
}

