/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.core.startup.Main;
import org.netbeans.modules.autoupdate.services.DependencyChecker;
import org.netbeans.modules.autoupdate.services.FeatureItem;
import org.netbeans.modules.autoupdate.services.ModuleItem;
import org.netbeans.modules.autoupdate.services.ModuleProvider;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateManagerImpl;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String UPDATE_DIR = "update";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String DOWNLOAD_DIR = "update" + FILE_SEPARATOR + "download";
    public static final String NBM_EXTENTSION = ".nbm";
    private static ModuleManager mgr = null;
    private static Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.services.Utils");

    private Utils() {
    }

    public static void testInit() {
        mgr = Main.getModuleSystem().getManager();
        assert (mgr != null);
    }

    static Module toModule(UpdateUnit uUnit) {
        return Utils.getModuleInstance(uUnit.getCodeName(), null);
    }

    public static Module toModule(String codeNameBase, String specificationVersion) {
        return Utils.getModuleInstance(codeNameBase, specificationVersion);
    }

    static UpdateUnit toUpdateUnit(Module m) {
        return UpdateManagerImpl.getInstance().getUpdateUnit(m.getCodeNameBase());
    }

    static UpdateUnit toUpdateUnit(String codeNameBase) {
        return UpdateManagerImpl.getInstance().getUpdateUnit(codeNameBase);
    }

    private static Set<Dependency> takeDependencies(UpdateElement el) {
        UpdateElementImpl i = Trampoline.API.impl(el);
        assert (i.isModule()) : "Only for UpdateElement for modules.";
        return Utils.takeModuleInfo(el).getDependencies();
    }

    private static UpdateElement findRequiredModule(Dependency dep, List<ModuleInfo> installedModules) {
        switch (dep.getType()) {
            case 5: {
                ModuleInfo info = DependencyChecker.findModuleMatchesDependencyRequires(dep, installedModules);
                if (info != null) break;
                for (UpdateUnit unit : UpdateManagerImpl.getInstance().getUpdateUnits()) {
                    UpdateElement el;
                    UpdateElementImpl impl;
                    ModuleInfo moduleInfo;
                    Iterator<UpdateElement> i$;
                    assert (unit != null) : "UpdateUnit for " + info.getCodeName() + " found.";
                    if (unit.getAvailableUpdates().size() <= 0 || !(i$ = unit.getAvailableUpdates().iterator()).hasNext() || !Arrays.asList((moduleInfo = (impl = Trampoline.API.impl(el = i$.next())).getModuleInfo()).getProvides()).contains(dep.getName())) continue;
                    return el;
                }
                break;
            }
            case 1: {
                UpdateElement installedEl;
                UpdateElementImpl installedElImpl;
                ModuleInfo installedModuleInfo;
                String moduleName = dep.getName();
                UpdateUnit unit = UpdateManagerImpl.getInstance().getUpdateUnit(moduleName);
                if (unit == null) {
                    return null;
                }
                if (unit.getInstalled() != null && DependencyChecker.checkDependencyModule(dep, installedModuleInfo = (installedElImpl = Trampoline.API.impl(installedEl = unit.getInstalled())).getModuleInfo())) {
                    return null;
                }
                List<UpdateElement> elements = unit.getAvailableUpdates();
                for (UpdateElement el : elements) {
                    UpdateElementImpl impl = Trampoline.API.impl(el);
                    if (impl.isModule()) {
                        ModuleItem m = (ModuleItem)impl.getUpdateItemImpl();
                        if (!DependencyChecker.checkDependencyModule(dep, m.getModuleInfo())) continue;
                        return el;
                    }
                    FeatureItem i = (FeatureItem)impl.getUpdateItemImpl();
                    i.getDependenciesToModules();
                }
                break;
            }
            case 4: {
                err.log(Level.FINE, "Check dependency on IDE. Dependency: " + dep);
                break;
            }
            case 3: {
                err.log(Level.FINE, "Check dependency on Java platform. Dependency: " + dep);
                break;
            }
            default: {
                err.log(Level.INFO, "Uncovered Dependency " + dep);
            }
        }
        return null;
    }

    private static List<UpdateElement> findRequiredModules(Set<Dependency> deps, List<ModuleInfo> installedModules) {
        ArrayList<UpdateElement> requiredElements = new ArrayList<UpdateElement>();
        for (Dependency dep : deps) {
            UpdateElement el = Utils.findRequiredModule(dep, installedModules);
            if (el == null) continue;
            UpdateElementImpl elImpl = Trampoline.API.impl(el);
            ModuleInfo mInfo = elImpl.getModuleInfo();
            assert (mInfo != null);
            if (installedModules.contains(mInfo)) continue;
            requiredElements.add(el);
            installedModules.add(Utils.takeModuleInfo(el));
        }
        for (UpdateElement el : new HashSet(requiredElements)) {
            requiredElements.addAll(Utils.findRequiredModules(Utils.takeDependencies(el), installedModules));
        }
        return requiredElements;
    }

    private static List<ModuleInfo> getInstalledModules() {
        return new ArrayList<ModuleInfo>(ModuleProvider.getInstalledModules().values());
    }

    public static List<UpdateElement> findRequiredModules(UpdateElement element, List<ModuleInfo> infos) {
        UpdateElementImpl el = Trampoline.API.impl(element);
        List<UpdateElement> retval = new ArrayList<UpdateElement>();
        if (el.getUpdateItemImpl() instanceof ModuleItem) {
            ModuleItem moduleEl = (ModuleItem)el.getUpdateItemImpl();
            Set deps = moduleEl.getModuleInfo().getDependencies();
            List<ModuleInfo> extendedModules = Utils.getInstalledModules();
            extendedModules.addAll(infos);
            Set<Dependency> brokenDeps = DependencyChecker.findBrokenDependencies(deps, extendedModules);
            retval = Utils.findRequiredModules(brokenDeps, extendedModules);
        } else assert (false) : "Not implement for item " + el.getUpdateItemImpl().getClass();
        Collections.reverse(retval);
        return retval;
    }

    public static Set<Dependency> findBrokenDependencies(UpdateElement element, List<ModuleInfo> infos) {
        UpdateElementImpl el = Trampoline.API.impl(element);
        assert (el != null) : "UpdateElementImpl found for UpdateElement " + element;
        Set<Dependency> retval = Collections.emptySet();
        ModuleInfo info = null;
        if (el.getUpdateItemImpl() == null) {
            info = el.getModuleInfo();
        } else if (el.getUpdateItemImpl() instanceof ModuleItem) {
            info = el.getModuleInfo();
        } else assert (false) : "Not implement for item " + el.getUpdateItemImpl().getClass();
        Set deps = info.getDependencies();
        List<ModuleInfo> extendedModules = Utils.getInstalledModules();
        extendedModules.addAll(infos);
        Set<Dependency> brokenDeps = DependencyChecker.findBrokenDependencies(deps, extendedModules);
        List<UpdateElement> reqs = Utils.findRequiredModules(brokenDeps, extendedModules);
        extendedModules.addAll(Utils.getModuleInfos(reqs));
        retval = DependencyChecker.findBrokenDependencies(deps, extendedModules);
        return retval;
    }

    static Set<String> getBrokenDependencies(UpdateElement element, List<ModuleInfo> infos) {
        assert (element != null) : "UpdateElement cannot be null";
        HashSet<String> retval = new HashSet<String>();
        for (Dependency dep : Utils.findBrokenDependencies(element, infos)) {
            retval.add(dep.toString());
        }
        return retval;
    }

    static List<ModuleInfo> getModuleInfos(Collection<UpdateElement> elements) {
        ArrayList<ModuleInfo> infos = new ArrayList<ModuleInfo>(elements.size());
        for (UpdateElement el : elements) {
            UpdateElementImpl impl = Trampoline.API.impl(el);
            infos.add(impl.getModuleInfo());
        }
        return infos;
    }

    private static Module getModuleInstance(String codeNameBase, String specificationVersion) {
        if (mgr == null) {
            mgr = Main.getModuleSystem().getManager();
        }
        assert (mgr != null);
        if (mgr == null || specificationVersion == null) {
            return mgr != null ? mgr.get(codeNameBase) : null;
        }
        Module m = mgr.get(codeNameBase);
        if (m == null) {
            return null;
        }
        return m.getSpecificationVersion().compareTo((Object)new SpecificationVersion(specificationVersion)) >= 0 ? m : null;
    }

    public static boolean isAutomaticallyEnabled(String codeNameBase) {
        Module m = Utils.getModuleInstance(codeNameBase, null);
        return m != null ? m.isAutoload() || m.isEager() || m.isFixed() : false;
    }

    private static ModuleInfo takeModuleInfo(UpdateElement el) {
        UpdateElementImpl i = Trampoline.API.impl(el);
        assert (i.isModule()) : "Only for UpdateElement for modules.";
        if ((ModuleItem)i.getUpdateItemImpl() == null) {
            return i.getModuleInfo();
        }
        return ((ModuleItem)i.getUpdateItemImpl()).getModuleInfo();
    }
}

