/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.netbeans.spi.autoupdate.UpdateLicense;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleItem {
    protected Node declaratingNode;
    public static final String LICENSE = "license";

    public SimpleItem(Node node) {
        this.declaratingNode = node;
    }

    public abstract UpdateItem toUpdateItem(Map<String, String> var1);

    public abstract String getId();

    static String getAttribute(Node n, String attribute) {
        Node attr = n.getAttributes().getNamedItem(attribute);
        return attr == null ? null : attr.getNodeValue();
    }

    private static Set<String> readDependencies(String input) {
        HashSet<String> res = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(input.trim(), ",");
        while (tokenizer.hasMoreTokens()) {
            res.add(tokenizer.nextToken());
        }
        return res;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Feature
    extends SimpleItem {
        public static final String CODE_NAME_BASE = "name";
        public static final String SPECIFICATION_VERSION = "version";
        public static final String MODULE_DEPENDENCIES = "module-dependencies";
        public static final String DISPLAY_NAME = "displayname";
        public static final String DESCRIPTION = "description";
        private String codeName;
        private String version;

        public Feature(Node n) {
            super(n);
            this.codeName = Feature.getAttribute(this.declaratingNode, CODE_NAME_BASE);
            this.version = Feature.getAttribute(this.declaratingNode, SPECIFICATION_VERSION);
        }

        @Override
        public UpdateItem toUpdateItem(Map<String, String> licenses) {
            assert (this.declaratingNode != null) : "declaratingNode must be declared";
            String dependencies = Feature.getAttribute(this.declaratingNode, MODULE_DEPENDENCIES);
            UpdateItem res = UpdateItem.createFeature(Feature.getAttribute(this.declaratingNode, CODE_NAME_BASE), Feature.getAttribute(this.declaratingNode, SPECIFICATION_VERSION), SimpleItem.readDependencies(dependencies), Feature.getAttribute(this.declaratingNode, DESCRIPTION), Feature.getAttribute(this.declaratingNode, DISPLAY_NAME));
            this.declaratingNode = null;
            return res;
        }

        @Override
        public String getId() {
            return this.codeName + '_' + this.version;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class License
    extends SimpleItem {
        public static final String LICENSE_ID = "name";
        private String licenceId;
        private String licenseContent;

        public License(Node n) {
            super(n);
            assert (this.declaratingNode != null) : "declaratingNode must be declared";
            this.licenceId = License.getAttribute(this.declaratingNode, LICENSE_ID);
            NodeList innerList = this.declaratingNode.getChildNodes();
            assert (innerList != null && innerList.getLength() == 1) : "Lincese " + License.getAttribute(this.declaratingNode, "name") + " should contain only once data.";
            this.licenseContent = innerList.item(0).getNodeValue();
            this.declaratingNode = null;
        }

        public String getLicenseId() {
            assert (this.licenceId != null) : "licenceId cannot be null";
            return this.licenceId;
        }

        public String getLicenseContent() {
            assert (this.licenseContent != null) : "licenseContent for " + this.licenceId + " cannot be null";
            return this.licenseContent;
        }

        @Override
        public UpdateItem toUpdateItem(Map<String, String> licenses) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Localization
    extends SimpleItem {
        public static final String CODE_NAME_BASE = "codenamebase";
        public static final String DISTRIBUTION = "distribution";
        public static final String LICENSE = "license";
        public static final String DOWNLOAD_SIZE = "downloadsize";
        public static final String NEEDS_RESTART = "needsrestart";
        public static final String MODULE_AUTHOR = "moduleauthor";
        public static final String RELEASE_DATE = "releasedate";
        public static final String IS_GLOBAL = "global";
        public static final String TARGET_CLUSTER = "targetcluster";
        public static final String LOCALE = "langcode";
        public static final String BRANDING = "brandingcode";
        public static final String MODULE_SPECIFICATION = "module_spec_version";
        public static final String MODULE_MAJOR_VERSION = "module_major_version";
        public static final String LOCALIZED_MODULE_NAME = "OpenIDE-Module-Name";
        public static final String LOCALIZED_MODULE_DESCRIPTION = "OpenIDE-Module-Long-Description";
        private String specificationVersion;
        private String moduleCodeName;
        private String locale;
        private String branding;

        public Localization(Node n) {
            super(n);
        }

        @Override
        public UpdateItem toUpdateItem(Map<String, String> licenses) {
            URL distributionURL;
            String targetcluster;
            String global;
            String needsrestart;
            block5: {
                assert (this.declaratingNode != null) : "declaratingNode must be declared";
                this.moduleCodeName = Localization.getAttribute(this.declaratingNode, CODE_NAME_BASE);
                String distribution = Localization.getAttribute(this.declaratingNode, DISTRIBUTION);
                needsrestart = Localization.getAttribute(this.declaratingNode, NEEDS_RESTART);
                global = Localization.getAttribute(this.declaratingNode, IS_GLOBAL);
                targetcluster = Localization.getAttribute(this.declaratingNode, TARGET_CLUSTER);
                distributionURL = null;
                try {
                    distributionURL = new URL(distribution);
                }
                catch (MalformedURLException mue) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError((Object)mue);
                }
            }
            Boolean needsRestart = needsrestart == null || needsrestart.trim().length() == 0 ? null : Boolean.valueOf(needsrestart);
            Boolean isGlobal = global == null || global.trim().length() == 0 ? null : Boolean.valueOf(global);
            NodeList l = ((Element)this.declaratingNode).getElementsByTagName("l10n");
            assert (l != null && l.getLength() == 1) : "TAG_MANIFEST in module " + this.moduleCodeName + " should contains one and only one list, but was " + l.getLength();
            assert (1 == l.item(0).getNodeType());
            Node n = l.item(0);
            this.locale = Localization.getAttribute(n, LOCALE);
            this.branding = Localization.getAttribute(n, BRANDING);
            String localizationCodeName = this.moduleCodeName + '_' + this.locale + '_' + this.branding;
            this.specificationVersion = "1.0";
            String licName = Localization.getAttribute(this.declaratingNode, "license");
            String licContent = licenses.get(licName);
            UpdateLicense lic = UpdateLicense.createUpdateLicense(licName, licContent);
            UpdateItem res = UpdateItem.createLocalization(localizationCodeName, this.specificationVersion, Localization.getAttribute(this.declaratingNode, MODULE_SPECIFICATION), this.locale != null && this.locale.length() > 0 ? new Locale(this.locale) : null, this.branding != null && this.branding.length() > 0 ? this.branding : null, Localization.getAttribute(this.declaratingNode, LOCALIZED_MODULE_NAME), Localization.getAttribute(this.declaratingNode, LOCALIZED_MODULE_DESCRIPTION), distributionURL, needsRestart, isGlobal, targetcluster, lic);
            this.declaratingNode = null;
            return res;
        }

        @Override
        public String getId() {
            return this.moduleCodeName + '_' + this.specificationVersion + '_' + this.locale + '_' + this.branding;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Module
    extends SimpleItem {
        public static final String CODE_NAME_BASE = "codenamebase";
        public static final String HOMEPAGE = "homepage";
        public static final String DISTRIBUTION = "distribution";
        public static final String LICENSE = "license";
        public static final String DOWNLOAD_SIZE = "downloadsize";
        public static final String NEEDS_RESTART = "needsrestart";
        public static final String MODULE_AUTHOR = "moduleauthor";
        public static final String RELEASE_DATE = "releasedate";
        public static final String IS_GLOBAL = "global";
        public static final String TARGET_CLUSTER = "targetcluster";
        public static final String ATTR_SPECIFICATION_VERSION = "OpenIDE-Module-Specification-Version";
        private String moduleCodeName;
        private String specVersion;

        public Module(Node n) {
            super(n);
        }

        private static String getSpecificationVersion(Node n) {
            NodeList l = ((Element)n).getElementsByTagName("manifest");
            assert (l != null && l.getLength() == 1) : "TAG_MANIFEST should contains one and only one list.";
            assert (1 == l.item(0).getNodeType());
            String specVersion = null;
            NamedNodeMap attrList = l.item(0).getAttributes();
            Manifest mf = new Manifest();
            Attributes mfAttrs = mf.getMainAttributes();
            for (int i = 0; i < attrList.getLength(); ++i) {
                Attr attr = (Attr)attrList.item(i);
                mfAttrs.put(new Attributes.Name(attr.getName()), attr.getValue());
                if (!ATTR_SPECIFICATION_VERSION.equals(attr.getName())) continue;
                specVersion = attr.getValue();
            }
            return specVersion;
        }

        private static Manifest getManifest(Node n) {
            NodeList l = ((Element)n).getElementsByTagName("manifest");
            assert (l != null && l.getLength() == 1) : "TAG_MANIFEST should contains one and only one list.";
            assert (1 == l.item(0).getNodeType());
            NamedNodeMap attrList = l.item(0).getAttributes();
            Manifest mf = new Manifest();
            Attributes mfAttrs = mf.getMainAttributes();
            for (int i = 0; i < attrList.getLength(); ++i) {
                Attr attr = (Attr)attrList.item(i);
                mfAttrs.put(new Attributes.Name(attr.getName()), attr.getValue());
            }
            return mf;
        }

        private static String getModuleCodeName(Node n) {
            return Module.getAttribute(n, CODE_NAME_BASE);
        }

        @Override
        public UpdateItem toUpdateItem(Map<String, String> licenses) {
            URL distributionURL;
            String author;
            String downloadSize;
            String homepage;
            String targetcluster;
            String global;
            String needsrestart;
            block12: {
                String baseURI;
                assert (this.declaratingNode != null) : "declaratingNode must be declared";
                this.moduleCodeName = Module.getModuleCodeName(this.declaratingNode);
                String distribution = Module.getAttribute(this.declaratingNode, DISTRIBUTION);
                if ((this.declaratingNode.getBaseURI() != null || distribution == null || distribution.length() == 0) && (baseURI = this.declaratingNode.getBaseURI()) != null && baseURI.length() > 0) {
                    try {
                        URL uu = URI.create(baseURI).toURL();
                        if (uu != null && (uu = FileUtil.getArchiveFile((URL)uu)) != null && "file".equals(uu.getProtocol())) {
                            distribution = uu.toExternalForm();
                        }
                    }
                    catch (MalformedURLException mex) {
                        Exceptions.printStackTrace((Throwable)mex);
                    }
                }
                if (distribution != null && distribution.length() > 0) {
                    URI distributionURI = null;
                    URI baseURI2 = null;
                    try {
                        distributionURI = new URI(distribution);
                        baseURI2 = new URI(this.declaratingNode.getBaseURI());
                    }
                    catch (URISyntaxException urisy) {
                        Exceptions.printStackTrace((Throwable)urisy);
                    }
                    if (!distributionURI.isAbsolute()) {
                        distributionURI = baseURI2.resolve(distributionURI);
                        distribution = distributionURI.toString();
                    }
                }
                needsrestart = Module.getAttribute(this.declaratingNode, NEEDS_RESTART);
                global = Module.getAttribute(this.declaratingNode, IS_GLOBAL);
                targetcluster = Module.getAttribute(this.declaratingNode, TARGET_CLUSTER);
                homepage = Module.getAttribute(this.declaratingNode, HOMEPAGE);
                downloadSize = Module.getAttribute(this.declaratingNode, DOWNLOAD_SIZE);
                author = Module.getAttribute(this.declaratingNode, MODULE_AUTHOR);
                distributionURL = null;
                if (distribution != null && distribution.length() > 0) {
                    try {
                        distributionURL = new URL(distribution);
                    }
                    catch (MalformedURLException mue) {
                        if ($assertionsDisabled) break block12;
                        throw new AssertionError((Object)mue);
                    }
                }
            }
            Boolean needsRestart = needsrestart == null || needsrestart.trim().length() == 0 ? null : Boolean.valueOf(needsrestart);
            Boolean isGlobal = global == null || global.trim().length() == 0 ? null : Boolean.valueOf(global);
            this.specVersion = Module.getSpecificationVersion(this.declaratingNode);
            Manifest mf = Module.getManifest(this.declaratingNode);
            String licName = Module.getAttribute(this.declaratingNode, "license");
            String licContent = licenses.get(licName);
            UpdateLicense lic = UpdateLicense.createUpdateLicense(licName, licContent);
            UpdateItem res = UpdateItem.createModule(this.moduleCodeName, this.specVersion, distributionURL, author, downloadSize, homepage, mf, needsRestart, isGlobal, targetcluster, lic);
            this.declaratingNode = null;
            return res;
        }

        @Override
        public String getId() {
            return this.moduleCodeName + '_' + this.specVersion;
        }
    }
}

