/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ant;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private Util() {
    }

    public static Element findElement(Element parent, String name, String namespace) {
        Element result = null;
        NodeList l = parent.getChildNodes();
        int len = l.getLength();
        for (int i = 0; i < len; ++i) {
            Element el;
            if (l.item(i).getNodeType() != 1 || !name.equals((el = (Element)l.item(i)).getLocalName()) || !namespace.equals(el.getNamespaceURI())) continue;
            if (result == null) {
                result = el;
                continue;
            }
            return null;
        }
        return result;
    }

    public static String findText(Element parent) {
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 3) continue;
            Text text = (Text)l.item(i);
            return text.getNodeValue();
        }
        return null;
    }

    public static List<Element> findSubElements(Element parent) throws IllegalArgumentException {
        NodeList l = parent.getChildNodes();
        ArrayList<Element> elements = new ArrayList<Element>(l.getLength());
        for (int i = 0; i < l.getLength(); ++i) {
            Node n = l.item(i);
            if (n.getNodeType() == 1) {
                elements.add((Element)n);
                continue;
            }
            if (n.getNodeType() == 3) {
                String text = ((Text)n).getNodeValue();
                if (text.trim().length() <= 0) continue;
                throw new IllegalArgumentException("non-ws text encountered in " + parent + ": " + text);
            }
            if (n.getNodeType() == 8) continue;
            throw new IllegalArgumentException("unexpected non-element child of " + parent + ": " + n);
        }
        return elements;
    }

    public static ErrorHandler defaultErrorHandler() {
        return new ErrHandler();
    }

    private static final class ErrHandler
    implements ErrorHandler {
        private void annotate(SAXParseException exception) throws SAXException {
            Exceptions.attachMessage((Throwable)exception, (String)("Occurred at: " + exception.getSystemId() + ":" + exception.getLineNumber()));
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.annotate(exception);
            throw exception;
        }

        public void error(SAXParseException exception) throws SAXException {
            this.annotate(exception);
            throw exception;
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.annotate(exception);
            Logger.getLogger(Util.class.getName()).log(Level.INFO, null, exception);
        }
    }
}

