/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.ant.AntBasedProjectFactorySingleton;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProjectGenerator {
    private ProjectGenerator() {
    }

    public static AntProjectHelper createProject(FileObject directory, String type) throws IOException, IllegalArgumentException {
        return ProjectGenerator.createProject0(directory, type, null);
    }

    private static AntProjectHelper createProject0(final FileObject directory, final String type, final String name) throws IOException, IllegalArgumentException {
        try {
            return (AntProjectHelper)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<AntProjectHelper>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public AntProjectHelper run() throws IOException {
                    if (ProjectManager.getDefault().findProject(directory) != null) {
                        throw new IllegalArgumentException("Already a project in " + directory);
                    }
                    FileObject projectXml = directory.getFileObject("nbproject/project.xml");
                    if (projectXml != null) {
                        throw new IllegalArgumentException("Already a " + projectXml);
                    }
                    projectXml = FileUtil.createData((FileObject)directory, (String)"nbproject/project.xml");
                    Document doc = XMLUtil.createDocument((String)"project", (String)"http://www.netbeans.org/ns/project/1", null, null);
                    Element el = doc.createElementNS("http://www.netbeans.org/ns/project/1", "type");
                    el.appendChild(doc.createTextNode(type));
                    doc.getDocumentElement().appendChild(el);
                    if (name != null) {
                        el = doc.createElementNS("http://www.netbeans.org/ns/project/1", "name");
                        el.appendChild(doc.createTextNode(name));
                        doc.getDocumentElement().appendChild(el);
                    }
                    el = doc.createElementNS("http://www.netbeans.org/ns/project/1", "configuration");
                    doc.getDocumentElement().appendChild(el);
                    FileLock lock = projectXml.lock();
                    try {
                        OutputStream os = projectXml.getOutputStream(lock);
                        try {
                            XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
                        }
                        finally {
                            os.close();
                        }
                    }
                    finally {
                        lock.releaseLock();
                    }
                    ProjectManager.getDefault().clearNonProjectCache();
                    Project p = ProjectManager.getDefault().findProject(directory);
                    if (p == null) {
                        for (AntBasedProjectType abpt : Lookup.getDefault().lookupAll(AntBasedProjectType.class)) {
                            if (!abpt.getType().equals(type)) continue;
                            throw new IllegalArgumentException("For some reason the folder " + directory + " with a new project of type " + type + " is still not recognized");
                        }
                        throw new IllegalArgumentException("No Ant-based project factory for type " + type);
                    }
                    AntProjectHelper helper = AntBasedProjectFactorySingleton.getHelperFor(p);
                    if (helper == null) {
                        throw new IllegalArgumentException("Project " + p + " was not recognized as an Ant-based project");
                    }
                    helper.markModified();
                    return helper;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }
}

