/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.ant.FileChangeSupport;
import org.netbeans.modules.project.ant.FileChangeSupportEvent;
import org.netbeans.modules.project.ant.FileChangeSupportListener;
import org.netbeans.modules.project.ant.UserQuestionHandler;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.util.Utilities;

final class ProjectProperties {
    private final AntProjectHelper helper;
    private final Map<String, PP> properties = new HashMap<String, PP>();
    private PropertyProvider stockPropertyPreprovider = null;
    private PropertyEvaluator standardPropertyEvaluator = null;

    public ProjectProperties(AntProjectHelper helper) {
        this.helper = helper;
    }

    public void clear() {
        this.properties.clear();
    }

    public EditableProperties getProperties(String path) {
        EditableProperties ep = this.getPP(path).getEditablePropertiesOrNull();
        if (ep != null) {
            return ep.cloneProperties();
        }
        return new EditableProperties(true);
    }

    public boolean putProperties(String path, EditableProperties props) {
        return this.getPP(path).put(props);
    }

    public FileLock write(String path) throws IOException {
        assert (this.properties.containsKey(path));
        return this.getPP(path).write();
    }

    public PropertyProvider getPropertyProvider(String path) {
        return this.getPP(path);
    }

    private PP getPP(String path) {
        PP pp = this.properties.get(path);
        if (pp == null) {
            pp = new PP(path, this.helper);
            this.properties.put(path, pp);
        }
        return pp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyProvider getStockPropertyPreprovider() {
        if (this.stockPropertyPreprovider == null) {
            Map m;
            Properties p;
            Properties properties = p = System.getProperties();
            synchronized (properties) {
                m = NbCollections.checkedMapByCopy((Map)p, String.class, String.class, (boolean)false);
            }
            m.put("basedir", FileUtil.toFile((FileObject)this.helper.getProjectDirectory()).getAbsolutePath());
            File antJar = InstalledFileLocator.getDefault().locate("ant/lib/ant.jar", "org.apache.tools.ant.module", false);
            if (antJar != null) {
                File antHome = antJar.getParentFile().getParentFile();
                m.put("ant.home", antHome.getAbsolutePath());
            }
            this.stockPropertyPreprovider = PropertyUtils.fixedPropertyProvider(m);
        }
        return this.stockPropertyPreprovider;
    }

    public PropertyEvaluator getStandardPropertyEvaluator() {
        if (this.standardPropertyEvaluator == null) {
            PropertyEvaluator findUserPropertiesFile = PropertyUtils.sequentialPropertyEvaluator(this.getStockPropertyPreprovider(), this.getPropertyProvider("nbproject/private/private.properties"));
            PropertyProvider globalProperties = PropertyUtils.userPropertiesProvider(findUserPropertiesFile, "user.properties.file", FileUtil.toFile((FileObject)this.helper.getProjectDirectory()));
            this.standardPropertyEvaluator = PropertyUtils.sequentialPropertyEvaluator(this.getStockPropertyPreprovider(), this.getPropertyProvider("nbproject/private/private.properties"), globalProperties, this.getPropertyProvider("nbproject/project.properties"));
        }
        return this.standardPropertyEvaluator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PP
    implements PropertyProvider,
    FileChangeSupportListener {
        private static final RequestProcessor RP = new RequestProcessor("ProjectProperties.PP.RP");
        private final String path;
        private final AntProjectHelper helper;
        private EditableProperties properties = null;
        private boolean loaded = false;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private boolean writing = false;

        public PP(String path, AntProjectHelper helper) {
            this.path = path;
            this.helper = helper;
            FileChangeSupport.DEFAULT.addListener(this, new File(FileUtil.toFile((FileObject)this.dir()), path.replace('/', File.separatorChar)));
        }

        private FileObject dir() {
            return this.helper.getProjectDirectory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EditableProperties getEditablePropertiesOrNull() {
            if (!this.loaded) {
                this.properties = null;
                FileObject fo = this.dir().getFileObject(this.path);
                if (fo != null) {
                    try {
                        EditableProperties p;
                        InputStream is = fo.getInputStream();
                        try {
                            p = new EditableProperties(true);
                            p.load(is);
                        }
                        finally {
                            is.close();
                        }
                        this.properties = p;
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                }
                this.loaded = true;
            }
            return this.properties;
        }

        public boolean put(EditableProperties nue) {
            boolean modifying;
            this.loaded = true;
            boolean bl = modifying = !Utilities.compareObjects((Object)nue, (Object)this.properties);
            if (modifying) {
                this.properties = nue != null ? nue.cloneProperties() : null;
                this.fireChange();
            }
            return modifying;
        }

        public FileLock write() throws IOException {
            assert (this.loaded);
            final FileObject f = this.dir().getFileObject(this.path);
            assert (!this.writing);
            final FileLock[] _lock = new FileLock[1];
            this.writing = true;
            try {
                if (this.properties != null) {
                    this.dir().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() throws IOException {
                            FileObject _f;
                            if (f == null) {
                                _f = FileUtil.createData((FileObject)PP.this.dir(), (String)PP.this.path);
                                assert (_f != null) : "FU.cD must not return null; called on " + PP.access$000(PP.this) + " + " + PP.access$100(PP.this);
                            } else {
                                _f = f;
                            }
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            PP.this.properties.store(baos);
                            final byte[] data = baos.toByteArray();
                            try {
                                _lock[0] = _f.lock();
                                OutputStream os = _f.getOutputStream(_lock[0]);
                                try {
                                    os.write(data);
                                }
                                finally {
                                    os.close();
                                }
                            }
                            catch (UserQuestionException uqe) {
                                PP.this.helper.needPendingHook();
                                UserQuestionHandler.handle(uqe, new UserQuestionHandler.Callback(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void accepted() {
                                        assert (!PP.this.writing);
                                        PP.this.writing = true;
                                        try {
                                            FileLock lock = _f.lock();
                                            try {
                                                OutputStream os = _f.getOutputStream(lock);
                                                try {
                                                    os.write(data);
                                                }
                                                finally {
                                                    os.close();
                                                }
                                            }
                                            finally {
                                                lock.releaseLock();
                                            }
                                            PP.this.helper.maybeCallPendingHook();
                                        }
                                        catch (IOException e) {
                                            ErrorManager.getDefault().notify((Throwable)e);
                                            this.reload();
                                        }
                                        finally {
                                            PP.this.writing = false;
                                        }
                                    }

                                    public void denied() {
                                        this.reload();
                                    }

                                    public void error(IOException e) {
                                        ErrorManager.getDefault().notify((Throwable)e);
                                        this.reload();
                                    }

                                    private void reload() {
                                        PP.this.helper.cancelPendingHook();
                                        PP.this.diskChange();
                                    }
                                });
                            }
                        }
                    });
                } else if (f != null) {
                    f.delete();
                }
            }
            catch (IOException e) {
                if (_lock[0] != null) {
                    _lock[0].releaseLock();
                }
                throw e;
            }
            finally {
                this.writing = false;
            }
            return _lock[0];
        }

        @Override
        public Map<String, String> getProperties() {
            EditableProperties props = this.getEditablePropertiesOrNull();
            if (props != null) {
                return Collections.unmodifiableMap(props);
            }
            return Collections.emptyMap();
        }

        @Override
        public synchronized void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        @Override
        public synchronized void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        private void fireChange() {
            if (!this.cs.hasListeners()) {
                return;
            }
            Mutex.Action<Void> action = new Mutex.Action<Void>(){

                public Void run() {
                    PP.this.cs.fireChange();
                    return null;
                }
            };
            if (ProjectManager.mutex().isWriteAccess()) {
                ProjectManager.mutex().readAccess((Mutex.Action)action);
            } else if (ProjectManager.mutex().isReadAccess()) {
                action.run();
            } else {
                RP.post(new Runnable((Mutex.Action)action){
                    final /* synthetic */ Mutex.Action val$action;
                    {
                        this.val$action = action;
                    }

                    public void run() {
                        ProjectManager.mutex().readAccess(this.val$action);
                    }
                });
            }
        }

        private void diskChange() {
            if (!this.writing) {
                this.loaded = false;
            }
            this.fireChange();
            if (!this.writing) {
                this.helper.fireExternalChange(this.path);
            }
        }

        @Override
        public void fileCreated(FileChangeSupportEvent event) {
            this.diskChange();
        }

        @Override
        public void fileDeleted(FileChangeSupportEvent event) {
            this.diskChange();
        }

        @Override
        public void fileModified(FileChangeSupportEvent event) {
            this.diskChange();
        }
    }
}

