/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.queries.SharabilityQueryImplementation;
import org.openide.util.WeakListeners;

final class SharabilityQueryImpl
implements SharabilityQueryImplementation,
PropertyChangeListener {
    private final AntProjectHelper h;
    private final PropertyEvaluator eval;
    private final String[] includes;
    private final String[] excludes;
    private String[] includePaths;
    private String[] excludePaths;

    SharabilityQueryImpl(AntProjectHelper h, PropertyEvaluator eval, String[] includes, String[] excludes) {
        this.h = h;
        this.eval = eval;
        this.includes = includes;
        this.excludes = excludes;
        this.computeFiles();
        eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)eval));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeFiles() {
        String[] _includePaths = this.computeFrom(this.includes);
        String[] _excludePaths = this.computeFrom(this.excludes);
        SharabilityQueryImpl sharabilityQueryImpl = this;
        synchronized (sharabilityQueryImpl) {
            this.includePaths = _includePaths;
            this.excludePaths = _excludePaths;
        }
    }

    private String[] computeFrom(String[] list) {
        ArrayList<String> result = new ArrayList<String>(list.length);
        for (String s : list) {
            String val = this.eval.evaluate(s);
            if (val == null) continue;
            File f = this.h.resolveFile(val);
            result.add(f.getAbsolutePath());
        }
        return result.toArray(new String[result.size()]);
    }

    public synchronized int getSharability(File file) {
        String path = file.getAbsolutePath();
        if (SharabilityQueryImpl.contains(path, this.excludePaths, false)) {
            return 2;
        }
        return SharabilityQueryImpl.contains(path, this.includePaths, false) ? (SharabilityQueryImpl.contains(path, this.excludePaths, true) ? 3 : 1) : 0;
    }

    private static boolean contains(String path, String[] list, boolean reverse) {
        for (String s : list) {
            if (path.equals(s)) {
                return true;
            }
            if (!(reverse ? s.startsWith(path + File.separatorChar) : path.startsWith(s + File.separatorChar))) continue;
            return true;
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.computeFiles();
    }
}

