/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.project.ant.AntBasedProjectFactorySingleton;
import org.netbeans.modules.project.ant.FileChangeSupport;
import org.netbeans.modules.project.ant.FileChangeSupportEvent;
import org.netbeans.modules.project.ant.FileChangeSupportListener;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PathMatcher;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public final class SourcesHelper {
    private final AntProjectHelper project;
    private final PropertyEvaluator evaluator;
    private final List<SourceRoot> principalSourceRoots = new ArrayList<SourceRoot>();
    private final List<Root> nonSourceRoots = new ArrayList<Root>();
    private final List<TypedSourceRoot> typedSourceRoots = new ArrayList<TypedSourceRoot>();
    private int registeredRootAlgorithm;
    private Set<FileObject> lastRegisteredRoots;
    private PropertyChangeListener propChangeL;

    public SourcesHelper(AntProjectHelper project, PropertyEvaluator evaluator) {
        this.project = project;
        this.evaluator = evaluator;
    }

    public void addPrincipalSourceRoot(String location, String displayName, Icon icon, Icon openedIcon) throws IllegalStateException {
        this.addPrincipalSourceRoot(location, null, null, displayName, icon, openedIcon);
    }

    public void addPrincipalSourceRoot(String location, String includes, String excludes, String displayName, Icon icon, Icon openedIcon) throws IllegalStateException {
        if (this.lastRegisteredRoots != null) {
            throw new IllegalStateException("registerExternalRoots was already called");
        }
        this.principalSourceRoots.add(new SourceRoot(location, includes, excludes, displayName, icon, openedIcon));
    }

    public void addNonSourceRoot(String location) throws IllegalStateException {
        if (this.lastRegisteredRoots != null) {
            throw new IllegalStateException("registerExternalRoots was already called");
        }
        this.nonSourceRoots.add(new Root(location));
    }

    public void addTypedSourceRoot(String location, String type, String displayName, Icon icon, Icon openedIcon) throws IllegalStateException {
        this.addTypedSourceRoot(location, null, null, type, displayName, icon, openedIcon);
    }

    public void addTypedSourceRoot(String location, String includes, String excludes, String type, String displayName, Icon icon, Icon openedIcon) throws IllegalStateException {
        if (this.lastRegisteredRoots != null) {
            throw new IllegalStateException("registerExternalRoots was already called");
        }
        this.typedSourceRoots.add(new TypedSourceRoot(type, location, includes, excludes, displayName, icon, openedIcon));
    }

    private Project getProject() {
        return AntBasedProjectFactorySingleton.getProjectFor(this.project);
    }

    public void registerExternalRoots(int algorithm) throws IllegalArgumentException, IllegalStateException {
        if (this.lastRegisteredRoots != null) {
            throw new IllegalStateException("registerExternalRoots was already called before");
        }
        this.registeredRootAlgorithm = algorithm;
        this.remarkExternalRoots();
    }

    private void remarkExternalRoots() throws IllegalArgumentException {
        ArrayList<SourceRoot> allRoots = new ArrayList<SourceRoot>(this.principalSourceRoots);
        allRoots.addAll(this.nonSourceRoots);
        Project p = this.getProject();
        FileObject pdir = this.project.getProjectDirectory();
        if (this.lastRegisteredRoots == null) {
            this.lastRegisteredRoots = Collections.emptySet();
            this.propChangeL = new PropChangeL();
            this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propChangeL, (Object)this.evaluator));
        }
        HashSet<FileObject> newRegisteredRoots = new HashSet<FileObject>();
        for (Root root : allRoots) {
            for (FileObject loc : root.getIncludeRoots()) {
                if (!loc.isFolder() || FileUtil.getRelativePath((FileObject)pdir, (FileObject)loc) != null) continue;
                try {
                    Project other = ProjectManager.getDefault().findProject(loc);
                    if (other != null) {
                    }
                }
                catch (IOException e) {}
                continue;
                newRegisteredRoots.add(loc);
            }
        }
        HashSet<FileObject> toUnregister = new HashSet<FileObject>(this.lastRegisteredRoots);
        toUnregister.removeAll(newRegisteredRoots);
        for (FileObject loc : toUnregister) {
            FileOwnerQuery.markExternalOwner((FileObject)loc, null, (int)this.registeredRootAlgorithm);
        }
        HashSet hashSet = new HashSet(newRegisteredRoots);
        hashSet.removeAll(this.lastRegisteredRoots);
        for (FileObject loc : hashSet) {
            FileOwnerQuery.markExternalOwner((FileObject)loc, (Project)p, (int)this.registeredRootAlgorithm);
        }
        this.lastRegisteredRoots = newRegisteredRoots;
    }

    public Sources createSources() {
        return new SourcesImpl();
    }

    private final class PropChangeL
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            for (SourceRoot r : SourcesHelper.this.principalSourceRoots) {
                r.matcher = null;
            }
            SourcesHelper.this.remarkExternalRoots();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Root {
        protected final String location;

        public Root(String location) {
            this.location = location;
        }

        public final File getActualLocation() {
            String val = SourcesHelper.this.evaluator.evaluate(this.location);
            if (val == null) {
                return null;
            }
            return SourcesHelper.this.project.resolveFile(val);
        }

        public Collection<FileObject> getIncludeRoots() {
            FileObject fo;
            File loc = this.getActualLocation();
            if (loc != null && (fo = FileUtil.toFileObject((File)loc)) != null) {
                return Collections.singleton(fo);
            }
            return Collections.emptySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SourceRoot
    extends Root {
        private final String displayName;
        private final Icon icon;
        private final Icon openedIcon;
        private final String includes;
        private final String excludes;
        private PathMatcher matcher;

        public SourceRoot(String location, String includes, String excludes, String displayName, Icon icon, Icon openedIcon) {
            super(location);
            this.displayName = displayName;
            this.icon = icon;
            this.openedIcon = openedIcon;
            this.includes = includes;
            this.excludes = excludes;
        }

        public final SourceGroup toGroup(FileObject loc) {
            assert (loc != null);
            return new Group(loc);
        }

        public String toString() {
            return "SourceRoot[" + this.location + "]";
        }

        private String evalForMatcher(String raw) {
            if (raw == null) {
                return null;
            }
            String patterns = SourcesHelper.this.evaluator.evaluate(raw);
            if (patterns == null) {
                return null;
            }
            if (patterns.matches("\\$\\{[^}]+\\}")) {
                return null;
            }
            return patterns;
        }

        private void computeIncludeExcludePatterns() {
            if (this.matcher != null) {
                return;
            }
            String includesPattern = this.evalForMatcher(this.includes);
            String excludesPattern = this.evalForMatcher(this.excludes);
            this.matcher = new PathMatcher(includesPattern, excludesPattern, this.getActualLocation());
        }

        @Override
        public Collection<FileObject> getIncludeRoots() {
            Collection<FileObject> supe = super.getIncludeRoots();
            this.computeIncludeExcludePatterns();
            if (supe.size() == 1) {
                HashSet<FileObject> roots = new HashSet<FileObject>();
                for (File r : this.matcher.findIncludedRoots()) {
                    FileObject subroot = FileUtil.toFileObject((File)r);
                    if (subroot == null) continue;
                    roots.add(subroot);
                }
                return roots;
            }
            assert (supe.isEmpty());
            return supe;
        }

        private final class Group
        implements SourceGroup,
        PropertyChangeListener {
            private final FileObject loc;
            private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

            Group(FileObject loc) {
                this.loc = loc;
                SourcesHelper.this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)SourcesHelper.this.evaluator));
            }

            public FileObject getRootFolder() {
                return this.loc;
            }

            public String getName() {
                return SourceRoot.this.location.length() > 0 ? SourceRoot.this.location : "generic";
            }

            public String getDisplayName() {
                return SourceRoot.this.displayName;
            }

            public Icon getIcon(boolean opened) {
                return opened ? SourceRoot.this.icon : SourceRoot.this.openedIcon;
            }

            public boolean contains(FileObject file) throws IllegalArgumentException {
                if (file == this.loc) {
                    return true;
                }
                String path = FileUtil.getRelativePath((FileObject)this.loc, (FileObject)file);
                if (path == null) {
                    throw new IllegalArgumentException();
                }
                if (file.isFolder()) {
                    path = path + "/";
                }
                SourceRoot.this.computeIncludeExcludePatterns();
                if (!SourceRoot.this.matcher.matches(path, true)) {
                    return false;
                }
                Project p = SourcesHelper.this.getProject();
                if (file.isFolder() && file != p.getProjectDirectory() && ProjectManager.getDefault().isProject(file)) {
                    return false;
                }
                Project owner = FileOwnerQuery.getOwner((FileObject)file);
                if (owner != null && owner != p) {
                    return false;
                }
                File f = FileUtil.toFile((FileObject)file);
                return f == null || SharabilityQuery.getSharability((File)f) != 2;
            }

            public void addPropertyChangeListener(PropertyChangeListener l) {
                this.pcs.addPropertyChangeListener(l);
            }

            public void removePropertyChangeListener(PropertyChangeListener l) {
                this.pcs.removePropertyChangeListener(l);
            }

            public String toString() {
                return "SourcesHelper.Group[name=" + this.getName() + ",rootFolder=" + this.getRootFolder() + "]";
            }

            public void propertyChange(PropertyChangeEvent ev) {
                assert (ev.getSource() == SourcesHelper.this.evaluator) : ev;
                String prop = ev.getPropertyName();
                if (prop == null || SourceRoot.this.includes != null && SourceRoot.this.includes.contains("${" + prop + "}") || SourceRoot.this.excludes != null && SourceRoot.this.excludes.contains("${" + prop + "}")) {
                    SourceRoot.this.matcher = null;
                    this.pcs.firePropertyChange("containership", null, null);
                }
            }
        }
    }

    private final class SourcesImpl
    implements Sources,
    PropertyChangeListener,
    FileChangeSupportListener {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private boolean haveAttachedListeners;
        private final Set<File> rootsListenedTo = new HashSet<File>();
        private final Map<String, List<URL>> lastComputedRoots = new HashMap<String, List<URL>>();

        public SourcesImpl() {
            SourcesHelper.this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)SourcesHelper.this.evaluator));
        }

        public SourceGroup[] getSourceGroups(String type) {
            ArrayList<SourceGroup> groups = new ArrayList<SourceGroup>();
            if (type.equals("generic")) {
                ArrayList<SourceRoot> roots = new ArrayList<SourceRoot>(SourcesHelper.this.principalSourceRoots);
                roots.add(new SourceRoot("", null, null, ProjectUtils.getInformation((Project)SourcesHelper.this.getProject()).getDisplayName(), null, null));
                LinkedHashMap<FileObject, SourceRoot> rootsByDir = new LinkedHashMap<FileObject, SourceRoot>();
                for (SourceRoot r : roots) {
                    File locF = r.getActualLocation();
                    if (locF == null) continue;
                    this.listen(locF);
                    FileObject loc = FileUtil.toFileObject((File)locF);
                    if (loc == null || rootsByDir.containsKey(loc)) continue;
                    rootsByDir.put(loc, r);
                }
                Iterator it = rootsByDir.keySet().iterator();
                block3: while (it.hasNext()) {
                    FileObject loc = (FileObject)it.next();
                    for (FileObject parent = loc.getParent(); parent != null; parent = parent.getParent()) {
                        if (!rootsByDir.containsKey(parent)) continue;
                        it.remove();
                        continue block3;
                    }
                }
                for (Map.Entry entry : rootsByDir.entrySet()) {
                    groups.add(((SourceRoot)entry.getValue()).toGroup((FileObject)entry.getKey()));
                }
            } else {
                HashSet<FileObject> dirs = new HashSet<FileObject>();
                for (TypedSourceRoot r : SourcesHelper.this.typedSourceRoots) {
                    File locF;
                    if (!r.getType().equals(type) || (locF = r.getActualLocation()) == null) continue;
                    this.listen(locF);
                    FileObject loc = FileUtil.toFileObject((File)locF);
                    if (loc == null || !dirs.add(loc)) continue;
                    groups.add(r.toGroup(loc));
                }
            }
            ArrayList<URL> rootURLs = new ArrayList<URL>(groups.size());
            for (SourceGroup g : groups) {
                try {
                    rootURLs.add(g.getRootFolder().getURL());
                }
                catch (FileStateInvalidException e) {
                    assert (false) : e;
                }
            }
            this.lastComputedRoots.put(type, rootURLs);
            return groups.toArray(new SourceGroup[groups.size()]);
        }

        private void listen(File rootLocation) {
            if (this.rootsListenedTo.add(rootLocation) && this.haveAttachedListeners) {
                FileChangeSupport.DEFAULT.addListener(this, rootLocation);
            }
        }

        public void addChangeListener(ChangeListener listener) {
            if (!this.haveAttachedListeners) {
                this.haveAttachedListeners = true;
                for (File rootLocation : this.rootsListenedTo) {
                    FileChangeSupport.DEFAULT.addListener(this, rootLocation);
                }
            }
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }

        private void maybeFireChange() {
            boolean change = false;
            for (String type : new HashSet<String>(this.lastComputedRoots.keySet())) {
                ArrayList previous = new ArrayList(this.lastComputedRoots.get(type));
                this.getSourceGroups(type);
                List<URL> nue = this.lastComputedRoots.get(type);
                if (((Object)nue).equals(previous)) continue;
                change = true;
                break;
            }
            if (change) {
                this.cs.fireChange();
            }
        }

        public void fileCreated(FileChangeSupportEvent event) {
            this.maybeFireChange();
        }

        public void fileDeleted(FileChangeSupportEvent event) {
            this.maybeFireChange();
        }

        public void fileModified(FileChangeSupportEvent event) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.maybeFireChange();
        }
    }

    private final class TypedSourceRoot
    extends SourceRoot {
        private final String type;

        public TypedSourceRoot(String type, String location, String includes, String excludes, String displayName, Icon icon, Icon openedIcon) {
            super(location, includes, excludes, displayName, icon, openedIcon);
            this.type = type;
        }

        public final String getType() {
            return this.type;
        }
    }
}

