/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.nodes.ChildrenArray;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.Enumerations;
import org.openide.util.Mutex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Children {
    static final Mutex.Privileged PR = new Mutex.Privileged();
    public static final Mutex MUTEX = new Mutex(PR);
    public static final Children LEAF = new Empty();
    private static final Object LOCK = new Object();
    private static final Logger LOG_GET_ARRAY = Logger.getLogger("org.openide.nodes.Children.getArray");
    private Node parent;
    private java.util.Map<Entry, Info> map;
    private Collection<? extends Entry> entries = Collections.emptyList();
    private Reference<ChildrenArray> array = new WeakReference<Object>(null);
    private Thread initThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void attachTo(Node n) throws IllegalStateException {
        if (this == LEAF) {
            return;
        }
        Children children = this;
        synchronized (children) {
            if (this.parent != null) {
                throw new IllegalStateException("An instance of Children may not be used for more than one parent node.");
            }
            this.parent = n;
        }
        try {
            PR.enterReadAccess();
            Node[] nodes = this.testNodes();
            if (nodes == null) {
                return;
            }
            for (int i = 0; i < nodes.length; ++i) {
                Node node = nodes[i];
                node.assignTo(this, i);
                node.fireParentNodeChange(null, this.parent);
            }
        }
        finally {
            PR.exitReadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void detachFrom() {
        if (this == LEAF) {
            return;
        }
        Node oldParent = null;
        Children children = this;
        synchronized (children) {
            if (this.parent == null) {
                throw new IllegalStateException("Trying to detach children which do not have parent");
            }
            oldParent = this.parent;
            this.parent = null;
        }
        try {
            PR.enterReadAccess();
            Node[] nodes = this.testNodes();
            if (nodes == null) {
                return;
            }
            for (int i = 0; i < nodes.length; ++i) {
                Node node = nodes[i];
                node.deassignFrom(this);
                node.fireParentNodeChange(oldParent, null);
            }
        }
        finally {
            PR.exitReadAccess();
        }
    }

    protected final Node getNode() {
        return this.parent;
    }

    final Object cloneHierarchy() throws CloneNotSupportedException {
        return this.clone();
    }

    protected Object clone() throws CloneNotSupportedException {
        Children ch = (Children)super.clone();
        ch.parent = null;
        ch.map = null;
        ch.entries = Collections.emptyList();
        ch.array = new WeakReference<Object>(null);
        return ch;
    }

    public abstract boolean add(Node[] var1);

    public abstract boolean remove(Node[] var1);

    public final Enumeration<Node> nodes() {
        return Enumerations.array((Object[])this.getNodes());
    }

    public Node findChild(String name) {
        Node[] list = this.getNodes();
        if (list.length == 0) {
            return null;
        }
        if (name == null) {
            return list[0];
        }
        for (int i = 0; i < list.length; ++i) {
            if (!name.equals(list[i].getName())) continue;
            return list[i];
        }
        return null;
    }

    protected final boolean isInitialized() {
        ChildrenArray arr = this.array.get();
        return arr != null && arr.isInitialized();
    }

    final Node getNodeAt(int i) {
        return this.getNodes()[i];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Node[] getNodes() {
        Node[] nodes;
        boolean[] results = new boolean[2];
        do {
            results[1] = this.isInitialized();
            ChildrenArray array = this.getArray(results);
            try {
                PR.enterReadAccess();
                nodes = array.nodes();
            }
            finally {
                PR.exitReadAccess();
            }
            boolean IS_LOG_GET_ARRAY = LOG_GET_ARRAY.isLoggable(Level.FINE);
            if (IS_LOG_GET_ARRAY) {
                LOG_GET_ARRAY.fine("  length     : " + nodes.length);
                LOG_GET_ARRAY.fine("  entries    : " + this.entries);
                LOG_GET_ARRAY.fine("  init now   : " + this.isInitialized());
            }
            if (!results[1]) continue;
            return nodes;
        } while (!results[0]);
        return nodes == null ? new Node[]{} : nodes;
    }

    public Node[] getNodes(boolean optimalResult) {
        if (optimalResult) {
            boolean IS_LOG_GET_ARRAY = LOG_GET_ARRAY.isLoggable(Level.FINE);
            if (IS_LOG_GET_ARRAY) {
                LOG_GET_ARRAY.fine("computing optimal result");
            }
            ChildrenArray hold = this.getArray(null);
            if (IS_LOG_GET_ARRAY) {
                LOG_GET_ARRAY.fine("optimal result is here: " + hold);
            }
            Node find = this.findChild(null);
            if (IS_LOG_GET_ARRAY) {
                LOG_GET_ARRAY.fine("Find child got: " + find);
            }
        }
        return this.getNodes();
    }

    public final int getNodesCount() {
        return this.getNodes().length;
    }

    protected void addNotify() {
    }

    protected void removeNotify() {
    }

    void callAddNotify() {
        this.addNotify();
    }

    private Node[] testNodes() {
        ChildrenArray arr = this.array.get();
        return arr == null ? null : arr.nodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ChildrenArray getArray(boolean[] cannotWorkBetter) {
        ChildrenArray arr;
        final boolean IS_LOG_GET_ARRAY = LOG_GET_ARRAY.isLoggable(Level.FINE);
        boolean doInitialize = false;
        Object object = LOCK;
        synchronized (object) {
            arr = this.array.get();
            if (arr == null) {
                arr = new ChildrenArray();
                this.registerChildrenArray(arr, true);
                doInitialize = true;
                this.initThread = Thread.currentThread();
            }
        }
        if (doInitialize) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class SetAndNotify
            implements Runnable {
                public ChildrenArray toSet;
                public Children whatSet;

                SetAndNotify() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = LOCK;
                    synchronized (object) {
                        Children.this.initThread = null;
                        LOCK.notifyAll();
                    }
                    if (IS_LOG_GET_ARRAY) {
                        LOG_GET_ARRAY.fine("notifyAll done");
                    }
                }
            }
            if (IS_LOG_GET_ARRAY) {
                LOG_GET_ARRAY.fine("Initialize " + this + " on " + Thread.currentThread());
            }
            try {
                this.callAddNotify();
                if (IS_LOG_GET_ARRAY) {
                    LOG_GET_ARRAY.fine("addNotify successfully called for " + this + " on " + Thread.currentThread());
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                boolean notifyLater = MUTEX.isReadAccess();
                if (IS_LOG_GET_ARRAY) {
                    LOG_GET_ARRAY.fine("notifyAll for " + this + " on " + Thread.currentThread() + "  notifyLater: " + notifyLater);
                }
                arr.children = this;
                SetAndNotify setAndNotify = new SetAndNotify();
                setAndNotify.toSet = arr;
                setAndNotify.whatSet = this;
                if (notifyLater) {
                    MUTEX.postWriteRequest((Runnable)setAndNotify);
                    throw throwable;
                } else {
                    setAndNotify.run();
                }
                throw throwable;
            }
            boolean notifyLater = MUTEX.isReadAccess();
            if (IS_LOG_GET_ARRAY) {
                LOG_GET_ARRAY.fine("notifyAll for " + this + " on " + Thread.currentThread() + "  notifyLater: " + notifyLater);
            }
            arr.children = this;
            SetAndNotify setAndNotify = new SetAndNotify();
            setAndNotify.toSet = arr;
            setAndNotify.whatSet = this;
            if (notifyLater) {
                MUTEX.postWriteRequest((Runnable)setAndNotify);
                return arr;
            }
            setAndNotify.run();
            return arr;
        }
        if (MUTEX.isReadAccess() || MUTEX.isWriteAccess() || this.initThread == Thread.currentThread()) {
            if (IS_LOG_GET_ARRAY) {
                LOG_GET_ARRAY.log(Level.FINE, "cannot initialize better " + this + " on " + Thread.currentThread() + " read access: " + MUTEX.isReadAccess() + " initThread: " + this.initThread, new Exception("StackTrace"));
            }
            if (cannotWorkBetter == null) return arr;
            cannotWorkBetter[0] = true;
            return arr;
        }
        object = LOCK;
        synchronized (object) {
            while (this.initThread != null) {
                if (IS_LOG_GET_ARRAY) {
                    LOG_GET_ARRAY.fine("waiting for children for " + this + " on " + Thread.currentThread());
                }
                try {
                    LOCK.wait();
                }
                catch (InterruptedException ex) {}
            }
        }
        if (!IS_LOG_GET_ARRAY) return arr;
        LOG_GET_ARRAY.fine(" children are here for " + this + " on " + Thread.currentThread() + " children " + arr.children);
        return arr;
    }

    private void clearNodes() {
        ChildrenArray arr = this.array.get();
        if (arr != null) {
            arr.clear();
        }
    }

    final void finalizeNodes() {
        ChildrenArray arr = this.array.get();
        if (arr != null) {
            arr.finalizeNodes();
        }
    }

    final void registerChildrenArray(final ChildrenArray chArr, boolean weak) {
        boolean IS_LOG_GET_ARRAY = LOG_GET_ARRAY.isLoggable(Level.FINE);
        if (IS_LOG_GET_ARRAY) {
            LOG_GET_ARRAY.fine("registerChildrenArray: " + chArr + " weak: " + weak);
        }
        this.array = weak ? new WeakReference<ChildrenArray>(chArr) : new WeakReference<ChildrenArray>(chArr){

            @Override
            public ChildrenArray get() {
                return chArr;
            }
        };
        chArr.pointedBy(this.array);
        if (IS_LOG_GET_ARRAY) {
            LOG_GET_ARRAY.fine("pointed by: " + chArr + " to: " + this.array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void finalizedChildrenArray(Reference caller) {
        boolean IS_LOG_GET_ARRAY = LOG_GET_ARRAY.isLoggable(Level.FINE);
        try {
            PR.enterWriteAccess();
            if (IS_LOG_GET_ARRAY) {
                LOG_GET_ARRAY.fine("previous array: " + this.array + " caller: " + caller);
            }
            if (this.array == caller) {
                this.removeNotify();
            }
        }
        finally {
            PR.exitWriteAccess();
        }
    }

    /*
     * WARNING - void declaration
     */
    final Node[] justComputeNodes() {
        void var3_5;
        if (this.map == null) {
            this.map = Collections.synchronizedMap(new HashMap(17));
        }
        LinkedList<Node> l = new LinkedList<Node>();
        for (Entry entry : this.entries) {
            Info info = this.findInfo(entry);
            try {
                l.addAll(info.nodes());
            }
            catch (RuntimeException ex) {
                NodeOp.warning(ex);
            }
        }
        Node[] arr = l.toArray(new Node[l.size()]);
        boolean bl = false;
        while (var3_5 < arr.length) {
            Node n = arr[var3_5];
            n.assignTo(this, (int)var3_5);
            n.fireParentNodeChange(null, this.parent);
            ++var3_5;
        }
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Info findInfo(Entry entry) {
        java.util.Map<Entry, Info> map = this.map;
        synchronized (map) {
            Info info = this.map.get(entry);
            if (info == null) {
                info = new Info(entry);
                this.map.put(entry, info);
            }
            return info;
        }
    }

    final List<Entry> getEntries() {
        return new ArrayList<Entry>(this.entries);
    }

    final void setEntries(Collection<? extends Entry> entries) {
        List<Info> toAdd;
        boolean IS_LOG_GET_ARRAY = LOG_GET_ARRAY.isLoggable(Level.FINE);
        ChildrenArray holder = this.array.get();
        if (IS_LOG_GET_ARRAY) {
            LOG_GET_ARRAY.fine("setEntries for " + this + " on " + Thread.currentThread());
            LOG_GET_ARRAY.fine("       values: " + entries);
            LOG_GET_ARRAY.fine("       holder: " + holder);
        }
        if (holder == null) {
            this.entries = entries;
            if (this.map != null) {
                this.map.keySet().retainAll(new HashSet<Entry>(entries));
            }
            return;
        }
        Node[] current = holder.nodes();
        if (current == null) {
            this.entries = entries;
            if (this.map != null) {
                this.map.keySet().retainAll(new HashSet<Entry>(entries));
            }
            return;
        }
        this.map.keySet().retainAll(new HashSet<Entry>(this.entries));
        HashSet<Entry> toRemove = new HashSet<Entry>(this.map.keySet());
        HashSet<? extends Entry> entriesSet = new HashSet<Entry>(entries);
        toRemove.removeAll(entriesSet);
        if (!toRemove.isEmpty()) {
            this.updateRemove(current, toRemove);
            current = holder.nodes();
        }
        if (!(toAdd = this.updateOrder(current, entries)).isEmpty()) {
            this.updateAdd(toAdd, entries);
        }
    }

    private void checkInfo(Info info, Entry entry, Collection<? extends Entry> entries, java.util.Map<Entry, Info> map) {
        if (info == null) {
            throw new IllegalStateException("Error in " + this.getClass().getName() + " with entry " + entry + " from among " + entries + " in " + map + " probably caused by faulty key implementation." + " The key hashCode() and equals() methods must behave as for an IMMUTABLE object" + " and the hashCode() must return the same value for equals() keys.");
        }
    }

    private void updateRemove(Node[] current, Set<Entry> toRemove) {
        LinkedList<Node> nodes = new LinkedList<Node>();
        for (Entry en : toRemove) {
            Info info = this.map.remove(en);
            this.checkInfo(info, en, null, this.map);
            nodes.addAll(info.nodes());
        }
        this.entries.removeAll(toRemove);
        this.clearNodes();
        this.notifyRemove(nodes, current);
    }

    Node[] notifyRemove(Collection<Node> nodes, Node[] current) {
        Node[] arr = nodes.toArray(new Node[nodes.size()]);
        if (this.parent == null) {
            return arr;
        }
        this.parent.fireSubNodesChange(false, arr, current);
        for (Node n : nodes) {
            n.deassignFrom(this);
            n.fireParentNodeChange(this.parent, null);
        }
        return arr;
    }

    /*
     * WARNING - void declaration
     */
    private List<Info> updateOrder(Node[] current, Collection<? extends Entry> newEntries) {
        void var7_11;
        LinkedList<Info> toAdd = new LinkedList<Info>();
        HashMap<Info, Integer> offsets = new HashMap<Info, Integer>();
        int previousPos = 0;
        for (Entry entry : this.entries) {
            Info info = this.map.get(entry);
            this.checkInfo(info, entry, this.entries, this.map);
            offsets.put(info, previousPos);
            previousPos += info.length();
        }
        this.map.keySet().retainAll(new HashSet<Entry>(this.entries));
        int[] perm = new int[current.length];
        int currentPos = 0;
        boolean bl = false;
        LinkedList<Entry> reorderedEntries = null;
        for (Entry entry : newEntries) {
            Info info = this.map.get(entry);
            if (info == null) {
                info = new Info(entry);
                toAdd.add(info);
            } else {
                int len = info.length();
                if (reorderedEntries == null) {
                    reorderedEntries = new LinkedList<Entry>();
                }
                reorderedEntries.add(entry);
                Integer previousInt = (Integer)offsets.get(info);
                int previousPos2 = previousInt;
                if (currentPos != previousPos2) {
                    for (int i = 0; i < len; ++i) {
                        perm[previousPos2 + i] = 1 + currentPos + i;
                    }
                    var7_11 += len;
                }
            }
            currentPos += info.length();
        }
        if (var7_11 > 0) {
            for (int i = 0; i < perm.length; ++i) {
                if (perm[i] == 0) {
                    perm[i] = i;
                    continue;
                }
                int n = i;
                perm[n] = perm[n] - 1;
            }
            this.entries = reorderedEntries;
            this.clearNodes();
            Node p = this.parent;
            if (p != null) {
                p.fireReorderChange(perm);
            }
        }
        return toAdd;
    }

    private void updateAdd(Collection<Info> infos, Collection<? extends Entry> entries) {
        LinkedList<Node> nodes = new LinkedList<Node>();
        for (Info info : infos) {
            nodes.addAll(info.nodes());
            this.map.put(info.entry, info);
        }
        this.entries = entries;
        this.clearNodes();
        this.notifyAdd(nodes);
    }

    private void notifyAdd(Collection<Node> nodes) {
        Node n2;
        for (Node n2 : nodes) {
            n2.assignTo(this, -1);
            n2.fireParentNodeChange(null, this.parent);
        }
        Node[] arr = nodes.toArray(new Node[nodes.size()]);
        n2 = this.parent;
        if (n2 != null) {
            n2.fireSubNodesChange(true, arr, null);
        }
    }

    final void refreshEntry(Entry entry) {
        Collection<Node> newNodes;
        ChildrenArray holder = this.array.get();
        if (holder == null) {
            return;
        }
        Node[] current = holder.nodes();
        if (current == null) {
            return;
        }
        this.map.keySet().retainAll(new HashSet<Entry>(this.entries));
        Info info = this.map.get(entry);
        if (info == null) {
            return;
        }
        Collection<Node> oldNodes = info.nodes();
        if (((Object)oldNodes).equals(newNodes = info.entry.nodes())) {
            return;
        }
        HashSet<Node> toRemove = new HashSet<Node>(oldNodes);
        toRemove.removeAll(newNodes);
        if (!toRemove.isEmpty()) {
            oldNodes.removeAll(toRemove);
            this.clearNodes();
            this.notifyRemove(toRemove, current);
            current = holder.nodes();
        }
        List<Node> toAdd = this.refreshOrder(entry, oldNodes, newNodes);
        info.useNodes(newNodes);
        if (!toAdd.isEmpty()) {
            this.clearNodes();
            this.notifyAdd(toAdd);
        }
    }

    private List<Node> refreshOrder(Entry entry, Collection<Node> oldNodes, Collection<Node> newNodes) {
        Entry e;
        LinkedList<Node> toAdd = new LinkedList<Node>();
        int currentPos = 0;
        Iterator<? extends Entry> it1 = this.entries.iterator();
        while (!(e = it1.next()).equals(entry)) {
            Info info = this.findInfo(e);
            currentPos += info.length();
        }
        HashSet<Node> oldNodesSet = new HashSet<Node>(oldNodes);
        HashSet<Node> toProcess = new HashSet<Node>(oldNodesSet);
        Node[] permArray = new Node[oldNodes.size()];
        Iterator<Node> it2 = newNodes.iterator();
        int pos = 0;
        while (it2.hasNext()) {
            Node n = it2.next();
            if (oldNodesSet.remove(n)) {
                permArray[pos++] = n;
                continue;
            }
            if (!toProcess.contains(n)) {
                toAdd.add(n);
                continue;
            }
            it2.remove();
        }
        int[] perm = NodeOp.computePermutation(oldNodes.toArray(new Node[oldNodes.size()]), permArray);
        if (perm != null) {
            this.clearNodes();
            this.findInfo(entry).useNodes(Arrays.asList(permArray));
            Node p = this.parent;
            if (p != null) {
                p.fireReorderChange(perm);
            }
        }
        return toAdd;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Array
    extends Children
    implements Cloneable {
        private Entry nodesEntry = this.createNodesEntry();
        protected Collection<Node> nodes;

        protected Array(Collection<Node> c) {
            this();
            this.nodes = c;
        }

        public Array() {
            this.setEntries(Collections.singleton(this.getNodesEntry()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object clone() {
            try {
                Array ar = (Array)super.clone();
                try {
                    PR.enterReadAccess();
                    if (this.nodes != null) {
                        ar.nodes = ar.initCollection();
                        ar.nodes.clear();
                        for (Node n : this.nodes) {
                            ar.nodes.add(n.cloneNode());
                        }
                    }
                }
                finally {
                    PR.exitReadAccess();
                }
                return ar;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        protected Collection<Node> initCollection() {
            return new ArrayList<Node>();
        }

        final void refreshImpl() {
            if (this.isInitialized()) {
                this.refreshEntry(this.getNodesEntry());
                ((Children)this).getArray(null).nodes();
            } else if (this.nodes != null) {
                for (Node n : this.nodes) {
                    n.assignTo(this, -1);
                }
            }
        }

        protected final void refresh() {
            MUTEX.postWriteRequest(new Runnable(){

                public void run() {
                    Array.this.refreshImpl();
                }
            });
        }

        final Entry getNodesEntry() {
            return this.nodesEntry;
        }

        Entry createNodesEntry() {
            return new AE();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Collection<Node> getCollection() {
            Entry entry = this.getNodesEntry();
            synchronized (entry) {
                if (this.nodes == null) {
                    this.nodes = this.initCollection();
                }
            }
            return this.nodes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(Node[] arr) {
            Entry entry = this.getNodesEntry();
            synchronized (entry) {
                if (!this.getCollection().addAll(Arrays.asList(arr))) {
                    return false;
                }
            }
            this.refresh();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Node[] arr) {
            Entry entry = this.getNodesEntry();
            synchronized (entry) {
                if (!this.getCollection().removeAll(Arrays.asList(arr))) {
                    return false;
                }
            }
            this.refresh();
            return true;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class AE
        implements Entry {
            AE() {
            }

            @Override
            public Collection<Node> nodes() {
                Collection<Node> c = Array.this.getCollection();
                if (c.isEmpty()) {
                    return Collections.emptyList();
                }
                return new ArrayList<Node>(c);
            }

            public String toString() {
                return "Children.Array.AE" + Array.this.getCollection();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Dupl<T>
    implements Cloneable,
    Entry {
        protected Object key;

        Dupl() {
        }

        public final void updateList(Collection<? extends T> src, Collection<? super Dupl<T>> target) {
            HashMap map = new HashMap(src.size() * 2);
            for (T o : src) {
                this.updateListAndMap(o, target, map);
            }
        }

        public final void updateList(T[] arr, Collection<? super Dupl<T>> target) {
            HashMap map = new HashMap(arr.length * 2);
            for (T o : arr) {
                this.updateListAndMap(o, target, map);
            }
        }

        public final void updateListAndMap(T obj, Collection<? super Dupl<T>> list, java.util.Map<T, Object> map) {
            Object prev = map.put(obj, this);
            if (prev == null) {
                list.add(this.createInstance(obj, 0));
                return;
            }
            if (prev == this) {
                map.put(obj, 1);
                list.add(this.createInstance(obj, 1));
                return;
            }
            int cnt = (Integer)prev + 1;
            map.put(obj, cnt);
            list.add(this.createInstance(obj, cnt));
        }

        public final T getKey() {
            if (this.key instanceof Dupl) {
                return ((Dupl)this.key).getKey();
            }
            return (T)this.key;
        }

        public final int getCnt() {
            int cnt = 0;
            Dupl d = this;
            while (d.key instanceof Dupl) {
                d = (Dupl)d.key;
                ++cnt;
            }
            return cnt;
        }

        private final Dupl<T> createInstance(Object obj, int cnt) {
            try {
                Dupl d;
                Dupl first = d = (Dupl)this.clone();
                while (cnt-- > 0) {
                    Dupl n = (Dupl)this.clone();
                    d.key = n;
                    d = n;
                }
                d.key = obj;
                return first;
            }
            catch (CloneNotSupportedException ex) {
                throw new InternalError();
            }
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Dupl) {
                Dupl d = (Dupl)o;
                return this.getKey().equals(d.getKey()) && this.getCnt() == d.getCnt();
            }
            return false;
        }
    }

    private static final class Empty
    extends Children {
        Empty() {
        }

        public boolean add(Node[] nodes) {
            return false;
        }

        public boolean remove(Node[] nodes) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Entry {
        public Collection<Node> nodes();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Info {
        int length;
        final Entry entry;

        public Info(Entry entry) {
            this.entry = entry;
        }

        protected void finalize() {
            Children.this.finalizeNodes();
        }

        public Collection<Node> nodes() {
            ChildrenArray arr = Children.this.getArray(null);
            return arr.nodesFor(this);
        }

        public void useNodes(Collection<Node> nodes) {
            ChildrenArray arr = Children.this.getArray(null);
            arr.useNodes(this, nodes);
            for (Node n : nodes) {
                n.assignTo(Children.this, -1);
                n.fireParentNodeChange(null, Children.this.parent);
            }
        }

        public int length() {
            return this.length;
        }

        public String toString() {
            return "Children.Info[" + this.entry + ",length=" + this.length + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Keys<T>
    extends Array {
        private static java.util.Map<Keys<?>, Runnable> lastRuns = new HashMap(11);
        private boolean before;

        @Override
        public Object clone() {
            Keys k = (Keys)super.clone();
            return k;
        }

        @Override
        @Deprecated
        public boolean add(Node[] arr) {
            return super.add(arr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public boolean remove(Node[] arr) {
            try {
                PR.enterWriteAccess();
                if (this.nodes != null) {
                    for (int i = 0; i < arr.length; ++i) {
                        if (this.nodes.contains(arr[i])) continue;
                        arr[i] = null;
                    }
                    super.remove(arr);
                }
            }
            finally {
                PR.exitWriteAccess();
            }
            return true;
        }

        protected final void refreshKey(final T key) {
            MUTEX.postWriteRequest(new Runnable(){

                public void run() {
                    Keys.this.refreshEntry(new KE(key));
                }
            });
        }

        protected final void setKeys(Collection<? extends T> keysSet) {
            boolean asserts = false;
            if (!$assertionsDisabled) {
                asserts = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            int sz = keysSet.size();
            if (asserts && sz < 10) {
                ArrayList<T> keys = new ArrayList<T>(keysSet);
                for (int i = 0; i < sz - 1; ++i) {
                    Object a = keys.get(i);
                    for (int j = i + 1; j < sz; ++j) {
                        Object b = keys.get(j);
                        assert (!a.equals(b) || a.hashCode() == b.hashCode()) : "bad equals/hashCode in " + a + " vs. " + b;
                    }
                }
            }
            ArrayList<Entry> l = new ArrayList<Entry>(keysSet.size() + 1);
            if (this.before) {
                l.add(this.getNodesEntry());
            }
            KE updator = new KE();
            updator.updateList(keysSet, l);
            if (!this.before) {
                l.add(this.getNodesEntry());
            }
            this.applyKeys(l);
        }

        protected final void setKeys(T[] keys) {
            boolean asserts = false;
            if (!$assertionsDisabled) {
                asserts = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            int sz = keys.length;
            if (asserts && sz < 10) {
                for (int i = 0; i < sz - 1; ++i) {
                    T a = keys[i];
                    for (int j = i + 1; j < sz; ++j) {
                        T b = keys[j];
                        assert (!a.equals(b) || a.hashCode() == b.hashCode()) : "bad equals/hashCode in " + a + " vs. " + b;
                    }
                }
            }
            ArrayList<Entry> l = new ArrayList<Entry>(keys.length + 1);
            KE updator = new KE();
            if (this.before) {
                l.add(this.getNodesEntry());
            }
            updator.updateList(keys, l);
            if (!this.before) {
                l.add(this.getNodesEntry());
            }
            this.applyKeys(l);
        }

        private void applyKeys(final List<? extends Entry> l) {
            Runnable invoke = new Runnable(){

                public void run() {
                    if (Keys.keysCheck(Keys.this, this)) {
                        Keys.this.setEntries(l);
                        Keys.keysExit(Keys.this, this);
                    }
                }
            };
            Keys.keysEnter(this, invoke);
            MUTEX.postWriteRequest(invoke);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void setBefore(boolean b) {
            try {
                PR.enterWriteAccess();
                if (this.before != b) {
                    List<Entry> l = this.getEntries();
                    l.remove(this.getNodesEntry());
                    this.before = b;
                    if (b) {
                        l.add(0, this.getNodesEntry());
                    } else {
                        l.add(this.getNodesEntry());
                    }
                    this.setEntries(l);
                }
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        protected abstract Node[] createNodes(T var1);

        protected void destroyNodes(Node[] arr) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i].fireNodeDestroyed();
            }
        }

        @Override
        Node[] notifyRemove(Collection<Node> nodes, Node[] current) {
            Node[] arr = super.notifyRemove(nodes, current);
            this.destroyNodes(arr);
            return arr;
        }

        private static synchronized void keysEnter(Keys<?> ch, Runnable run) {
            lastRuns.put(ch, run);
        }

        private static synchronized void keysExit(Keys ch, Runnable r) {
            Runnable reg = lastRuns.remove(ch);
            if (reg != null && !reg.equals(r)) {
                lastRuns.put(ch, reg);
            }
        }

        private static synchronized boolean keysCheck(Keys ch, Runnable run) {
            return run == lastRuns.get(ch);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class KE
        extends Dupl<T> {
            public KE() {
            }

            public KE(T key) {
                this.key = key;
            }

            @Override
            public Collection<Node> nodes() {
                Node[] arr = Keys.this.createNodes(this.getKey());
                if (arr == null) {
                    return Collections.emptyList();
                }
                return new LinkedList<Node>(Arrays.asList(arr));
            }

            public String toString() {
                String s = this.getKey().toString();
                if (s.length() > 80) {
                    s = s.substring(0, 80);
                }
                return "Children.Keys.KE[" + s + "," + this.getCnt() + "]";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Map<T>
    extends Children {
        protected java.util.Map<T, Node> nodes;

        protected Map(java.util.Map<T, Node> m) {
            this.nodes = m;
        }

        public Map() {
        }

        final java.util.Map<T, Node> getMap() {
            if (this.nodes == null) {
                this.nodes = this.initMap();
            }
            return this.nodes;
        }

        @Override
        final void callAddNotify() {
            this.setEntries(this.createEntries(this.getMap()));
            super.callAddNotify();
        }

        Collection<? extends Entry> createEntries(java.util.Map<T, Node> map) {
            LinkedList<ME> l = new LinkedList<ME>();
            for (Map.Entry<T, Node> e : map.entrySet()) {
                l.add(new ME(e.getKey(), e.getValue()));
            }
            return l;
        }

        final void refreshImpl() {
            this.setEntries(this.createEntries(this.getMap()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void refresh() {
            try {
                PR.enterWriteAccess();
                this.refreshImpl();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        final void refreshKeyImpl(T key) {
            this.refreshEntry(new ME(key, null));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void refreshKey(T key) {
            try {
                PR.enterWriteAccess();
                this.refreshKeyImpl(key);
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void putAll(java.util.Map<? extends T, ? extends Node> map) {
            try {
                PR.enterWriteAccess();
                this.nodes.putAll(map);
                this.refreshImpl();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void put(T key, Node node) {
            try {
                PR.enterWriteAccess();
                if (this.nodes.put(key, node) != null) {
                    this.refreshKeyImpl(key);
                } else {
                    this.refreshImpl();
                }
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void removeAll(Collection<? extends T> keys) {
            try {
                PR.enterWriteAccess();
                this.nodes.keySet().removeAll(keys);
                this.refreshImpl();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void remove(T key) {
            try {
                PR.enterWriteAccess();
                if (this.nodes.remove(key) != null) {
                    this.refreshImpl();
                }
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        protected java.util.Map<T, Node> initMap() {
            return new HashMap(7);
        }

        @Override
        public boolean add(Node[] arr) {
            return false;
        }

        @Override
        public boolean remove(Node[] arr) {
            return false;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class ME
        implements Entry {
            public Object key;
            public Node node;

            public ME(Object key, Node node) {
                this.key = key;
                this.node = node;
            }

            @Override
            public Collection<Node> nodes() {
                return Collections.singleton(this.node);
            }

            public int hashCode() {
                return this.key.hashCode();
            }

            public boolean equals(Object o) {
                if (o instanceof ME) {
                    ME me = (ME)o;
                    return this.key.equals(me.key);
                }
                return false;
            }

            public String toString() {
                return "Key (" + this.key + ")";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortedArray
    extends Array {
        private Comparator<? super Node> comp;

        public SortedArray() {
        }

        protected SortedArray(Collection<Node> c) {
            super(c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setComparator(Comparator<? super Node> c) {
            try {
                PR.enterWriteAccess();
                this.comp = c;
                this.refresh();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        public Comparator<? super Node> getComparator() {
            return this.comp;
        }

        @Override
        Entry createNodesEntry() {
            return new SAE();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class SAE
        implements Entry {
            @Override
            public Collection<Node> nodes() {
                ArrayList<Node> al = new ArrayList<Node>(SortedArray.this.getCollection());
                Collections.sort(al, SortedArray.this.comp);
                return al;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortedMap<T>
    extends Map<T> {
        private Comparator<? super Node> comp;

        public SortedMap() {
        }

        protected SortedMap(java.util.Map<T, Node> map) {
            super(map);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setComparator(Comparator<? super Node> c) {
            try {
                PR.enterWriteAccess();
                this.comp = c;
                this.refresh();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        public Comparator<? super Node> getComparator() {
            return this.comp;
        }

        @Override
        Collection<? extends Entry> createEntries(java.util.Map<T, Node> map) {
            TreeSet<Map.ME> l = new TreeSet<Map.ME>(new SMComparator());
            for (Map.Entry<T, Node> e : map.entrySet()) {
                l.add(new Map.ME(e.getKey(), e.getValue()));
            }
            return l;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class SMComparator
        implements Comparator<Map.ME> {
            SMComparator() {
            }

            @Override
            public int compare(Map.ME me1, Map.ME me2) {
                Comparator c = SortedMap.this.comp;
                if (c == null) {
                    int r = ((Comparable)me1.key).compareTo(me2.key);
                    return r;
                }
                return c.compare(me1.node, me2.node);
            }
        }
    }
}

