/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NodeLookup
extends AbstractLookup {
    static final ThreadLocal<Node> NO_COOKIE_CHANGE = new ThreadLocal();
    private Collection<Class> queriedCookieClasses = new ArrayList<Class>();
    private Node node;

    public NodeLookup(Node n) {
        this.node = n;
        this.addPair(new LookupItem(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCookie(Node node, Class<?> c, Collection<AbstractLookup.Pair> collection, Map<AbstractLookup.Pair, Class> fromPairToClass) {
        Collection<AbstractLookup.Pair> pairs;
        Object res;
        Object prev = CookieSet.entryQueryMode(c);
        try {
            Class<?> fake = c;
            res = node.getCookie(fake);
        }
        finally {
            pairs = CookieSet.exitQueryMode(prev);
        }
        if (pairs == null) {
            if (res == null) {
                return;
            }
            pairs = Collections.singleton(new LookupItem(res));
        }
        collection.addAll(pairs);
        for (AbstractLookup.Pair p : pairs) {
            Class oldClazz = fromPairToClass.get(p);
            if (oldClazz != null && !c.isAssignableFrom(oldClazz)) continue;
            fromPairToClass.put(p, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void beforeLookup(Lookup.Template template) {
        Class type = template.getType();
        if (type == Object.class) {
            Set all;
            Object prev = null;
            try {
                prev = CookieSet.entryAllClassesMode();
                Node.Cookie ignoreResult = this.node.getCookie(Node.Cookie.class);
            }
            finally {
                all = CookieSet.exitAllClassesMode(prev);
            }
            for (Class c : all) {
                this.updateLookupAsCookiesAreChanged(c);
            }
            if (!this.queriedCookieClasses.contains(Node.Cookie.class)) {
                this.updateLookupAsCookiesAreChanged(Node.Cookie.class);
            }
        }
        if (!this.queriedCookieClasses.contains(type)) {
            this.updateLookupAsCookiesAreChanged(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLookupAsCookiesAreChanged(Class toAdd) {
        LinkedHashMap<AbstractLookup.Pair, Class> fromPairToQueryClass;
        LinkedHashSet<AbstractLookup.Pair> instances;
        NodeLookup nodeLookup = this;
        synchronized (nodeLookup) {
            if (toAdd != null) {
                if (this.queriedCookieClasses.contains(toAdd)) {
                    return;
                }
                this.queriedCookieClasses.add(toAdd);
            }
            instances = new LinkedHashSet<AbstractLookup.Pair>(this.queriedCookieClasses.size());
            fromPairToQueryClass = new LinkedHashMap<AbstractLookup.Pair, Class>();
            Iterator<Class> it = new ArrayList<Class>(this.queriedCookieClasses).iterator();
            LookupItem nodePair = new LookupItem(this.node);
            instances.add(nodePair);
            fromPairToQueryClass.put(nodePair, Node.class);
            while (it.hasNext()) {
                Class c = it.next();
                NodeLookup.addCookie(this.node, c, instances, fromPairToQueryClass);
            }
        }
        final LinkedHashMap<AbstractLookup.Pair, Class> m = fromPairToQueryClass;
        ArrayList list = new ArrayList(instances);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Cmp
        implements Comparator<AbstractLookup.Pair> {
            Cmp() {
            }

            @Override
            public int compare(AbstractLookup.Pair p1, AbstractLookup.Pair p2) {
                Class c2;
                Class c1 = (Class)m.get(p1);
                if (c1 == (c2 = (Class)m.get(p2))) {
                    return 0;
                }
                if (c1.isAssignableFrom(c2)) {
                    return -1;
                }
                if (c2.isAssignableFrom(c1)) {
                    return 1;
                }
                if (c1.isAssignableFrom(p2.getType())) {
                    return -1;
                }
                if (c2.isAssignableFrom(p1.getType())) {
                    return 1;
                }
                return 0;
            }
        }
        Collections.sort(list, new Cmp());
        if (toAdd == null) {
            this.setPairs(list);
        } else {
            Node prev = NO_COOKIE_CHANGE.get();
            try {
                NO_COOKIE_CHANGE.set(this.node);
                this.setPairs(list);
            }
            finally {
                NO_COOKIE_CHANGE.set(prev);
            }
        }
    }

    private static class LookupItem
    extends AbstractLookup.Pair {
        private Object instance;

        public LookupItem(Object instance) {
            this.instance = instance;
        }

        public String getDisplayName() {
            return this.getId();
        }

        public String getId() {
            return this.instance.toString();
        }

        public Object getInstance() {
            return this.instance;
        }

        public Class getType() {
            return this.instance.getClass();
        }

        public boolean equals(Object object) {
            if (object instanceof LookupItem) {
                return this.instance == ((LookupItem)((Object)object)).getInstance();
            }
            return false;
        }

        public int hashCode() {
            return this.instance.hashCode();
        }

        protected boolean creatorOf(Object obj) {
            return this.instance == obj;
        }

        protected boolean instanceOf(Class c) {
            return c.isInstance(this.instance);
        }
    }
}

