/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.execution;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.execution.ExecutionEngine;
import org.netbeans.core.execution.TaskThreadGroup;
import org.openide.execution.ExecutorTask;
import org.openide.util.Exceptions;
import org.openide.windows.InputOutput;

final class DefaultSysProcess
extends ExecutorTask {
    static int processCount;
    private final TaskThreadGroup group;
    private boolean destroyed = false;
    private final InputOutput io;
    private final String name;

    public DefaultSysProcess(Runnable run, TaskThreadGroup grp, InputOutput io, String name) {
        super(run);
        this.group = grp;
        this.io = io;
        this.name = name;
    }

    public synchronized void stop() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        try {
            this.group.interrupt();
            this.group.stop();
            this.group.getRunClassThread().waitForEnd();
        }
        catch (InterruptedException e) {
            Logger.getLogger(DefaultSysProcess.class.getName()).log(Level.WARNING, null, e);
        }
        ExecutionEngine.closeGroup(this.group);
        this.group.kill();
        this.notifyFinished();
    }

    public int result() {
        try {
            this.group.waitFor();
        }
        catch (InterruptedException e) {
            return 4;
        }
        this.notifyFinished();
        return 0;
    }

    public InputOutput getInputOutput() {
        return this.io;
    }

    public void run() {
    }

    public String getName() {
        return this.name;
    }

    void destroyThreadGroup(ThreadGroup base) {
        new Thread(base, new Runnable(){

            public void run() {
                try {
                    while (DefaultSysProcess.this.group.activeCount() > 0) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
                if (!DefaultSysProcess.this.group.isDestroyed()) {
                    DefaultSysProcess.this.group.destroy();
                }
            }
        }).start();
    }
}

