/*
 * Decompiled with CFR 0.152.
 */
package org.gjava.actoreditor.beans;

import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import org.gjava.actoreditor.ActorEditorTopComponent;
import org.gjava.actoreditor.Utilz;
import org.gjava.actoreditor.Value;
import org.gjava.actoreditor.events.eventData;

public class EventList
extends JList {
    public DefaultListModel events = new DefaultListModel();
    private static final String REAL_NUMBER = "^[-+]?\\d+(\\.\\d+)?$";
    public ActorEditorTopComponent a;

    public static boolean isNumeric(String string) {
        return string.matches(REAL_NUMBER);
    }

    public EventList(ActorEditorTopComponent aa) {
        this.a = aa;
        this.setDropTarget(new DropTarget(this, new DropTargetListener(){

            public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            }

            public void dragExit(DropTargetEvent dropTargetEvent) {
            }

            public void dragOver(DropTargetDragEvent dtde) {
                if (dtde.isDataFlavorSupported(Utilz.EVENT_DATA_FLAVOR)) {
                    dtde.acceptDrag(3);
                } else {
                    dtde.rejectDrag();
                }
            }

            public void drop(DropTargetDropEvent dtde) {
                if (!dtde.isDataFlavorSupported(Utilz.EVENT_DATA_FLAVOR)) {
                    dtde.rejectDrop();
                }
                dtde.acceptDrop(3);
                eventData data = null;
                try {
                    data = (eventData)dtde.getTransferable().getTransferData(Utilz.EVENT_DATA_FLAVOR);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (UnsupportedFlavorException ex) {
                    ex.printStackTrace();
                }
                dtde.dropComplete(null != data);
                if (null != data) {
                    int idx = EventList.this.locationToIndex(dtde.getLocation());
                    String tempname = data.getDisplayName();
                    if (data.getDisplayName().equals("Alarm Event")) {
                        String alarm = "";
                        while (!EventList.isNumeric(alarm = JOptionPane.showInputDialog("Which alarm event? (Number only)", (Object)"0"))) {
                        }
                        tempname = "Alarm" + alarm + " Event";
                    }
                    boolean dup = false;
                    Enumeration e = EventList.this.events.elements();
                    while (e.hasMoreElements()) {
                        Value v = (Value)e.nextElement();
                        if (!v.value.equals(tempname)) continue;
                        dup = true;
                    }
                    if (!dup) {
                        EventList.this.events.addElement(new Value(tempname, data.img, new DefaultListModel()));
                        EventList.this.a.a.setModified(true);
                    }
                    System.out.println("" + idx);
                }
            }

            public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            }
        }));
        this.setCellRenderer(new SimpleCellRenderer());
        this.initComponents();
        this.setModel(this.events);
    }

    private void initComponents() {
        this.setDragEnabled(true);
    }

    class SimpleCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public SimpleCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Value val = (Value)value;
            this.setText(val.value);
            this.setIcon(val.image);
            this.setBackground(isSelected ? Color.black : ((index & 1) == 0 ? Color.white : Color.LIGHT_GRAY));
            this.setForeground(isSelected ? Color.white : Color.black);
            return this;
        }
    }
}

