/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el;

import com.sun.el.lang.ELSupport;
import com.sun.el.lang.EvaluationContext;
import com.sun.el.lang.ExpressionBuilder;
import com.sun.el.parser.AstLiteralExpression;
import com.sun.el.parser.Node;
import com.sun.el.util.ReflectionUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.Expression;
import javax.el.FunctionMapper;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;

public final class ValueExpressionImpl
extends ValueExpression
implements Externalizable {
    private Class expectedType;
    private String expr;
    private FunctionMapper fnMapper;
    private VariableMapper varMapper;
    private transient Node node;

    public ValueExpressionImpl() {
    }

    public ValueExpressionImpl(String expr, Node node, FunctionMapper fnMapper, VariableMapper varMapper, Class expectedType) {
        this.expr = expr;
        this.node = node;
        this.fnMapper = fnMapper;
        this.varMapper = varMapper;
        this.expectedType = expectedType;
    }

    public boolean equals(Object obj) {
        return obj instanceof ValueExpressionImpl && obj.hashCode() == this.hashCode();
    }

    public Class getExpectedType() {
        return this.expectedType;
    }

    public String getExpressionString() {
        return this.expr;
    }

    private Node getNode() throws ELException {
        if (this.node == null) {
            this.node = ExpressionBuilder.createNode(this.expr);
        }
        return this.node;
    }

    public Class getType(ELContext context) throws PropertyNotFoundException, ELException {
        EvaluationContext ctx = new EvaluationContext(context, this.fnMapper, this.varMapper, this);
        return this.getNode().getType(ctx);
    }

    public Object getValue(ELContext context) throws PropertyNotFoundException, ELException {
        EvaluationContext ctx = new EvaluationContext(context, this.fnMapper, this.varMapper, this);
        Object value = this.getNode().getValue(ctx);
        if (this.expectedType != null) {
            return ELSupport.coerceToType(value, this.expectedType);
        }
        return value;
    }

    public Expression.Result getResult(ELContext context) throws PropertyNotFoundException, ELException {
        EvaluationContext ctx = new EvaluationContext(context, this.fnMapper, this.varMapper, this, true);
        Node node = this.getNode();
        Object value = this.coerce(node.getValue(ctx));
        List<Expression.ResolvedObject> resolvedObjects = ctx.getResolvedObjects();
        if (value != ELContext.INCOMPLETE_PATH_RESULT) {
            List resolvedList = null;
            int listThreshold = 10;
            for (Expression.ResolvedObject resolved : resolvedObjects) {
                if (!(resolved instanceof Expression.ResolvedList)) continue;
                if (resolvedList == null) {
                    resolvedList = ((Expression.ResolvedList)resolved).getSource();
                    continue;
                }
                if (resolvedList == ((Expression.ResolvedList)resolved).getSource()) continue;
                throw new ELException("Expression consists of multiple lists, can only resolve a single list");
            }
            if (resolvedList != null && resolvedList.size() != 1) {
                int listSize = resolvedList.size();
                if (listSize < listThreshold) {
                    ArrayList<Object> values = new ArrayList<Object>(listSize);
                    values.add(value);
                    for (int i = 1; i < listSize; ++i) {
                        ctx.reset();
                        ctx.setResolvingListIndex(i);
                        value = this.coerce(node.getValue(ctx));
                        if (value == ELContext.INCOMPLETE_PATH_RESULT) break;
                        values.add(value);
                    }
                    resolvedObjects = ctx.getResolvedObjects();
                    if (value != ELContext.INCOMPLETE_PATH_RESULT) {
                        return new Expression.Result(Expression.Result.Type.MULTI_LIST_VALUE, values, resolvedObjects);
                    }
                    return new Expression.Result(Expression.Result.Type.INCOMPLETE_PATH, values, resolvedObjects);
                }
                return new Expression.Result(Expression.Result.Type.CAPPED_MULTI_LIST_VALUE, Arrays.asList(value), resolvedObjects);
            }
            return new Expression.Result(Expression.Result.Type.SINGLE_VALUE, value, resolvedObjects);
        }
        return new Expression.Result(Expression.Result.Type.INCOMPLETE_PATH, null, resolvedObjects);
    }

    private Object coerce(Object value) {
        if (this.expectedType != null && value != ELContext.INCOMPLETE_PATH_RESULT) {
            return ELSupport.coerceToType(value, this.expectedType);
        }
        return value;
    }

    public int hashCode() {
        return this.expr.hashCode();
    }

    public boolean isLiteralText() {
        try {
            return this.getNode() instanceof AstLiteralExpression;
        }
        catch (ELException ele) {
            return false;
        }
    }

    public boolean isReadOnly(ELContext context) throws PropertyNotFoundException, ELException {
        EvaluationContext ctx = new EvaluationContext(context, this.fnMapper, this.varMapper, this);
        return this.getNode().isReadOnly(ctx);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.expr = in.readUTF();
        String type = in.readUTF();
        if (!"".equals(type)) {
            this.expectedType = ReflectionUtil.forName(type);
        }
        this.fnMapper = (FunctionMapper)in.readObject();
        this.varMapper = (VariableMapper)in.readObject();
    }

    public void setValue(ELContext context, Object value) throws PropertyNotFoundException, PropertyNotWritableException, ELException {
        EvaluationContext ctx = new EvaluationContext(context, this.fnMapper, this.varMapper, this, true);
        this.getNode().setValue(ctx, value);
        List<Expression.ResolvedObject> resolvedObjects = ctx.getResolvedObjects();
        List resolvedList = null;
        int listThreshold = 10;
        for (Expression.ResolvedObject resolved : resolvedObjects) {
            if (!(resolved instanceof Expression.ResolvedList)) continue;
            if (resolvedList == null) {
                resolvedList = ((Expression.ResolvedList)resolved).getSource();
                continue;
            }
            if (resolvedList == ((Expression.ResolvedList)resolved).getSource()) continue;
            throw new ELException("Expression consists of multiple lists, can only resolve a single list");
        }
        if (resolvedList != null && resolvedList.size() != 1) {
            int listSize = resolvedList.size();
            for (int i = 1; i < listSize; ++i) {
                ctx.reset();
                ctx.setResolvingListIndex(i);
                this.getNode().setValue(ctx, value);
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.expr);
        out.writeUTF(this.expectedType != null ? this.expectedType.getName() : "");
        out.writeObject(this.fnMapper);
        out.writeObject(this.varMapper);
    }

    public String toString() {
        return "ValueExpression[" + this.expr + "]";
    }
}

