/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el.lang;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.Expression;
import javax.el.FunctionMapper;
import javax.el.VariableMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EvaluationContext
extends ELContext {
    private final ELContext elContext;
    private final FunctionMapper fnMapper;
    private final VariableMapper varMapper;
    private final Expression expression;
    private final Set<Expression.ResolvedObject> resolvedObjects;
    public int listIndex;
    private boolean incompletePath;

    public EvaluationContext(ELContext elContext, FunctionMapper fnMapper, VariableMapper varMapper, Expression expression) {
        this(elContext, fnMapper, varMapper, expression, false);
    }

    public EvaluationContext(ELContext elContext, FunctionMapper fnMapper, VariableMapper varMapper, Expression expression, boolean trackResolvedObjects) {
        this.elContext = elContext;
        this.fnMapper = fnMapper;
        this.varMapper = varMapper;
        this.expression = expression;
        LinkedHashSet<Expression.ResolvedObject> resolvedObjects = trackResolvedObjects ? new LinkedHashSet<Expression.ResolvedObject>(1) : null;
        this.resolvedObjects = resolvedObjects;
        this.listIndex = 0;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public ELContext getELContext() {
        return this.elContext;
    }

    @Override
    public FunctionMapper getFunctionMapper() {
        return this.fnMapper;
    }

    @Override
    public VariableMapper getVariableMapper() {
        return this.varMapper;
    }

    @Override
    public Object getContext(Class key) {
        return this.elContext.getContext(key);
    }

    @Override
    public ELResolver getELResolver() {
        return this.elContext.getELResolver();
    }

    @Override
    public boolean isPropertyResolved() {
        return this.elContext.isPropertyResolved();
    }

    @Override
    public void putContext(Class key, Object contextObject) {
        this.elContext.putContext(key, contextObject);
    }

    @Override
    public void setPropertyResolved(boolean resolved) {
        this.elContext.setPropertyResolved(resolved);
    }

    public void setIncompletePath(boolean incompletePath) {
        this.incompletePath = incompletePath;
    }

    public boolean getIncompletePath() {
        return this.incompletePath;
    }

    public void resolvingList(List list) {
        if (this.resolvedObjects != null) {
            this.resolvedObjects.add(new Expression.ResolvedList(list));
        }
    }

    public void resolvingProperty(Object base, Object property) {
        if (this.resolvedObjects != null) {
            this.resolvedObjects.add(new Expression.ResolvedProperty(base, property));
        }
    }

    public List<Expression.ResolvedObject> getResolvedObjects() {
        if (this.resolvedObjects != null) {
            return new ArrayList<Expression.ResolvedObject>(this.resolvedObjects);
        }
        return null;
    }

    public void setResolvingListIndex(int listIndex) {
        this.listIndex = listIndex;
    }

    public int getResolvingListIndex() {
        return this.listIndex;
    }

    public void reset() {
        this.listIndex = 0;
        this.incompletePath = false;
    }
}

