/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el.parser;

import com.sun.el.lang.EvaluationContext;
import com.sun.el.parser.SimpleNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.el.ELContext;
import javax.el.ELException;

public final class AstNegative
extends SimpleNode {
    public AstNegative(int id) {
        super(id);
    }

    public Class getType(EvaluationContext ctx) throws ELException {
        return Number.class;
    }

    public Object getValue(EvaluationContext ctx) throws ELException {
        Object obj = this.children[0].getValue(ctx);
        if (obj == ELContext.INCOMPLETE_PATH_RESULT) {
            return ELContext.INCOMPLETE_PATH_RESULT;
        }
        if (obj == null) {
            return new Long(0L);
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).negate();
        }
        if (obj instanceof BigInteger) {
            return ((BigInteger)obj).negate();
        }
        if (obj instanceof String) {
            if (AstNegative.isStringFloat((String)obj)) {
                return new Double(-Double.parseDouble((String)obj));
            }
            return new Long(-Long.parseLong((String)obj));
        }
        Class<?> type = obj.getClass();
        if (obj instanceof Long || Long.TYPE == type) {
            return new Long(-((Long)obj).longValue());
        }
        if (obj instanceof Double || Double.TYPE == type) {
            return new Double(-((Double)obj).doubleValue());
        }
        if (obj instanceof Integer || Integer.TYPE == type) {
            return new Integer(-((Integer)obj).intValue());
        }
        if (obj instanceof Float || Float.TYPE == type) {
            return new Float(-((Float)obj).floatValue());
        }
        if (obj instanceof Short || Short.TYPE == type) {
            return new Short(-((Short)obj).shortValue());
        }
        if (obj instanceof Byte || Byte.TYPE == type) {
            return new Byte(-((Byte)obj).byteValue());
        }
        Long num = (Long)AstNegative.coerceToNumber(obj, Long.class);
        return new Long(-num.longValue());
    }
}

