/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.binding;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.beans.binding.Binding;
import javax.beans.binding.ext.BindingTarget;
import javax.beans.binding.ext.BindingTargetProvider;
import javax.swing.binding.SwingBindingSupport;

abstract class AbstractBindingHelper
implements BindingTarget {
    static final String ELEMENTS_P = "elements";
    static final String SELECTED_ELEMENTS_P = "selectedElements";
    static final String SELECTED_ELEMENT_P = "selectedElement";
    static final String JCHECK_BOX_SELECTED_P = "selected";
    static final String JCOMBO_BOX_SELECTED_ELEMENT_P = "selectedElementProperty";
    static final String JTEXT_COMPONENT_TEXT_P = "text";
    static final String JTREE_ROOT_P = "root";
    static final String VALUE_P = "value";

    AbstractBindingHelper() {
    }

    public abstract Object getPropertyDelegate();

    protected boolean shouldCreateBindingTarget(String property) {
        return false;
    }

    public void bind(Binding.BindingController controller, String property) {
    }

    public void unbind(Binding.BindingController controller, String property) {
    }

    public void sourceValueStateChanged(Binding.BindingController controller, String property) {
    }

    protected void throwIfNonNull(Binding.BindingController controller) {
        if (controller != null) {
            throw new IllegalStateException("Can not bind to an already bound component");
        }
    }

    protected Binding getBinding() {
        return null;
    }

    protected Component getComponent() {
        return null;
    }

    protected void updateComponentEnabledFromBinding() {
        if (this.getDisableOnIncompletePath()) {
            if (this.getBinding().getSourceValueState() == Binding.ValueState.INCOMPLETE_PATH) {
                this.setComponentEnabled(false);
            } else {
                this.setComponentEnabled(true);
            }
        }
    }

    protected void setComponentEnabled(boolean enable) {
        this.getComponent().setEnabled(enable);
    }

    protected boolean getDisableOnIncompletePath() {
        return this.getBinding().getValue(SwingBindingSupport.DisableOnIncompletePathParameter, Boolean.TRUE);
    }

    public abstract class DelegateBase
    implements BindingTargetProvider {
        private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

        public BindingTarget createBindingTarget(String property) {
            if (AbstractBindingHelper.this.shouldCreateBindingTarget(property)) {
                return AbstractBindingHelper.this;
            }
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.changeSupport.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.changeSupport.removePropertyChangeListener(l);
        }

        public void addPropertyChangeListener(String key, PropertyChangeListener l) {
            this.changeSupport.addPropertyChangeListener(key, l);
        }

        public void removePropertyChangeListener(String key, PropertyChangeListener l) {
            this.changeSupport.removePropertyChangeListener(key, l);
        }

        protected void firePropertyChange(String key, Object oldValue, Object newValue) {
            this.changeSupport.firePropertyChange(key, oldValue, newValue);
        }
    }
}

