/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.binding;

import com.sun.java.swing.binding.AbstractBindingHelper;
import com.sun.java.swing.binding.BindingBeanInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.beans.binding.Binding;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractListTableBindingSupport
extends AbstractBindingHelper
implements ListSelectionListener,
PropertyChangeListener {
    private List<Object> selectedElements;

    @Override
    public void bind(Binding.BindingController controller, String property) {
        if (property == "elements") {
            this.bindElements(controller);
        }
    }

    @Override
    public void unbind(Binding.BindingController controller, String property) {
        if (property == "elements") {
            this.unbindElements();
        }
    }

    protected abstract void bindElements(Binding.BindingController var1);

    protected abstract void unbindElements();

    @Override
    protected boolean shouldCreateBindingTarget(String property) {
        return property == "elements" || property == "selectedElements";
    }

    private void updateSelectedElements() {
        ListSelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel != null) {
            ArrayList<Object> newSelection;
            int min = selectionModel.getMinSelectionIndex();
            int max = selectionModel.getMaxSelectionIndex();
            if (min < 0 || max < 0) {
                newSelection = new ArrayList<Object>(0);
            } else {
                min = Math.min(this.getElements().size() - 1, min);
                max = Math.min(this.getElements().size() - 1, max);
                newSelection = new ArrayList(max - min);
                for (int i = min; i <= max; ++i) {
                    if (!selectionModel.isSelectedIndex(i)) continue;
                    newSelection.add(this.getElement(i));
                }
            }
            this.selectedElements = newSelection;
        } else {
            this.selectedElements = new ArrayList<Object>(0);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == "selectionModel") {
            this.selectionModelChanged((ListSelectionModel)e.getOldValue(), (ListSelectionModel)e.getNewValue());
        }
    }

    protected void selectionModelChanged(ListSelectionModel oldModel, ListSelectionModel newModel) {
        oldModel.removeListSelectionListener(this);
        newModel.addListSelectionListener(this);
    }

    protected void selectionChanged() {
        List<Object> oldSelection = this.selectedElements;
        this.selectedElements = null;
        this.getDelegate().firePropertyChange("selectedElements", oldSelection, this.selectedElements);
        this.getDelegate().firePropertyChange("selectedElement", null, null);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.selectionChanged();
        }
    }

    protected Object getElement(int i) {
        return this.getElements().get(i);
    }

    protected abstract void setElements(List<?> var1);

    protected abstract List<?> getElements();

    protected void setSelectedElements(List<?> selection) {
        ArrayList<Object> newSelection;
        List<Object> oldSelection = this.selectedElements;
        ListSelectionModel selectionModel = this.getSelectionModel();
        if (selection == null) {
            newSelection = new ArrayList(0);
            selectionModel.clearSelection();
        } else {
            newSelection = new ArrayList(selection);
            selectionModel.setValueIsAdjusting(true);
            selectionModel.clearSelection();
            for (Object e : newSelection) {
                int index = this.getElements().indexOf(e);
                if (index == -1) continue;
                selectionModel.addSelectionInterval(index, index);
            }
            selectionModel.setValueIsAdjusting(false);
        }
        this.selectedElements = newSelection;
        this.getDelegate().firePropertyChange("selectedElements", oldSelection, newSelection);
        this.getDelegate().firePropertyChange("selectedElement", null, null);
    }

    protected abstract ListSelectionModel getSelectionModel();

    protected abstract PropertyDelegate getDelegate();

    protected List<?> getSelectedElements() {
        if (this.selectedElements == null) {
            this.updateSelectedElements();
        }
        return this.selectedElements;
    }

    protected abstract Object getSelectedElement();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class PropertyDelegate
    extends AbstractBindingHelper.DelegateBase {
        public void setElements(List<?> elements) {
            AbstractListTableBindingSupport.this.setElements(elements);
        }

        public List<?> getElements() {
            return AbstractListTableBindingSupport.this.getElements();
        }

        public void setSelectedElements(List<?> elements) {
            AbstractListTableBindingSupport.this.setSelectedElements(elements);
        }

        public List<?> getSelectedElements() {
            return AbstractListTableBindingSupport.this.getSelectedElements();
        }

        public void setSelectedElement(Object element) {
            if (element == null) {
                AbstractListTableBindingSupport.this.setSelectedElements(Collections.emptyList());
            } else {
                AbstractListTableBindingSupport.this.setSelectedElements(Arrays.asList(element));
            }
        }

        public Object getSelectedElement() {
            return AbstractListTableBindingSupport.this.getSelectedElement();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PropertyDelegateBeanInfo
    extends BindingBeanInfo {
        @Override
        protected Class<?> getPropertyDelegateClass() {
            return PropertyDelegate.class;
        }

        @Override
        protected BindingBeanInfo.Property[] getPreferredProperties() {
            return new BindingBeanInfo.Property[]{new BindingBeanInfo.Property("elements", "The contents to display"), new BindingBeanInfo.Property("selectedElement", "The selected element"), new BindingBeanInfo.Property("selectedElements", "The selected elements")};
        }
    }
}

