/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.binding;

import com.sun.java.swing.binding.AbstractBindingHelper;
import com.sun.java.swing.binding.BindingBeanInfo;
import com.sun.java.swing.binding.ListBindingManager;
import java.awt.Component;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.beans.binding.Binding;
import javax.beans.binding.ELPropertyResolver;
import javax.el.Expression;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.binding.SwingBindingSupport;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JComboBoxBindingHelper
extends AbstractBindingHelper {
    private final JComboBox comboBox;
    private final PropertyDelegate delegate;
    private BindingModel model;
    private Binding.BindingController controller;
    private Binding valueBinding;
    private Binding.BindingController selectedElementController;
    private ELPropertyResolver selectedElementResolver;

    public JComboBoxBindingHelper(JComboBox comboBox) {
        this.comboBox = comboBox;
        this.delegate = new PropertyDelegate();
    }

    @Override
    public Object getPropertyDelegate() {
        return this.delegate;
    }

    @Override
    protected boolean shouldCreateBindingTarget(String property) {
        return property == "elements" || property == "selectedElementProperty";
    }

    @Override
    public void bind(Binding.BindingController controller, String property) {
        if (property == "elements") {
            this.throwIfNonNull(this.controller);
            this.controller = controller;
            String selectedElementPath = controller.getBinding().getValue(SwingBindingSupport.ComboBoxSelectedObjectPropertyParameter, null);
            if (selectedElementPath != null) {
                this.selectedElementResolver = controller.createResolver();
                this.selectedElementResolver.setPath(selectedElementPath);
            } else {
                this.selectedElementResolver = null;
            }
            this.model = new BindingModel(controller);
            this.comboBox.setModel(this.model);
        } else if (property == "selectedElementProperty") {
            this.throwIfNonNull(this.selectedElementController);
            this.selectedElementController = controller;
            this.updateComponentEnabledFromBinding();
        }
    }

    @Override
    public void unbind(Binding.BindingController controller, String property) {
        if (property == "elements") {
            this.controller = null;
            if (this.comboBox.getModel() == this.model) {
                this.comboBox.setModel(new DefaultComboBoxModel());
            }
            this.valueBinding = null;
            this.model.setElements(null);
            this.model = null;
        } else if (property == "selectedElementProperty") {
            this.selectedElementController = null;
        }
    }

    @Override
    public void sourceValueStateChanged(Binding.BindingController controller, String property) {
        if (property == "selectedElementProperty") {
            this.updateComponentEnabledFromBinding();
        }
    }

    protected void setElements(List<?> elements) {
        this.model.setElements(elements);
        if (this.comboBox.getModel() != this.model) {
            this.comboBox.setModel(this.model);
        }
    }

    protected List<?> getElements() {
        return this.model.getElements();
    }

    @Override
    protected Binding getBinding() {
        return this.selectedElementController.getBinding();
    }

    @Override
    protected Component getComponent() {
        return this.comboBox;
    }

    private boolean areObjectsEqual(Object o1, Object o2) {
        return o1 != null && o1.equals(o2) || o1 == null && o2 == null;
    }

    private void setSelectedElement(Object toSelect) {
        List<?> elements = this.model.getElements();
        for (int i = elements.size() - 1; i >= 0; --i) {
            Object e = elements.get(i);
            if (!this.areObjectsEqual(e, toSelect)) continue;
            this.model.setSelectedItem(this.model.valueAt(i, 0, true));
            return;
        }
        this.model.setSelectedItem(null);
    }

    private Object getSelectedElement() {
        Object selected = this.model.getSelectedItem();
        for (int i = this.model.size() - 1; i >= 0; --i) {
            if (!this.areObjectsEqual(this.model.valueAt(i, 0, true), selected)) continue;
            return this.model.getElements().get(i);
        }
        return null;
    }

    private void setSelectedElementProperty(Object id) {
        if (this.selectedElementResolver != null) {
            for (int i = 0; i < this.model.getSize(); ++i) {
                Object element = this.model.getElement(i);
                this.selectedElementResolver.setSource(element);
                Expression.Result result = this.selectedElementResolver.evaluate();
                if (result.getType() != Expression.Result.Type.SINGLE_VALUE || !this.areObjectsEqual(result.getResult(), id)) continue;
                this.model.setSelectedItem(this.model.valueAt(i, 0, true));
                return;
            }
        }
        this.model.setSelectedItem(null);
    }

    private Object getSelectedElementProperty() {
        if (this.selectedElementResolver != null) {
            Object selected = this.model.getSelectedItem();
            for (int i = this.model.getSize() - 1; i >= 0; --i) {
                Object value = this.model.valueAt(i, 0, true);
                if (!this.areObjectsEqual(value, selected)) continue;
                this.selectedElementResolver.setSource(this.model.getElement(i));
                Expression.Result result = this.selectedElementResolver.evaluate();
                if (result.getType() != Expression.Result.Type.SINGLE_VALUE) continue;
                return result.getResult();
            }
        }
        return null;
    }

    private void selectionChanged() {
        this.delegate.firePropertyChange("selectedElement", null, null);
        this.delegate.firePropertyChange("selectedElementProperty", null, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BindingModel
    extends ListBindingManager
    implements ComboBoxModel {
        private final List<ListDataListener> listeners;
        private Object selectedObject;

        BindingModel(Binding.BindingController controller) {
            super(controller);
            this.listeners = new CopyOnWriteArrayList<ListDataListener>();
        }

        @Override
        protected void createColumnDescriptions(List<ListBindingManager.ColumnDescription> columns) {
            JComboBoxBindingHelper.this.valueBinding = null;
            for (Binding childBinding : this.getController().getBinding().getBindings()) {
                JComboBoxBindingHelper.this.valueBinding = childBinding;
                columns.add(new ListBindingManager.ColumnDescription(this, childBinding, 0, true, Object.class));
            }
        }

        @Override
        protected void allChanged() {
            this.contentsChanged(0, this.size());
        }

        @Override
        protected void valueChanged(int row, int column) {
            this.contentsChanged(row, row);
        }

        @Override
        protected void added(int index, int length) {
            ListDataEvent e = new ListDataEvent(this, 1, index, index + length - 1);
            for (ListDataListener listener : this.listeners) {
                listener.intervalAdded(e);
            }
        }

        @Override
        protected void removed(int index, int length) {
            ListDataEvent e = new ListDataEvent(this, 2, index, index + length - 1);
            for (ListDataListener listener : this.listeners) {
                listener.intervalRemoved(e);
            }
        }

        @Override
        protected void changed(int row) {
            this.contentsChanged(row, row);
        }

        @Override
        public int getSize() {
            return this.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.valueAt(index, 0, true);
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (this.selectedObject != null && !this.selectedObject.equals(anObject) || this.selectedObject == null && anObject != null) {
                this.selectedObject = anObject;
                this.contentsChanged(-1, -1);
                JComboBoxBindingHelper.this.selectionChanged();
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedObject;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        private void contentsChanged(int row0, int row1) {
            ListDataEvent e = new ListDataEvent(this, 0, row0, row1);
            for (ListDataListener listener : this.listeners) {
                listener.contentsChanged(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class PropertyDelegate
    extends AbstractBindingHelper.DelegateBase {
        public void setElements(List<?> elements) {
            JComboBoxBindingHelper.this.setElements(elements);
        }

        public List<?> getElements() {
            return JComboBoxBindingHelper.this.getElements();
        }

        public void setSelectedElement(Object element) {
            JComboBoxBindingHelper.this.setSelectedElement(element);
        }

        public Object getSelectedElement() {
            return JComboBoxBindingHelper.this.getSelectedElement();
        }

        public void setSelectedElementProperty(Object id) {
            JComboBoxBindingHelper.this.setSelectedElementProperty(id);
        }

        public Object getSelectedElementProperty() {
            return JComboBoxBindingHelper.this.getSelectedElementProperty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PropertyDelegateBeanInfo
    extends BindingBeanInfo {
        @Override
        protected Class<?> getPropertyDelegateClass() {
            return PropertyDelegate.class;
        }

        @Override
        protected BindingBeanInfo.Property[] getPreferredProperties() {
            return new BindingBeanInfo.Property[]{new BindingBeanInfo.Property("elements", "The conents of the combobox"), new BindingBeanInfo.Property("selectedElement", "The selected element of the combobox"), new BindingBeanInfo.Property("selectedElementProperty", "PENDING: nuke this!")};
        }
    }
}

