/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.binding;

import com.sun.java.swing.binding.AbstractBindingHelper;
import com.sun.java.swing.binding.BindingBeanInfo;
import java.awt.Component;
import javax.beans.binding.Binding;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class JSliderBindingHelper
extends AbstractBindingHelper {
    private static final String VALUE_PROPERTY = "value";
    private final JSlider slider;
    private final PropertyDelegate delegate;
    private Object value;
    private Binding.BindingController controller;
    private final ChangeListener handler;

    public JSliderBindingHelper(JSlider slider) {
        this.slider = slider;
        this.delegate = new PropertyDelegate();
        this.handler = new ChangeHandler();
    }

    public Object getPropertyDelegate() {
        return this.delegate;
    }

    private void setValue(int value) {
        this.slider.setValue(value);
    }

    private int getValue() {
        return this.slider.getValue();
    }

    private void sliderValueChanged() {
        Object lastValue = this.value;
        this.value = this.slider.getValue();
        this.delegate.firePropertyChange(VALUE_PROPERTY, lastValue, this.value);
    }

    protected boolean shouldCreateBindingTarget(String property) {
        return property == VALUE_PROPERTY;
    }

    public void bind(Binding.BindingController controller, String property) {
        this.throwIfNonNull(this.controller);
        assert (property == VALUE_PROPERTY);
        this.value = this.slider.getValue();
        this.slider.addChangeListener(this.handler);
        this.controller = controller;
        this.updateComponentEnabledFromBinding();
    }

    public void unbind(Binding.BindingController controller, String property) {
        this.slider.removeChangeListener(this.handler);
        this.controller = null;
    }

    public void sourceValueStateChanged(Binding.BindingController controller, String property) {
        this.updateComponentEnabledFromBinding();
    }

    protected Component getComponent() {
        return this.slider;
    }

    protected Binding getBinding() {
        return this.controller.getBinding();
    }

    private final class ChangeHandler
    implements ChangeListener {
        private ChangeHandler() {
        }

        public void stateChanged(ChangeEvent e) {
            JSliderBindingHelper.this.sliderValueChanged();
        }
    }

    public final class PropertyDelegate
    extends AbstractBindingHelper.DelegateBase {
        public void setValue(int value) {
            JSliderBindingHelper.this.setValue(value);
        }

        public int getValue() {
            return JSliderBindingHelper.this.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PropertyDelegateBeanInfo
    extends BindingBeanInfo {
        @Override
        protected Class<?> getPropertyDelegateClass() {
            return PropertyDelegate.class;
        }

        @Override
        protected BindingBeanInfo.Property[] getPreferredProperties() {
            return new BindingBeanInfo.Property[]{new BindingBeanInfo.Property(JSliderBindingHelper.VALUE_PROPERTY, "The sliders current value")};
        }
    }
}

