/*
 * Decompiled with CFR 0.152.
 */
package javax.beans.binding;

import com.sun.el.lang.FunctionMapperImpl;
import com.sun.el.lang.VariableMapperImpl;
import com.sun.java.beans.binding.BindingFunctions;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.beans.binding.Binding;
import javax.beans.binding.BindingListener;
import javax.beans.binding.BindingValidator;
import javax.beans.binding.ValidationResult;
import javax.beans.binding.ext.PropertyDelegateFactory;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.MapELResolver;
import javax.el.VariableMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingContext {
    private final List<Binding> bound;
    private final List<Binding> unbound;
    private final PropertyChangeSupport changeSupport;
    private final List<BindingListener> bindingListeners;
    private boolean uncommittedValues;
    private boolean invalidValues;
    private boolean hasEditedTargetValues;
    private final List<ELResolver> resolvers;
    private final BindingFunctionMapper functionMapper;
    private ELContext context;

    public BindingContext() {
        block4: {
            this.changeSupport = new PropertyChangeSupport(this);
            this.unbound = new LinkedList<Binding>();
            this.bound = new ArrayList<Binding>();
            this.bindingListeners = new CopyOnWriteArrayList<BindingListener>();
            this.resolvers = new ArrayList<ELResolver>(3);
            this.resolvers.add(new MapELResolver());
            this.resolvers.add(new PropertyDelegateResolver());
            this.functionMapper = new BindingFunctionMapper();
            try {
                this.functionMapper.addFunction("bb", "listSize", BindingFunctions.class.getDeclaredMethod("listSize", List.class));
            }
            catch (SecurityException ex) {
                assert (false);
            }
            catch (NoSuchMethodException ex) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    void targetEdited(Binding binding) {
        this.setHasEditedTargetValues(true);
    }

    private void setHasEditedTargetValues(boolean value) {
        if (this.hasEditedTargetValues != value) {
            this.hasEditedTargetValues = value;
            this.changeSupport.firePropertyChange("hasEditedTargetValues", !value, value);
        }
    }

    public void clearHasEditedTargetValues() {
        this.setHasEditedTargetValues(false);
    }

    public boolean getHasEditedTargetValues() {
        return this.hasEditedTargetValues;
    }

    public void addBinding(Binding binding) {
        if (binding == null) {
            throw new IllegalArgumentException("Binding must be non-null");
        }
        if (binding.isBound()) {
            throw new IllegalStateException("Can not add bound Binding");
        }
        if (binding.getContext() != null) {
            throw new IllegalStateException("Can not add Binding to two different BindingContexts");
        }
        this.unbound.add(binding);
        binding.setContext(this);
    }

    public Binding addBinding(Object source, String sourcePath, Object target, String targetPath, Object ... args) {
        Binding binding = new Binding(source, sourcePath, target, targetPath, args);
        this.addBinding(binding);
        return binding;
    }

    public void removeBinding(Binding binding) {
        if (binding.isBound()) {
            throw new IllegalStateException("Must unbind before removing");
        }
        if (!this.unbound.contains(binding)) {
            throw new IllegalStateException("Unknown Binding");
        }
        binding.setContext(null);
        this.unbound.remove(binding);
    }

    public void bind() {
        ArrayList<Binding> toBind = new ArrayList<Binding>(this.unbound);
        for (Binding binding : toBind) {
            binding.throwIfBound();
        }
        this.unbound.clear();
        for (Binding binding : toBind) {
            binding.bind();
        }
    }

    public void unbind() {
        ArrayList<Binding> toUnbind = new ArrayList<Binding>(this.bound);
        this.bound.clear();
        for (Binding binding : toUnbind) {
            binding.unbind();
        }
    }

    public void addBindingListener(BindingListener listener) {
        this.bindingListeners.add(listener);
    }

    public void removeBindingListener(BindingListener listener) {
        this.bindingListeners.remove(listener);
    }

    public BindingValidator getValidator(Binding binding) {
        if (binding == null) {
            throw new NullPointerException();
        }
        return null;
    }

    void notifyValidationListeners(Binding binding, ValidationResult validationResult) {
        for (BindingListener l : this.bindingListeners) {
            l.validationFailed(binding, validationResult);
        }
    }

    public void commitUncommittedValues() {
        ArrayList<Binding> bindings = new ArrayList<Binding>(this.bound);
        for (Binding binding : bindings) {
            this.commitUncommittedValues(binding);
            List<Binding> childBindings = binding.getBindings();
            for (Binding childBinding : childBindings) {
                this.commitUncommittedValues(childBinding);
            }
        }
    }

    private void commitUncommittedValues(Binding binding) {
        if (binding.getTargetValueState() == Binding.ValueState.UNCOMMITTED) {
            binding.setSourceValueFromTargetValue();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(property, listener);
    }

    private void setHasUncommittedValues(boolean uncommittedValues) {
        if (uncommittedValues != this.uncommittedValues) {
            this.uncommittedValues = uncommittedValues;
            this.changeSupport.firePropertyChange("hasUncommittedValues", !uncommittedValues, uncommittedValues);
        }
    }

    public boolean getHasUncommittedValues() {
        return this.uncommittedValues;
    }

    private void setHasInvalidValues(boolean invalidValues) {
        if (this.invalidValues != invalidValues) {
            this.invalidValues = invalidValues;
            this.changeSupport.firePropertyChange("hasInvalidValues", !invalidValues, invalidValues);
        }
    }

    public boolean getHasInvalidValues() {
        return this.invalidValues;
    }

    public final void addResolver(ELResolver resolver) {
        BindingContext.throwIfNull(resolver);
        this.resolvers.add(resolver);
        this.context = null;
    }

    public final void removeResolver(ELResolver resolver) {
        BindingContext.throwIfNull(resolver);
        this.resolvers.remove(resolver);
        this.context = null;
    }

    public final void addFunction(String prefix, String localName, Method m) {
        BindingContext.throwIfNull(prefix, localName, m);
        this.functionMapper.addFunction(prefix, localName, m);
    }

    public final void removeFunction(String prefix, String localName, Method m) {
        BindingContext.throwIfNull(prefix, localName, m);
        this.functionMapper.removeFunction(prefix, localName, m);
    }

    public final Iterable<FeatureDescriptor> getFeatureDescriptors(Object obj) {
        BindingContext.throwIfNull(obj);
        return new FeatureDescriptorIterable(obj);
    }

    ELContext getContext() {
        if (this.context == null) {
            this.context = new Context();
        }
        return this.context;
    }

    static void throwIfNull(Object ... args) {
        for (Object arg : args) {
            if (arg != null) continue;
            throw new IllegalArgumentException("Argument must be non-null");
        }
    }

    void bindingBecameBound(Binding binding) {
        this.bound.add(binding);
    }

    void bindingBecameUnbound(Binding binding) {
        this.bound.remove(binding);
        this.unbound.add(binding);
        this.updateState();
    }

    void bindingValueStateChanged(Binding binding) {
        this.updateState();
    }

    private void updateState() {
        boolean[] state = new boolean[]{false, false};
        List<Object> childBindings = new ArrayList(1);
        for (Binding binding : this.bound) {
            Binding childBinding;
            if (this.updateState0(binding, state)) break;
            childBindings = binding.getBindings();
            Iterator<Object> i$ = childBindings.iterator();
            while (i$.hasNext() && !this.updateState0(childBinding = (Binding)i$.next(), state)) {
            }
        }
        this.setHasUncommittedValues(state[0]);
        this.setHasInvalidValues(state[1]);
    }

    private boolean updateState0(Binding binding, boolean[] state) {
        if (binding.isBound()) {
            Binding.ValueState targetState = binding.getTargetValueState();
            Binding.ValueState sourceState = binding.getSourceValueState();
            if (!(state[0] || sourceState != Binding.ValueState.UNCOMMITTED && targetState != Binding.ValueState.UNCOMMITTED)) {
                state[0] = true;
                if (state[1]) {
                    return true;
                }
            }
            if (!state[1] && targetState == Binding.ValueState.INVALID) {
                state[1] = true;
                if (state[0]) {
                    return true;
                }
            }
        }
        return false;
    }

    void converterFailed(Binding binding, Exception conversionException) {
        for (BindingListener listener : this.bindingListeners) {
            listener.converterFailed(binding, conversionException);
        }
    }

    public String toString() {
        return "Binding [uncommittedValues=" + this.uncommittedValues + " invalidValues=" + this.invalidValues + " bindings=" + this.bound + " hasEditedTargetValues=" + this.hasEditedTargetValues + " resolvers=" + this.resolvers + "]";
    }

    private final class BindingFunctionMapper
    extends FunctionMapperImpl {
        private BindingFunctionMapper() {
        }

        public void removeFunction(String prefix, String localName, Method m) {
            if (this.functions != null) {
                FunctionMapperImpl.Function f = new FunctionMapperImpl.Function(prefix, localName, m);
                this.functions.remove(prefix + ":" + localName);
            }
        }
    }

    private final class Context
    extends ELContext {
        private final ELResolver resolver;
        private final VariableMapper mapper;

        Context() {
            CompositeELResolver compositeResolver = new CompositeELResolver();
            for (ELResolver resolver : BindingContext.this.resolvers) {
                compositeResolver.add(resolver);
            }
            this.resolver = compositeResolver;
            this.mapper = new VariableMapperImpl();
        }

        public ELResolver getELResolver() {
            return this.resolver;
        }

        public FunctionMapper getFunctionMapper() {
            return BindingContext.this.functionMapper;
        }

        public VariableMapper getVariableMapper() {
            return this.mapper;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FeatureDescriptorIterable
    implements Iterable<FeatureDescriptor> {
        private final Object obj;

        FeatureDescriptorIterable(Object obj) {
            this.obj = obj;
        }

        @Override
        public Iterator<FeatureDescriptor> iterator() {
            ELContext context = BindingContext.this.getContext();
            return context.getELResolver().getFeatureDescriptors(context, this.obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PropertyDelegateResolver
    extends BeanELResolver {
        private PropertyDelegateResolver() {
        }

        @Override
        public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
            List<Class<?>> pdTypes;
            Iterator<FeatureDescriptor> superDescriptors = super.getFeatureDescriptors(context, base);
            if (base != null && (pdTypes = PropertyDelegateFactory.getPropertyDelegateClass(base.getClass())).size() > 0) {
                HashMap<String, FeatureDescriptor> dMap = new HashMap<String, FeatureDescriptor>();
                while (superDescriptors.hasNext()) {
                    FeatureDescriptor d = superDescriptors.next();
                    dMap.put(d.getName(), d);
                }
                for (Class<?> type : pdTypes) {
                    for (FeatureDescriptor d : this.getDescriptors(type)) {
                        dMap.put(d.getName(), d);
                    }
                }
                return dMap.values().iterator();
            }
            return superDescriptors;
        }

        private List<FeatureDescriptor> getDescriptors(Class<?> type) {
            BeanInfo info = null;
            try {
                info = Introspector.getBeanInfo(type);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (info == null) {
                return Collections.emptyList();
            }
            ArrayList<FeatureDescriptor> list = new ArrayList<FeatureDescriptor>(info.getPropertyDescriptors().length);
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                if (pd.getPropertyType() != null) {
                    pd.setValue("type", pd.getPropertyType());
                }
                pd.setValue("resolvableAtDesignTime", Boolean.TRUE);
                list.add(pd);
            }
            return list;
        }

        private Object baseOrDelegate(Object base, Object property) {
            Object delegate;
            if (base != null && property instanceof String && (delegate = PropertyDelegateFactory.getPropertyDelegate(base, (String)property)) != null) {
                return delegate;
            }
            return base;
        }

        @Override
        public void setValue(ELContext context, Object base, Object property, Object val) {
            super.setValue(context, this.baseOrDelegate(base, property), property, val);
        }

        @Override
        public boolean isReadOnly(ELContext context, Object base, Object property) {
            return super.isReadOnly(context, this.baseOrDelegate(base, property), property);
        }

        @Override
        public Object getValue(ELContext context, Object base, Object property) {
            return super.getValue(context, this.baseOrDelegate(base, property), property);
        }

        @Override
        public Class<?> getType(ELContext context, Object base, Object property) {
            return super.getType(context, this.baseOrDelegate(base, property), property);
        }

        @Override
        public Class<?> getCommonPropertyType(ELContext context, Object base) {
            if (base == null) {
                return null;
            }
            return Object.class;
        }
    }
}

