/*
 * Decompiled with CFR 0.152.
 */
package javax.beans.binding;

public abstract class BindingConverter {
    static final BindingConverter STRING_TO_INT_CONVERTER = new StringToIntConverter();
    static final BindingConverter INT_TO_STRING_CONVERTER = new IntToStringConverter();
    static final BindingConverter BOOLEAN_TO_INT_CONVERTER = new BooleanToIntConverter();
    static final BindingConverter INT_TO_BOOLEAN_CONVERTER = new IntToBooleanConverter();
    static final BindingConverter OBJECT_TO_INT_CONVERTER = new ObjectToIntConverter();

    public abstract Object sourceToTarget(Object var1);

    public Object targetToSource(Object value) {
        return value;
    }

    private static final class BooleanToIntConverter
    extends BindingConverter {
        private BooleanToIntConverter() {
        }

        public Object targetToSource(Object value) {
            if ((Integer)value == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Object sourceToTarget(Object value) {
            if (((Boolean)value).booleanValue()) {
                return 1;
            }
            return 0;
        }
    }

    private static final class IntToBooleanConverter
    extends BindingConverter {
        private IntToBooleanConverter() {
        }

        public Object targetToSource(Object value) {
            if (((Boolean)value).booleanValue()) {
                return 1;
            }
            return 0;
        }

        public Object sourceToTarget(Object value) {
            if ((Integer)value == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
    }

    private static final class IntToStringConverter
    extends BindingConverter {
        private IntToStringConverter() {
        }

        public Object targetToSource(Object value) {
            return Integer.parseInt((String)value);
        }

        public Object sourceToTarget(Object value) {
            return Integer.toString((Integer)value);
        }
    }

    private static final class ObjectToIntConverter
    extends BindingConverter {
        private ObjectToIntConverter() {
        }

        public Object targetToSource(Object value) {
            return value;
        }

        public Object sourceToTarget(Object value) {
            return Integer.parseInt(value.toString());
        }
    }

    private static final class StringToIntConverter
    extends BindingConverter {
        private StringToIntConverter() {
        }

        public Object targetToSource(Object value) {
            return Integer.toString((Integer)value);
        }

        public Object sourceToTarget(Object value) {
            return Integer.parseInt((String)value);
        }
    }
}

