/*
 * Decompiled with CFR 0.152.
 */
package javax.beans.binding;

import com.sun.el.ExpressionFactoryImpl;
import com.sun.java.util.ObservableMap;
import com.sun.java.util.ObservableMapListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.beans.binding.PropertyResolverException;
import javax.beans.binding.ext.PropertyDelegateFactory;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.Expression;
import javax.el.ValueExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ELPropertyResolver {
    private final ChangeHandler changeHandler;
    private final ELContext context;
    private boolean bound;
    private Object source;
    private String path;
    private ValueExpression expression;
    private Set<RegisteredListener> registeredListeners;
    private Set<RegisteredListener> lastRegisteredListeners;
    private boolean ignoreChange;
    private Object result;
    private Expression.Result.Type resultType;
    private Delegate delegate;

    public ELPropertyResolver(ELContext context) {
        this.context = context;
        this.changeHandler = new ChangeHandler();
        this.registeredListeners = new HashSet<RegisteredListener>(1);
    }

    public ELPropertyResolver(ELContext context, Object source, String path) {
        this(context);
        this.source = source;
        this.path = path;
    }

    public void setSource(Object source) {
        if (this.bound) {
            throw new IllegalStateException("Can't set source when bound");
        }
        this.source = source;
    }

    public Object getSource() {
        return this.source;
    }

    public void setPath(String path) {
        if (this.bound) {
            throw new IllegalStateException("Can't set path when bound");
        }
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setDelegate(Delegate delegate) {
        if (this.delegate != null) {
            throw new IllegalStateException("PropertyResolver can only have one delegate, and a delegate is already registered.");
        }
        this.delegate = delegate;
    }

    public Delegate getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueOfLastProperty(Object value) {
        this.throwIfNotBound();
        if (this.emptyPath()) {
            throw new IllegalStateException("Can not set value on empty path");
        }
        if (this.resultType == Expression.Result.Type.INCOMPLETE_PATH) {
            throw new IllegalStateException("Can't set value of incomplete path");
        }
        if (this.expression.isReadOnly(this.context)) {
            throw new IllegalStateException("Expression is readonly");
        }
        this.ignoreChange = true;
        try {
            this.expression.setValue(this.context, value);
        }
        finally {
            this.ignoreChange = false;
        }
        this.reevaluate();
    }

    public Object getValueOfLastProperty() {
        this.throwIfNotBound();
        if (this.resultType == Expression.Result.Type.INCOMPLETE_PATH) {
            throw new IllegalStateException("Incomplete path");
        }
        return this.result;
    }

    public Expression.Result.Type getEvaluationResultType() {
        this.throwIfNotBound();
        if (this.emptyPath()) {
            return Expression.Result.Type.SINGLE_VALUE;
        }
        return this.resultType;
    }

    public Class<?> getTypeOfLastProperty() {
        if (this.emptyPath()) {
            return null;
        }
        if (!this.bound) {
            this.createExpressionAndFactory();
            Class<?> type = this.expression.getType(this.context);
            this.expression = null;
            return type;
        }
        if (this.resultType == Expression.Result.Type.INCOMPLETE_PATH) {
            throw new IllegalStateException("Path is currently incomplete");
        }
        return this.expression.getType(this.context);
    }

    public void bind() {
        if (this.bound) {
            throw new IllegalStateException("already bound");
        }
        if (!this.emptyPath() && this.getSource() == null) {
            throw new IllegalStateException("Must provide non-null source");
        }
        this.bound = true;
        if (!this.emptyPath()) {
            this.createExpressionAndFactory();
            this.reevaluate();
        } else {
            this.result = this.source;
        }
    }

    public void unbind() {
        this.throwIfNotBound();
        this.bound = false;
        for (RegisteredListener rl : this.registeredListeners) {
            this.removeListener(rl);
        }
        this.registeredListeners.clear();
        this.result = null;
        this.expression = null;
        this.resultType = null;
    }

    public Expression.Result evaluate() {
        if (this.emptyPath()) {
            List<Expression.ResolvedObject> emptyList = Collections.emptyList();
            return new Expression.Result(Expression.Result.Type.SINGLE_VALUE, this.getSource(), emptyList);
        }
        if (this.bound) {
            return this.expression.getResult(this.context);
        }
        this.createExpressionAndFactory();
        Expression.Result result = this.expression.getResult(this.context);
        this.expression = null;
        return result;
    }

    private void createExpressionAndFactory() {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        this.expression = factory.createValueExpression(this.context, this.path, (Class)Object.class);
        this.expression.setSource(this.getSource());
    }

    private void reevaluate() {
        this.lastRegisteredListeners = this.registeredListeners;
        this.registeredListeners = new HashSet<RegisteredListener>(this.lastRegisteredListeners.size());
        Expression.Result result = null;
        ELException e = null;
        try {
            result = this.expression.getResult(this.context);
        }
        catch (ELException ele) {
            e = ele;
        }
        if (e != null) {
            throw new PropertyResolverException("Error evaluating expression", this.getSource(), this.getPath(), e);
        }
        List<Expression.ResolvedObject> pairs = result.getResolvedObjects();
        for (Expression.ResolvedObject pair : pairs) {
            this.registerListener(pair);
        }
        this.resultType = result.getType();
        this.result = result.getResult();
        for (RegisteredListener listener : this.lastRegisteredListeners) {
            this.removeListener(listener);
        }
        this.lastRegisteredListeners = null;
    }

    private void registerListener(Expression.ResolvedObject o) {
        if (o instanceof Expression.ResolvedProperty) {
            Expression.ResolvedProperty resolved = (Expression.ResolvedProperty)o;
            Object source = resolved.getSource();
            Object property = resolved.getProperty();
            if (source != null && property instanceof String) {
                String sProperty;
                Object delegate;
                Object pclSource;
                RegisteredListener rl;
                if (source instanceof ObservableMap) {
                    RegisteredListener rl2 = new RegisteredListener(source, (String)property);
                    if (!this.registeredListeners.contains(rl2)) {
                        if (!this.lastRegisteredListeners.remove(rl2)) {
                            ((ObservableMap)source).addObservableMapListener(this.getChangeHandler());
                        }
                        this.registeredListeners.add(rl2);
                    }
                } else if (source != null && !this.registeredListeners.contains(rl = new RegisteredListener(pclSource = (delegate = this.getPropertyDelegate(source, sProperty = (String)property)) != null ? delegate : source, sProperty))) {
                    if (!this.lastRegisteredListeners.remove(rl)) {
                        this.addPropertyChangeListener(pclSource, sProperty);
                    }
                    this.registeredListeners.add(rl);
                }
            }
        } else if (o instanceof Expression.ResolvedList) {
            Expression.ResolvedList resolvedList = (Expression.ResolvedList)o;
        }
    }

    private void removeListener(RegisteredListener rl) {
        Object source = rl.getSource();
        if (source instanceof ObservableMap) {
            ((ObservableMap)source).removeObservableMapListener(this.getChangeHandler());
        } else {
            this.removePropertyChangeListener(source, rl.getProperty());
        }
    }

    private ChangeHandler getChangeHandler() {
        return this.changeHandler;
    }

    private void addPropertyChangeListener(Object source, String property) {
        Exception reason = null;
        try {
            Method addPCL = source.getClass().getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
            addPCL.invoke(source, property, this.getChangeHandler());
        }
        catch (SecurityException ex) {
            reason = ex;
        }
        catch (IllegalArgumentException ex) {
            reason = ex;
        }
        catch (InvocationTargetException ex) {
            reason = ex;
        }
        catch (IllegalAccessException ex) {
            reason = ex;
        }
        catch (NoSuchMethodException ex) {
            try {
                Method addPCL = source.getClass().getMethod("addPropertyChangeListener", PropertyChangeListener.class);
                addPCL.invoke(source, this.getChangeHandler());
            }
            catch (SecurityException ex2) {
                reason = ex2;
            }
            catch (IllegalArgumentException ex2) {
                reason = ex2;
            }
            catch (InvocationTargetException ex2) {
                reason = ex2;
            }
            catch (IllegalAccessException ex2) {
                reason = ex2;
            }
            catch (NoSuchMethodException ex2) {
                // empty catch block
            }
        }
        if (reason != null) {
            throw new PropertyResolverException("Unable to register propertyChangeListener " + property + " " + source, source, this.path, reason);
        }
    }

    private void removePropertyChangeListener(Object source, String property) {
        Method removePCL;
        Exception reason = null;
        boolean removed = false;
        if (property != null) {
            try {
                removePCL = source.getClass().getMethod("removePropertyChangeListener", String.class, PropertyChangeListener.class);
                removePCL.invoke(source, property, this.getChangeHandler());
                removed = true;
            }
            catch (SecurityException ex) {
                reason = ex;
            }
            catch (IllegalArgumentException ex) {
                reason = ex;
            }
            catch (InvocationTargetException ex) {
                reason = ex;
            }
            catch (IllegalAccessException ex) {
                reason = ex;
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        if (reason == null && !removed) {
            try {
                removePCL = source.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class);
                removePCL.invoke(source, this.getChangeHandler());
            }
            catch (SecurityException ex2) {
                reason = ex2;
            }
            catch (IllegalArgumentException ex2) {
                reason = ex2;
            }
            catch (InvocationTargetException ex2) {
                reason = ex2;
            }
            catch (IllegalAccessException ex2) {
                reason = ex2;
            }
            catch (NoSuchMethodException ex2) {
                // empty catch block
            }
        }
        if (reason != null) {
            throw new PropertyResolverException("Unable to remove propertyChangeListener " + property + " " + source, source, this.path, reason);
        }
    }

    private Object getPropertyDelegate(Object source, String property) {
        return PropertyDelegateFactory.getPropertyDelegate(source, property);
    }

    private boolean emptyPath() {
        return this.path == null || "".equals(this.path);
    }

    private void propertyChanged() {
        if (!this.ignoreChange) {
            this.reevaluate();
            if (this.delegate != null) {
                this.delegate.valueChanged(this);
            }
        }
    }

    private void throwIfNotBound() {
        if (!this.bound) {
            throw new IllegalStateException("Must bind before using this");
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    private final class ChangeHandler
    implements ObservableMapListener,
    PropertyChangeListener {
        private ChangeHandler() {
        }

        private void sourceChanged(Object source, String property) {
            if (property != null) {
                property = property.intern();
            }
            for (RegisteredListener rl : ELPropertyResolver.this.registeredListeners) {
                if (rl.getSource() != source || property != null && rl.getProperty() != property) continue;
                ELPropertyResolver.this.propertyChanged();
                break;
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            this.sourceChanged(e.getSource(), e.getPropertyName());
        }

        public void mapKeyValueChanged(ObservableMap map, Object key, Object lastValue) {
            if (key instanceof String) {
                this.sourceChanged(map, (String)key);
            }
        }

        public void mapKeyAdded(ObservableMap map, Object key) {
            if (key instanceof String) {
                this.sourceChanged(map, (String)key);
            }
        }

        public void mapKeyRemoved(ObservableMap map, Object key, Object value) {
            if (key instanceof String) {
                this.sourceChanged(map, (String)key);
            }
        }
    }

    public static abstract class Delegate {
        public abstract void valueChanged(ELPropertyResolver var1);
    }

    private static final class RegisteredListener {
        private final Object source;
        private final String property;

        RegisteredListener(Object source) {
            this(source, null);
        }

        RegisteredListener(Object source, String property) {
            this.source = source;
            if (property != null) {
                property = property.intern();
            }
            this.property = property;
        }

        public Object getSource() {
            return this.source;
        }

        public String getProperty() {
            return this.property;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof RegisteredListener) {
                RegisteredListener orl = (RegisteredListener)obj;
                return orl.source == this.source && orl.property == this.property;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.source.hashCode();
            if (this.property != null) {
                result = 37 * result + this.property.hashCode();
            }
            return result;
        }

        public String toString() {
            return "RegisteredListener [ source=" + this.source + " property=" + this.property + "]";
        }
    }
}

