/*
 * Decompiled with CFR 0.152.
 */
package javax.beans.binding;

abstract class PropertyPath {
    private static final PropertyPath EMPTY_PROPERTY_PATH = new EmptyPropertyPath();

    public static PropertyPath createPropertyPath(String path) {
        int length;
        if (path == null || (length = path.length()) == 0) {
            return EMPTY_PROPERTY_PATH;
        }
        int dotIndex = path.indexOf(46);
        if (dotIndex == -1) {
            return new SinglePropertyPath(path);
        }
        return new MultiPropertyPath(path.split("\\."));
    }

    PropertyPath() {
    }

    public abstract int length();

    public abstract String get(int var1);

    public PropertyPath subPath(int start, int length) {
        if (start == 0 && length == this.length()) {
            return this;
        }
        if (start < 0 || start + length > this.length() || length < 0) {
            throw new IllegalArgumentException();
        }
        if (length == 0) {
            return EMPTY_PROPERTY_PATH;
        }
        if (length == 1) {
            return new SinglePropertyPath(this.get(start));
        }
        String[] path = new String[length];
        for (int i = 0; i < path.length; ++i) {
            path[i] = this.get(i + start);
        }
        return new MultiPropertyPath(path);
    }

    public PropertyPath append(PropertyPath path) {
        if (this == EMPTY_PROPERTY_PATH) {
            return path;
        }
        if (path == EMPTY_PROPERTY_PATH) {
            return this;
        }
        return PropertyPath.createPropertyPath(this.toString() + "." + path.toString());
    }

    public abstract String toString();

    private static final class EmptyPropertyPath
    extends PropertyPath {
        private EmptyPropertyPath() {
        }

        public int length() {
            return 0;
        }

        public String get(int index) {
            throw new ArrayIndexOutOfBoundsException();
        }

        public String toString() {
            return "";
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public int hashCode() {
            return 17;
        }
    }

    private static final class MultiPropertyPath
    extends PropertyPath {
        private final String[] path;

        MultiPropertyPath(String[] path) {
            this.path = path;
            for (int i = 0; i < path.length; ++i) {
                path[i] = path[i].intern();
            }
            assert (path.length > 0);
        }

        public int length() {
            return this.path.length;
        }

        public String get(int index) {
            return this.path[index];
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.path[0]);
            for (int i = 1; i < this.path.length; ++i) {
                builder.append('.');
                builder.append(this.path[i]);
            }
            return builder.toString();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof MultiPropertyPath) {
                String[] oPath = ((MultiPropertyPath)o).path;
                if (oPath.length != this.path.length) {
                    return false;
                }
                for (int i = 0; i < oPath.length; ++i) {
                    if (this.path[i].equals(oPath[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            for (int i = 0; i < this.path.length; ++i) {
                result = 37 * result + this.path[i].hashCode();
            }
            return result;
        }
    }

    private static final class SinglePropertyPath
    extends PropertyPath {
        private final String path;

        SinglePropertyPath(String path) {
            this.path = path.intern();
        }

        public int length() {
            return 1;
        }

        public String get(int index) {
            if (index == 0) {
                return this.path;
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public String toString() {
            return this.path;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof SinglePropertyPath) {
                return this.path.equals(((SinglePropertyPath)o).path);
            }
            return false;
        }

        public int hashCode() {
            return 17 + 37 * this.path.hashCode();
        }
    }
}

