/*
 * Decompiled with CFR 0.152.
 */
package javax.beans.binding;

import com.sun.java.util.ObservableMap;
import com.sun.java.util.ObservableMapListener;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.beans.binding.PropertyPath;
import javax.beans.binding.PropertyResolverException;
import javax.beans.binding.ext.PropertyDelegateFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PropertyResolver {
    private final PropertyPath path;
    private final Object[] sources;
    private final boolean emptySourcePath;
    private boolean bound;
    private ChangeHandler changeHandler;
    private boolean ignoreChange;
    private Delegate delegate;

    public static PropertyResolver createPropertyResolver(String path) {
        return PropertyResolver.createPropertyResolver(null, path);
    }

    public static PropertyResolver createPropertyResolver(Object source, String path) {
        return new PropertyResolver(source, PropertyPath.createPropertyPath(path));
    }

    PropertyResolver(Object source, PropertyPath path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        this.path = path;
        if (path.length() > 0) {
            this.sources = new Object[path.length()];
            this.sources[0] = source;
            this.emptySourcePath = false;
        } else {
            this.sources = new Object[]{source};
            this.emptySourcePath = true;
        }
    }

    public void setSource(Object object) {
        if (this.bound) {
            throw new IllegalStateException("Can't set source when bound");
        }
        this.sources[0] = object;
    }

    public Object getSource() {
        return this.sources[0];
    }

    public PropertyPath getPath() {
        return this.path;
    }

    public void setDelegate(Delegate delegate) {
        if (this.delegate != null) {
            throw new IllegalStateException("PropertyResolver can only have one delegate, and a delegate is already registered.");
        }
        this.delegate = delegate;
    }

    public Delegate getDelegate() {
        return this.delegate;
    }

    public void setValueOfLastProperty(Object value) {
        if (this.bound) {
            this.checkBoundPath();
            this.setProperty(this.sources[this.sources.length - 1], this.path.get(this.sources.length - 1), value);
        } else {
            Object source = this.sources[0];
            for (int i = 0; i < this.path.length() - 1; ++i) {
                if (source == null) {
                    throw new IllegalStateException();
                }
                source = this.getProperty(source, this.path.get(i));
            }
            if (source == null) {
                throw new IllegalStateException();
            }
            this.setProperty(source, this.path.get(this.sources.length - 1), value);
        }
    }

    private void checkBoundPath() {
        for (int i = 0; i < this.sources.length; ++i) {
            if (this.sources[i] != null) continue;
            throw new IllegalStateException();
        }
    }

    public Object getValueOfLastProperty() {
        if (this.bound) {
            this.checkBoundPath();
            if (this.emptySourcePath) {
                return this.sources[0];
            }
            return this.getProperty(this.sources[this.sources.length - 1], this.path.get(this.path.length() - 1));
        }
        Object value = this.sources[0];
        for (int i = 0; i < this.path.length(); ++i) {
            if (value == null) {
                throw new IllegalStateException();
            }
            value = this.getProperty(value, this.path.get(i));
        }
        return value;
    }

    public Object getLastSource() {
        if (this.bound) {
            this.checkBoundPath();
            return this.sources[this.sources.length - 1];
        }
        Object source = this.sources[0];
        for (int i = 0; i < this.path.length() - 1; ++i) {
            if (source == null) {
                throw new IllegalStateException();
            }
            source = this.getProperty(source, this.path.get(i));
        }
        return source;
    }

    public boolean hasAllPathValues() {
        if (this.bound) {
            for (int i = 0; i < this.sources.length; ++i) {
                if (this.sources[i] != null) continue;
                return false;
            }
        } else {
            Object value = this.sources[0];
            for (int i = 0; i < this.path.length(); ++i) {
                if (value == null) {
                    return false;
                }
                value = this.getProperty(value, this.path.get(i));
            }
        }
        return true;
    }

    public void bind() {
        if (this.bound) {
            throw new IllegalStateException("already bound");
        }
        this.bound = true;
        if (this.path.length() > 0) {
            this.updateListeners(0, this.sources[0], true);
        }
    }

    public void unbind() {
        if (!this.bound) {
            throw new IllegalStateException("already unbound");
        }
        this.bound = false;
        if (!this.emptySourcePath) {
            int i;
            if (this.changeHandler != null) {
                for (i = 0; i < this.sources.length; ++i) {
                    this.unregisterListener(this.sources[i], this.path.get(i));
                }
            }
            for (i = 1; i < this.sources.length; ++i) {
                this.sources[i] = null;
            }
        }
    }

    public Class<?> getTypeOfLastProperty() {
        this.checkBoundPath();
        if (this.path.length() == 0) {
            return this.sources[0].getClass();
        }
        if (this.bound) {
            return this.getType(this.sources[this.sources.length - 1], this.path.get(this.path.length() - 1));
        }
        Object value = this.sources[0];
        for (int i = 0; i < this.path.length() - 1; ++i) {
            if (value == null) {
                throw new IllegalStateException();
            }
            value = this.getProperty(value, this.path.get(i));
        }
        if (value == null) {
            throw new IllegalStateException();
        }
        return this.getType(value, this.path.get(this.path.length() - 1));
    }

    private void sourceValueChanged(int index, Object value) {
        this.updateListeners(index, value, false);
        if (this.delegate != null) {
            this.delegate.valueChanged(this);
        }
    }

    private void mapValueChanged(ObservableMap map, Object key) {
        int index;
        if (!this.ignoreChange && (index = this.getSourceIndex(map)) != -1 && key.equals(this.path.get(index))) {
            this.sourceValueChanged(index + 1, map.get(key));
        }
    }

    private void updateListeners(int index, Object value, boolean initialBind) {
        Object sourceValue = value;
        if (initialBind) {
            this.sources[0] = null;
        }
        int max = this.path.length();
        for (int i = index; i < max; ++i) {
            if (sourceValue != this.sources[i]) {
                this.unregisterListener(this.sources[i], this.path.get(i));
                this.sources[i] = sourceValue;
                if (sourceValue != null) {
                    this.registerListener(sourceValue, this.path.get(i));
                }
            }
            if (i + 1 >= max) continue;
            sourceValue = this.getProperty(sourceValue, this.path.get(i));
        }
    }

    private Object getPropertyDelegate(Object source, String property) {
        return PropertyDelegateFactory.getPropertyDelegate(source, property);
    }

    private Class<?> getType(Object object, String string) {
        if (object == null) {
            return null;
        }
        if (object instanceof Map) {
            return Object.class;
        }
        Object delegate = PropertyDelegateFactory.getPropertyDelegate(object, string);
        if (delegate != null) {
            return this.getType0(delegate, string);
        }
        return this.getType0(object, string);
    }

    private Class<?> getType0(Object object, String string) {
        try {
            PropertyDescriptor pd = new PropertyDescriptor(string, object.getClass(), "is" + PropertyResolver.capitalize(string), null);
            Method readMethod = pd.getReadMethod();
            if (readMethod != null) {
                return readMethod.getReturnType();
            }
            throw new PropertyResolverException("Unable to determine type " + string + " " + object, this.sources[0], this.path.toString());
        }
        catch (IntrospectionException ex) {
            throw new PropertyResolverException("IntrospectionException getting read method " + string + " " + object, this.sources[0], this.path.toString(), ex);
        }
    }

    private Object getProperty(Object object, String string) {
        if (object == null) {
            return null;
        }
        if (object instanceof Map) {
            return ((Map)object).get(string);
        }
        Object delegate = PropertyDelegateFactory.getPropertyDelegate(object, string);
        if (delegate != null) {
            return this.getProperty0(delegate, string);
        }
        return this.getProperty0(object, string);
    }

    private Object getProperty0(Object object, String string) {
        try {
            PropertyDescriptor pd = new PropertyDescriptor(string, object.getClass(), "is" + PropertyResolver.capitalize(string), null);
            Method readMethod = pd.getReadMethod();
            if (readMethod != null) {
                Exception reason;
                try {
                    return readMethod.invoke(object, new Object[0]);
                }
                catch (IllegalArgumentException ex) {
                    reason = ex;
                }
                catch (IllegalAccessException ex) {
                    reason = ex;
                }
                catch (InvocationTargetException ex) {
                    reason = ex;
                }
                throw new PropertyResolverException("Exception getting value " + string + " " + object, this.sources[0], this.path.toString(), reason);
            }
            throw new PropertyResolverException("Unable to find read method " + string + " " + object, this.sources[0], this.path.toString());
        }
        catch (IntrospectionException ex) {
            throw new PropertyResolverException("IntrospectionException getting read method " + string + " " + object, this.sources[0], this.path.toString(), ex);
        }
    }

    private static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private void setProperty(Object object, String propertyName, Object value) {
        this.ignoreChange = true;
        if (object instanceof Map) {
            ((Map)object).put(propertyName, value);
        } else if (object != null) {
            Object delegate = PropertyDelegateFactory.getPropertyDelegate(object, propertyName);
            if (delegate != null) {
                this.setProperty0(delegate, propertyName, value);
            } else {
                this.setProperty0(object, propertyName, value);
            }
        }
        this.ignoreChange = false;
    }

    private void setProperty0(Object object, String propertyName, Object value) {
        try {
            PropertyDescriptor pd = new PropertyDescriptor(propertyName, object.getClass(), null, "set" + PropertyResolver.capitalize(propertyName));
            Method setMethod = pd.getWriteMethod();
            if (setMethod != null) {
                Exception reason;
                try {
                    setMethod.invoke(object, value);
                    return;
                }
                catch (IllegalArgumentException ex) {
                    reason = ex;
                }
                catch (InvocationTargetException ex) {
                    reason = ex;
                }
                catch (IllegalAccessException ex) {
                    reason = ex;
                }
                throw new PropertyResolverException("Unable to set value " + propertyName + " on " + object + " value=" + value, this.sources[0], this.path.toString(), reason);
            }
            throw new PropertyResolverException("Unable to find setter " + propertyName + " on " + object, this.sources[0], this.path.toString());
        }
        catch (IntrospectionException ex) {
            throw new PropertyResolverException("Introspection exception " + propertyName + " on " + object, this.sources[0], this.path.toString(), ex);
        }
    }

    private void registerListener(Object source, String property) {
        if (source != null) {
            if (source instanceof ObservableMap) {
                ((ObservableMap)source).addObservableMapListener(this.getChangeHandler());
            } else {
                Object delegate = this.getPropertyDelegate(source, property);
                if (delegate != null) {
                    this.addPropertyChangeListener(delegate, property);
                } else {
                    this.addPropertyChangeListener(source, property);
                }
            }
        }
    }

    private void addPropertyChangeListener(Object source, String property) {
        Exception reason = null;
        try {
            Method addPCL = source.getClass().getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
            addPCL.invoke(source, property, this.getChangeHandler());
        }
        catch (SecurityException ex) {
            reason = ex;
        }
        catch (IllegalArgumentException ex) {
            reason = ex;
        }
        catch (InvocationTargetException ex) {
            reason = ex;
        }
        catch (IllegalAccessException ex) {
            reason = ex;
        }
        catch (NoSuchMethodException ex) {
            try {
                Method addPCL = source.getClass().getMethod("addPropertyChangeListener", PropertyChangeListener.class);
                addPCL.invoke(source, this.getChangeHandler());
            }
            catch (SecurityException ex2) {
                reason = ex2;
            }
            catch (IllegalArgumentException ex2) {
                reason = ex2;
            }
            catch (InvocationTargetException ex2) {
                reason = ex2;
            }
            catch (IllegalAccessException ex2) {
                reason = ex2;
            }
            catch (NoSuchMethodException ex2) {
                // empty catch block
            }
        }
        if (reason != null) {
            throw new PropertyResolverException("Unable to register propertyChangeListener " + property + " " + source, this.sources[0], this.path.toString(), reason);
        }
    }

    private void unregisterListener(Object source, String property) {
        if (this.changeHandler != null && source != null) {
            if (source instanceof ObservableMap) {
                ((ObservableMap)source).removeObservableMapListener(this.getChangeHandler());
            } else {
                Object delegate = this.getPropertyDelegate(source, property);
                if (delegate != null) {
                    this.removePropertyChangeListener(delegate, property);
                } else {
                    this.removePropertyChangeListener(source, property);
                }
            }
        }
    }

    private void removePropertyChangeListener(Object source, String property) {
        Exception reason = null;
        try {
            Method removePCL = source.getClass().getMethod("removePropertyChangeListener", String.class, PropertyChangeListener.class);
            removePCL.invoke(source, property, this.changeHandler);
        }
        catch (SecurityException ex) {
            reason = ex;
        }
        catch (IllegalArgumentException ex) {
            reason = ex;
        }
        catch (InvocationTargetException ex) {
            reason = ex;
        }
        catch (IllegalAccessException ex) {
            reason = ex;
        }
        catch (NoSuchMethodException ex) {
            try {
                Method removePCL = source.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class);
                removePCL.invoke(source, this.changeHandler);
            }
            catch (SecurityException ex2) {
                reason = ex2;
            }
            catch (IllegalArgumentException ex2) {
                reason = ex2;
            }
            catch (InvocationTargetException ex2) {
                reason = ex2;
            }
            catch (IllegalAccessException ex2) {
                reason = ex2;
            }
            catch (NoSuchMethodException ex2) {
                // empty catch block
            }
        }
        if (reason != null) {
            throw new PropertyResolverException("Unable to remove propertyChangeListener " + property + " " + source, this.sources[0], this.path.toString(), reason);
        }
    }

    private int getSourceIndex(Object source) {
        int i;
        for (i = 0; i < this.sources.length; ++i) {
            if (this.sources[i] != source) continue;
            return i;
        }
        for (i = 0; i < this.sources.length; ++i) {
            Object delegate;
            if (this.sources[i] == null || (delegate = this.getPropertyDelegate(this.sources[i], this.path.get(i))) != source) continue;
            return i;
        }
        return -1;
    }

    private ChangeHandler getChangeHandler() {
        if (this.changeHandler == null) {
            this.changeHandler = new ChangeHandler();
        }
        return this.changeHandler;
    }

    private final class ChangeHandler
    implements PropertyChangeListener,
    ObservableMapListener {
        private ChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (!PropertyResolver.this.ignoreChange) {
                String propertyName;
                Object source = e.getSource();
                int index = PropertyResolver.this.getSourceIndex(e.getSource());
                if (index != -1 && ((propertyName = e.getPropertyName()) == null || PropertyResolver.this.path.get(index).equals(propertyName))) {
                    Object newValue = e.getNewValue();
                    if (newValue == null) {
                        PropertyResolver.this.sourceValueChanged(index, source);
                    } else {
                        PropertyResolver.this.sourceValueChanged(index + 1, newValue);
                    }
                }
            }
        }

        public void mapKeyValueChanged(ObservableMap map, Object key, Object lastValue) {
            PropertyResolver.this.mapValueChanged(map, key);
        }

        public void mapKeyAdded(ObservableMap map, Object key) {
            PropertyResolver.this.mapValueChanged(map, key);
        }

        public void mapKeyRemoved(ObservableMap map, Object key, Object value) {
            PropertyResolver.this.mapValueChanged(map, key);
        }
    }

    public static abstract class Delegate {
        public abstract void valueChanged(PropertyResolver var1);
    }
}

