/*
 * Decompiled with CFR 0.152.
 */
package javax.beans.binding.ext;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.beans.binding.ext.PropertyDelegateProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyDelegateFactory {
    private static final PropertyDelegateFactory INSTANCE = new PropertyDelegateFactory();
    private final Map<Object, List<VendedDelegate>> vendedDelegates;
    private final List<PropertyDelegateProvider> providers = new ArrayList<PropertyDelegateProvider>();
    private final Set<ClassLoader> classLoaders = new HashSet<ClassLoader>();
    private final Set<URL> serviceURLs = new HashSet<URL>();

    public static Object getPropertyDelegate(Object source, String property) {
        return INSTANCE.getPropertyDelegate0(source, property);
    }

    public static List<Class<?>> getPropertyDelegateClass(Class<?> type) {
        return INSTANCE.getPropertyDelegateClass0(type);
    }

    private PropertyDelegateFactory() {
        this.vendedDelegates = new WeakHashMap<Object, List<VendedDelegate>>();
    }

    private void loadProvidersIfNecessary() {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        if (!this.classLoaders.contains(currentLoader)) {
            this.classLoaders.add(currentLoader);
            this.loadProviders(currentLoader);
        }
    }

    private void loadProviders(ClassLoader classLoader) {
        String serviceName = "META-INF/services/" + PropertyDelegateProvider.class.getName();
        try {
            Enumeration<URL> urls = classLoader.getResources(serviceName);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (this.serviceURLs.contains(url)) continue;
                this.serviceURLs.add(url);
                this.addProviders(url);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addProviders(URL url) {
        InputStream inputStream = null;
        BufferedReader reader = null;
        try {
            String line;
            inputStream = url.openStream();
            reader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
            while ((line = reader.readLine()) != null) {
                try {
                    this.providers.add((PropertyDelegateProvider)Class.forName(line).newInstance());
                }
                catch (IllegalAccessException ex) {
                }
                catch (InstantiationException ex) {
                }
                catch (ClassNotFoundException ex) {}
            }
        }
        catch (UnsupportedEncodingException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    private Object getPropertyDelegate0(Object source, String property) {
        if (source == null || property == null) {
            throw new IllegalArgumentException();
        }
        this.loadProvidersIfNecessary();
        property = property.intern();
        PropertyDelegateProvider provider = this.getProvider(source, property);
        if (provider != null) {
            List<VendedDelegate> delegates = this.vendedDelegates.get(source);
            if (delegates != null) {
                for (int i = delegates.size() - 1; i >= 0; --i) {
                    VendedDelegate vendedDelegate = delegates.get(i);
                    Object delegate = vendedDelegate.getDelegate();
                    if (delegate == null) {
                        this.vendedDelegates.remove(i);
                        continue;
                    }
                    if (vendedDelegate.getProvider() != provider) continue;
                    return delegate;
                }
            } else {
                delegates = new ArrayList<VendedDelegate>(1);
                this.vendedDelegates.put(source, delegates);
            }
            Object delegate = provider.createPropertyDelegate(source, property);
            delegates.add(new VendedDelegate(provider, delegate));
            return delegate;
        }
        return null;
    }

    private PropertyDelegateProvider getProvider(Object source, String property) {
        Class<?> type = source.getClass();
        for (PropertyDelegateProvider provider : this.providers) {
            if (!provider.providesDelegate(type, property)) continue;
            return provider;
        }
        return null;
    }

    private List<Class<?>> getPropertyDelegateClass0(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Type must be non-null");
        }
        this.loadProvidersIfNecessary();
        List<Class<?>> pdTypes = null;
        for (PropertyDelegateProvider provider : this.providers) {
            Class<?> pdType = provider.getPropertyDelegateClass(type);
            if (pdType == null) continue;
            if (pdTypes == null) {
                pdTypes = new ArrayList(1);
            }
            pdTypes.add(pdType);
        }
        if (pdTypes == null) {
            pdTypes = Collections.emptyList();
        }
        return pdTypes;
    }

    private static final class RegisteredProvider {
        private final String property;
        private final PropertyDelegateProvider provider;

        RegisteredProvider(String property, PropertyDelegateProvider provider) {
            this.property = property;
            this.provider = provider;
        }

        public String getProperty() {
            return this.property;
        }

        public PropertyDelegateProvider getProvider() {
            return this.provider;
        }
    }

    private static final class VendedDelegate {
        private final PropertyDelegateProvider provider;
        private final WeakReference<Object> delegate;

        public VendedDelegate(PropertyDelegateProvider provider, Object delegate) {
            this.delegate = new WeakReference<Object>(delegate);
            this.provider = provider;
        }

        public Object getDelegate() {
            return this.delegate.get();
        }

        public PropertyDelegateProvider getProvider() {
            return this.provider;
        }
    }
}

