/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.admin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.file.FileUtils;

public class StandardAdminHandler
implements AdminHandler {
    private static final Object ksEntries = new Object();
    private static Runnable t9yBeforeRename;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAdminData(String localDirectory, String repositoryPath, Entry entry, GlobalOptions globalOptions) throws IOException {
        File entriesFile;
        File repositoryFile;
        File CVSdir = new File(localDirectory, "CVS");
        CVSdir.mkdirs();
        File rootFile = new File(CVSdir, "Root");
        if (!rootFile.exists()) {
            PrintWriter w = new PrintWriter(new FileWriter(rootFile));
            try {
                w.println(globalOptions.getCVSRoot());
            }
            finally {
                w.close();
            }
        }
        if (!(repositoryFile = new File(CVSdir, "Repository")).exists()) {
            PrintWriter w = new PrintWriter(new FileWriter(repositoryFile));
            try {
                if (entry != null && !entry.isDirectory()) {
                    int length = entry.getName().length();
                    repositoryPath = repositoryPath.substring(0, repositoryPath.length() - length);
                }
                if (repositoryPath.endsWith("/")) {
                    repositoryPath = repositoryPath.substring(0, repositoryPath.length() - 1);
                }
                if (repositoryPath.length() == 0) {
                    repositoryPath = ".";
                }
                w.println(repositoryPath);
            }
            finally {
                w.close();
            }
        }
        if ((entriesFile = new File(CVSdir, "Entries")).createNewFile()) {
            this.addDirectoryToParentEntriesFile(CVSdir);
            BufferedWriter w = new BufferedWriter(new FileWriter(entriesFile));
            try {
                w.write("D");
            }
            finally {
                ((Writer)w).close();
            }
        }
        if (entry != null) {
            this.updateEntriesFile(entriesFile, entry);
        }
    }

    public boolean exists(File file) {
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDirectoryToParentEntriesFile(File CVSdir) throws IOException {
        Object object = ksEntries;
        synchronized (object) {
            File parentCVSEntries = StandardAdminHandler.seekEntries(CVSdir.getParentFile().getParentFile());
            if (parentCVSEntries != null) {
                File directory = parentCVSEntries.getParentFile();
                File tempFile = new File(directory, "Entries.Backup");
                tempFile.createNewFile();
                BufferedReader reader = null;
                BufferedWriter writer = null;
                try {
                    String line;
                    reader = new BufferedReader(new FileReader(parentCVSEntries));
                    writer = new BufferedWriter(new FileWriter(tempFile));
                    boolean written = false;
                    Entry directoryEntry = new Entry();
                    directoryEntry.setName(CVSdir.getParentFile().getName());
                    directoryEntry.setDirectory(true);
                    while ((line = reader.readLine()) != null) {
                        if (line.trim().equals("D")) continue;
                        Entry currentEntry = new Entry(line);
                        if (currentEntry.getName() != null && currentEntry.getName().equals(directoryEntry.getName())) {
                            writer.write(directoryEntry.toString());
                            written = true;
                        } else {
                            writer.write(line);
                        }
                        writer.newLine();
                    }
                    if (!written) {
                        writer.write(directoryEntry.toString());
                        writer.newLine();
                    }
                }
                finally {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                if (t9yBeforeRename != null) {
                    t9yBeforeRename.run();
                }
                FileUtils.renameFile(tempFile, parentCVSEntries);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEntriesFile(File originalFile, Entry entry) throws IOException {
        Object object = ksEntries;
        synchronized (object) {
            File directory = originalFile.getParentFile();
            File tempFile = new File(directory, "Entries.Backup");
            tempFile.createNewFile();
            BufferedReader reader = null;
            BufferedWriter writer = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(originalFile));
                writer = new BufferedWriter(new FileWriter(tempFile));
                boolean written = false;
                while ((line = reader.readLine()) != null) {
                    Entry currentEntry = new Entry(line);
                    if (currentEntry.getName() != null && currentEntry.getName().equals(entry.getName())) {
                        writer.write(entry.toString());
                        written = true;
                    } else {
                        writer.write(line);
                    }
                    writer.newLine();
                }
                if (!written) {
                    writer.write(entry.toString());
                    writer.newLine();
                }
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            if (t9yBeforeRename != null) {
                t9yBeforeRename.run();
            }
            FileUtils.renameFile(tempFile, originalFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getEntry(File file) throws IOException {
        File entriesFile = StandardAdminHandler.seekEntries(file.getParentFile());
        if (entriesFile == null) {
            return null;
        }
        this.processEntriesDotLog(new File(file.getParent(), "CVS"));
        BufferedReader reader = null;
        Entry entry = null;
        boolean found = false;
        try {
            String line;
            reader = new BufferedReader(new FileReader(entriesFile));
            while (!found && (line = reader.readLine()) != null) {
                entry = new Entry(line);
                if (entry.getName() == null) continue;
                File entryFile = new File(file.getParentFile(), entry.getName());
                found = entryFile.equals(file);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (!found) {
            return null;
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry[] getEntriesAsArray(File directory) throws IOException {
        LinkedList<Entry> entries = new LinkedList<Entry>();
        File entriesFile = StandardAdminHandler.seekEntries(directory);
        if (entriesFile == null) {
            return new Entry[0];
        }
        this.processEntriesDotLog(new File(directory, "CVS"));
        BufferedReader reader = null;
        Entry entry = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(entriesFile));
            while ((line = reader.readLine()) != null) {
                entry = new Entry(line);
                if (entry.getName() == null) continue;
                entries.add(entry);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        Entry[] toReturnArray = new Entry[entries.size()];
        toReturnArray = entries.toArray(toReturnArray);
        return toReturnArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getEntries(File directory) throws IOException {
        LinkedList<Entry> entries = new LinkedList<Entry>();
        File entriesFile = StandardAdminHandler.seekEntries(directory);
        if (entriesFile == null) {
            return entries.iterator();
        }
        this.processEntriesDotLog(new File(directory, "CVS"));
        BufferedReader reader = null;
        Entry entry = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(entriesFile));
            while ((line = reader.readLine()) != null) {
                entry = new Entry(line);
                if (entry.getName() == null) continue;
                entries.add(entry);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return entries.iterator();
    }

    public void setEntry(File file, Entry entry) throws IOException {
        String parent = file.getParent();
        File entriesFile = StandardAdminHandler.seekEntries(parent);
        if (entriesFile == null) {
            entriesFile = new File(parent, "CVS/Entries");
        }
        this.processEntriesDotLog(new File(parent, "CVS"));
        this.updateEntriesFile(entriesFile, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(File file) throws IOException {
        Object object = ksEntries;
        synchronized (object) {
            File entriesFile = StandardAdminHandler.seekEntries(file.getParent());
            if (entriesFile == null) {
                return;
            }
            this.processEntriesDotLog(new File(file.getParent(), "CVS"));
            File directory = file.getParentFile();
            File tempFile = new File(directory, "Entries.Backup");
            tempFile.createNewFile();
            BufferedReader reader = null;
            BufferedWriter writer = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(entriesFile));
                writer = new BufferedWriter(new FileWriter(tempFile));
                boolean directoriesExist = false;
                while ((line = reader.readLine()) != null) {
                    Entry currentEntry = new Entry(line);
                    if (currentEntry.getName() == null || currentEntry.getName().equals(file.getName())) continue;
                    writer.write(currentEntry.toString());
                    writer.newLine();
                    directoriesExist = directoriesExist || currentEntry.isDirectory();
                }
                if (!directoriesExist) {
                    writer.write("D");
                    writer.newLine();
                }
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            if (t9yBeforeRename != null) {
                t9yBeforeRename.run();
            }
            FileUtils.renameFile(tempFile, entriesFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRepositoryForDirectory(String directory, String repository) throws IOException {
        File repositoryFile = null;
        String repositoryDirs = "";
        File dirFile = new File(directory);
        while (true) {
            if (dirFile == null || dirFile.getName().length() == 0 || !dirFile.exists()) {
                throw new FileNotFoundException("Repository file not found for directory " + directory);
            }
            repositoryFile = new File(dirFile, "CVS/Repository");
            if (repositoryFile.exists()) break;
            repositoryDirs = '/' + dirFile.getName() + repositoryDirs;
            dirFile = dirFile.getParentFile();
        }
        BufferedReader reader = null;
        String fileRepository = null;
        try {
            reader = new BufferedReader(new FileReader(repositoryFile));
            fileRepository = reader.readLine();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (fileRepository == null) {
            fileRepository = "";
        }
        if ((fileRepository = fileRepository + repositoryDirs).startsWith("/")) {
            return fileRepository;
        }
        if (fileRepository.startsWith("./")) {
            fileRepository = fileRepository.substring(2);
        }
        return repository + '/' + fileRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEntriesDotLog(File directory) throws IOException {
        Object object = ksEntries;
        synchronized (object) {
            String line;
            File entriesDotLogFile = new File(directory, "Entries.Log");
            if (!entriesDotLogFile.exists()) {
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(entriesDotLogFile));
            LinkedList<Entry> additionsList = new LinkedList<Entry>();
            HashSet<String> removalSet = new HashSet<String>();
            try {
                while ((line = reader.readLine()) != null) {
                    Entry entry;
                    if (line.startsWith("A ")) {
                        entry = new Entry(line.substring(2));
                        additionsList.add(entry);
                        continue;
                    }
                    if (!line.startsWith("R ")) continue;
                    entry = new Entry(line.substring(2));
                    removalSet.add(entry.getName());
                }
            }
            finally {
                reader.close();
            }
            if (additionsList.size() > 0 || removalSet.size() > 0) {
                File backup = new File(directory, "Entries.Backup");
                BufferedWriter writer = new BufferedWriter(new FileWriter(backup));
                File entriesFile = new File(directory, "Entries");
                reader = new BufferedReader(new FileReader(entriesFile));
                try {
                    int directoryCount = 0;
                    while ((line = reader.readLine()) != null) {
                        if (line.trim().equals("D")) continue;
                        Entry entry = new Entry(line);
                        if (entry.isDirectory()) {
                            ++directoryCount;
                        }
                        if (removalSet.contains(entry.getName())) continue;
                        writer.write(entry.toString());
                        writer.newLine();
                        if (!entry.isDirectory()) continue;
                        --directoryCount;
                    }
                    Iterator it = additionsList.iterator();
                    while (it.hasNext()) {
                        Entry entry = (Entry)it.next();
                        if (entry.isDirectory()) {
                            ++directoryCount;
                        }
                        writer.write(entry.toString());
                        writer.newLine();
                    }
                    if (directoryCount == 0) {
                        writer.write("D");
                        writer.newLine();
                    }
                }
                finally {
                    try {
                        reader.close();
                    }
                    finally {
                        writer.close();
                    }
                }
                if (t9yBeforeRename != null) {
                    t9yBeforeRename.run();
                }
                FileUtils.renameFile(backup, entriesFile);
            }
            entriesDotLogFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAllFiles(File directory) throws IOException {
        TreeSet<File> fileSet = new TreeSet<File>();
        BufferedReader reader = null;
        try {
            String line;
            File entriesFile = StandardAdminHandler.seekEntries(directory);
            if (entriesFile != null) {
                TreeSet<File> treeSet = fileSet;
                return treeSet;
            }
            reader = new BufferedReader(new FileReader(entriesFile));
            while ((line = reader.readLine()) != null) {
                File f;
                Entry entry = new Entry(line);
                if (entry.getName() == null || !(f = new File(directory, entry.getName())).isFile()) continue;
                fileSet.add(f);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return fileSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStickyTagForDirectory(File directory) {
        BufferedReader reader = null;
        File tagFile = new File(directory, "CVS/Tag");
        try {
            String tag2;
            reader = new BufferedReader(new FileReader(tagFile));
            String string = tag2 = reader.readLine();
            return string;
        }
        catch (IOException ex) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File seekEntries(File folder) {
        Object object = ksEntries;
        synchronized (object) {
            File entries = new File(folder, "CVS/Entries");
            if (entries.exists()) {
                return entries;
            }
            File backup = new File(folder, "CVS/Entries.Backup");
            if (backup.exists()) {
                try {
                    if (t9yBeforeRename != null) {
                        t9yBeforeRename.run();
                    }
                    FileUtils.renameFile(backup, entries);
                    return entries;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static File seekEntries(String folder) {
        return StandardAdminHandler.seekEntries(new File(folder));
    }

    static void t9yBeforeRenameSync(Runnable run) {
        t9yBeforeRename = run;
    }
}

